<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */
?>

@extends($ajaxCall)

@section("content")

    @include('general.tab-header', ['departmentName' => 'Revenue Target', 'moduleName' => 'Edit'])

    {!! Form::open(['method' => 'PUT', 'class' => 'form-horizontal', 'url' => url("/revenue-target/{$revenueTarget->id}")]) !!}

    <div class="col-lg-12">
        <div class="col-lg-4">
            <div class="col-lg-12 list-header">
                <div class="col-md-5 list">Base Period</div>
                <div class="col-md-7">
                    {!! Form::select('period_id', $periods, $revenueTarget->period_id, ['id' => 'period_id', 'class' => 'form-control', 'required' => 'required', 'disabled']) !!}
                </div>
            </div>

            <div class="col-lg-12 list-header">
                <div class="col-md-5 list">Report Type</div>
                <div class="col-md-7">
                    {!! Form::select('type_id', $reportTypes, $revenueTarget->type_id, ['id' => 'period_id', 'class' => 'form-control', 'required' => 'required', 'disabled']) !!}
                </div>
            </div>

            <div class="col-lg-12 list-header">
                <div class="col-md-5 list">@lang("content.from")</div>
                <div class="col-md-7">
                    {!! Form::text('period_from', $revenueTarget->period_from, ['class'=>'form-control', 'placeholder'=>'Period From', 'id'=>'period_from', 'required' => 'required', 'readonly']) !!}
                </div>
            </div>

            <div class="col-lg-12 list-header">
                <div class="col-md-5 list">@lang("content.to")</div>
                <div class="col-md-7">
                    {!! Form::text('period_to', $revenueTarget->period_to, ['class'=>'form-control', 'placeholder'=>'Period To', 'id'=>'period_to', 'required' => 'required', 'readonly']) !!}
                </div>
            </div>


            <div class="col-lg-12 list-header">
                <div class="col-md-5 list">Target</div>
                <div class="col-md-7">
                    {!! Form::input('text', 'target', number_format($revenueTarget->target), ['class'=>'form-control', 'placeholder'=>'Target', 'id'=>'target', 'required' => 'required']) !!}
                </div>
            </div>

        </div>

        <div class="col-lg-12 list-header">
            {!! Form::submit('Save Changes', [ 'name' => 'insert', 'class' => 'btn btn-warning']) !!}
        </div>
    </div>

    {!! Form::close() !!}

@stop

@section('js_scripts')
    <script src="{{ asset("/assets/js/views/revenue-target/create.js") }} "></script>
@stop
