<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */
?>

@include('general.tab-header', ['departmentName' => 'Revenue Target', 'moduleName' => 'Edit'])

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

        {!! Form::open(['method' => 'PUT', 'class' => 'form-horizontal', 'url' => url("revenue-target/{$revenueTarget->id}"), 'id' => 'formEdit']) !!}

        <div class="col-lg-12">
            <div class="col-lg-4">
                {{ debug($quarterTargets) }}
                @include('revenue-target/layouts/form-yearly-target', [
                    'period'                        => $revenueTarget->period_id,
                    'period_disabled'               => true,
                    'organization_level'            => $revenueTarget->organization->organizationLevel->id,
                    'organization_level_disabled'   => true,
                    'organization_id'               => $revenueTarget->organization_id,
                    'organization_id_disabled'      => true,
                    'target'                        => $revenueTarget->target,
                    'quarterTargets'                => $quarterTargets
                ])
            </div>

            <div class="col-lg-4">
                @include('revenue-target/layouts/form-quarterly-target', ['quarterTargets'  => $quarterTargets])
            </div>

            <div class="col-lg-4">
                @include('revenue-target/layouts/form-quarterly-target', ['quarters' => [3,4]])
            </div>

            <div class="col-lg-12 list-header">
                <a class="btn btn-default" href="{{ url('/revenue-target') }}">@lang("content.back")</a>
                {!! Form::submit(trans("content.save"), [ 'name' => 'save', 'class' => 'btn btn-warning']) !!}
            </div>
        </div>

        {!! Form::close() !!}

    </article>

</div>

</section>






<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#formApply");

        $(document).ready(function () {
            $('#period_id').trigger('change');
        });

        $("form").on('submit', function(){
            if (CheckAllExceedings()) {
                return true;
            }

            return false;
        });
    };

    loadScript("{{ asset("/assets/js/views/revenue-target/create.js") }}", pagefunction);

</script>
