@if (count($revenue_targets_periods))
    <div class="list-my-group">
        <div class="head">
            <div>
                <div style="width: 5%">No.</div>
                <div style="width: 15%">@lang("content.from")</div>
                <div style="width: 15%">@lang("content.to")</div>
                <div style="width: 15%">Target</div>
                <div style="width: 15%">Accountable</div>
                <div style="width: 20%">@lang("content.actions")</div>
            </div>
        </div>
        <div class="body">
            @foreach($revenue_targets_periods as $i => $each)
                @php $picture = !is_null($each->thumb) ? $each->thumb : 'profile.png'; @endphp
                @php $user = $each->organization ? $each->organization->user : null @endphp
                <div>
                    <div style="width: 5%; min-width: 5%">{{ $i + 1 }}</div>
                    <div style="width: 15%; min-width: 15%">{{ baseDateFormat($each->period_from) }}</div>
                    <div style="width: 15%; min-width: 15%">{{ baseDateFormat($each->period_to) }}</div>
                    <div style="width: 15%; min-width: 15%">{{ number_format($each->target)." ".$each->currency->code }}</div>
                    @if ($user)
                        <div style="width: 15%; min-width: 15%">{{ $user->first_name.' '.$user->last_name }}</div>
                    @endif
                    <div style="width: 20%; min-width: 20%">
                        {!! Form::open(['method' => 'DELETE', 'class' => 'form-horizontal', 'url' => url("/revenue-target-period/{$each->id}") , 'id' => 'formDeletePeriod']) !!}
                            <a target="_blank" href="{{ route('homepage')."#".url("/revenue-target-period/{$each->id}/edit") }}" class="btn btn-warning">@lang("content.edit")</a>
                            {!! Form::submit('Delete', [ 'name' => 'delete', 'class' => 'btn btn-danger']) !!}
                        {!! Form::close() !!}
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@endif