<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */
?>





@include('general.tab-header', ['departmentName' => 'Revenue Target', 'moduleName' => 'Edit Period'])

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            {!! Form::open(['method' => 'PUT', 'class' => 'form-horizontal', 'url' => url("/revenue-target-period/{$period->id}"), 'id' => 'formEdit']) !!}

            <div class="col-lg-12">
                <div class="col-lg-4">
                    <div class="col-lg-12 list-header">
                        <div class="col-md-5 list">@lang("content.from")</div>
                        <div class="col-md-7">
                            {!! Form::text('period_from', $period->period_from, ['class'=>'form-control datepicker', 'placeholder'=>'Period From', 'id'=>'period_from', 'required' => 'required']) !!}
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-5 list">@lang("content.to")</div>
                        <div class="col-md-7">
                            {!! Form::text('period_to', $period->period_to, ['class'=>'form-control', 'placeholder'=>'Period To', 'id'=>'period_to', 'required' => 'required', 'readonly']) !!}
                        </div>
                    </div>


                    <div class="col-lg-12 list-header">
                        <div class="col-md-5 list">Target</div>
                        <div class="col-md-7">
                            {!! Form::input('text', 'target', number_format($period->target), ['class'=>'form-control', 'placeholder'=>'Target', 'id'=>'target', 'required' => 'required']) !!}
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-5 list">Currency</div>
                        <div class="col-md-7">
                            {!! Form::select('currency_id', $currencies, $period->currency_id, ['class' => 'form-control', 'required' => 'required']) !!}
                        </div>
                    </div>

                </div>

                <div class="col-lg-12 list-header">
                    {!! Form::submit('Save Changes', [ 'name' => 'insert', 'class' => 'btn btn-warning']) !!}
                </div>
            </div>

            {!! Form::close() !!}

        </article>

    </div>

</section>






<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#formApply");
    };

    loadScript("{{ asset("/assets/js/views/revenue-target/create.js") }}", pagefunction);

</script>
