<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Commercial', 'moduleName' => 'Revenue Data | Ticket Number Search'])

            <div>
                <div class="col-md-3">
                    @php $agencyCode = isset($passengerFlights[0]) && $passengerFlights[0] && $passengerFlights[0]->passengerOrder ? $passengerFlights[0]->passengerOrder->agencyCode : null @endphp

                    <div class="panel panel-primary" style="">
                        <div class="panel-heading" style="position: relative;overflow:hidden; ">
                            <h3 class="panel-title">
                                @if ($agencyCode && ($agencyCode->agency || $agencyCode->city))
                                    <span style="float: left">{{ $agencyCode && $agencyCode->agency ? $agencyCode->agency->agency : '' }}</span>
                                    <span style="float: right; font-weight: bold">{{ $agencyCode && $agencyCode->city   ? $agencyCode->city->city     : '' }}</span>
                                @else
                                    <span style="float: left">{{ getAgencyCode($agencyCode) }}</span>
                                @endif
                            </h3>
                        </div>
                        <div class="panel-body">
                            <div style="width: 100%; margin: 0 auto;">
                                <div style="margin: 0 0 10px 0; text-align: center">
                                    <img src="{{ asset("/assets/img/company_logo.png") }}" alt="Profile Image" class="img-thumbnail" style="max-height: 200px;" >
                                </div>

                                <div style="float: left; width:100%;">

                                    <table class="table table-bordered table-striped table-hover" style="width:100%; padding: 0; margin: 0">
                                        <thead>
                                            <tr>
                                                <th colspan="2">AGENCY INFO</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @if ($agencyCode && $agencyCode->agency)
                                            <tr>
                                                <td class="header_profile">ID</td>
                                                <td>{{ $agencyCode && $agencyCode->agency ? $agencyCode->agency->id : "" }}</td>
                                            </tr>
                                            <tr>
                                                <td class="header_profile">@lang("content.name")</td>
                                                <td><a target="_blank" href="{{ route("homepage")."#". url('agency').'/'.$agencyCode->agency->id }}">{{ $agencyCode && $agencyCode->agency_id ? $agencyCode->agency->agency : '' }}</a></td>
                                            </tr>
                                        @endif

                                        @if ($agencyCode && $agencyCode->city)
                                            <tr>
                                                <td class="header_profile">@lang("content.city")</td>
                                                <td>{{ $agencyCode && $agencyCode->city ? $agencyCode->city->city : '' }}</td>
                                            </tr>
                                        @endif

                                        @if ($agencyCode && $agencyCode->country)
                                            <tr>
                                                <td class="header_profile">@lang("content.country")</td>
                                                <td>{{ $agencyCode && $agencyCode->country ? $agencyCode->country->country : '' }}</td>
                                            </tr>
                                        @endif

                                        @if ($agencyCode && $agencyCode->phone)
                                        <tr>
                                            <td class="header_profile">@lang("content.phone")</td>
                                            <td>{{ $agencyCode && $agencyCode->phone }}</td>
                                        </tr>
                                        @endif
                                        </tbody>
                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-9">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-online" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                            <h2>@lang("content.list")</h2>
                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->

                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body no-padding" style="min-height: 50px !important;">

                                <div class="table-responsive">

                                    <table class="table table-striped table-bordered table-hover" id="ticketTable">
                                        <thead>
                                        <tr>
                                            <th>No</th>
                                            <th>@lang("content.flight_number")</th>
                                            <th>@lang("content.sector")</th>
                                            <th>@lang("content.departure_date")</th>
                                            <th>@lang("content.coupon")</th>
                                            <th>@lang("content.status")</th>
                                            <th>@lang("content.fare")(USD)</th>
                                            <th>@lang("content.fare_basis")</th>
                                            <th>@lang("content.sales_date")</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($passengerFlights as $i => $each)
                                            <tr>
                                                <td>{{ $i + 1 }}</td>
                                                <td>{{ $each->flightNumber ? $each->flightNumber->flight_number_iata : ""}}</td>
                                                <td>{{ getSector($each->flightNumber) }}</td>
                                                <td>{{ $each->departure_date }}</td>
                                                <td>{{ $each->coupon }}</td>
                                                <td>{{ $each->flightOrderStatus ? $each->flightOrderStatus->order_status : ""}}</td>
                                                <td>{{ $each->fare ? number_format($each->fare) : ""}}</td>
                                                <td>{{ $each->flightFareBasis ? $each->flightFareBasis->fare_basis : ""}}</td>
                                                <td>{{ $each->sales_date }}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#ticketTable");

    };

    pagefunction();

</script>
