<?php
/**
 * Created by PhpStorm.

 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>


<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include("revenue-data.index-form")

            <div class="clearfix"></div>

            <div>
                @if (!$cacheQuery)
                    <div class="alert alert-success" style="display: block; height: 50px">
                        <span style="float: left">
                            Found: <h5 class="info">{{ number_format($total->pax) }} Records.</h5>
                        </span>
                        <span style="float: right">
                            Revenue: <h5 class="info">${{ number_format($total->revenue) }}</h5>
                            PAX: <h5 class="info">{{ number_format($total->pax) }}</h5>
                            Yield: <h5 class="info">${{ $total->pax > 0 ? number_format($total->revenue / $total->pax) : 0 }}</h5>
                        </span>
                    </div>
                @endif

                @if (count($tableData))
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                        <!-- widget options:
                        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        data-widget-colorbutton="false"
                        data-widget-editbutton="false"
                        data-widget-togglebutton="false"
                        data-widget-deletebutton="false"
                        data-widget-fullscreenbutton="false"
                        data-widget-custombutton="false"
                        data-widget-collapsed="true"
                        data-widget-sortable="false"

                        -->
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                            <h2>List </h2>

                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->

                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body no-padding" style="overflow:auto; width: 100%">

                                <table id="revenueTable" class="table table-striped table-hover table-bordered">
                                    <thead>
                                    <tr>
                                        <th>No.</th>
                                        <th style="min-width: 60px;">@lang("content.sales_date")</th>
                                        <th>@lang("content.first_name")</th>
                                        <th>@lang("content.last_name")</th>
                                        <th>@lang("content.ticket_number")</th>
                                        <th>@lang("content.departure_date")</th>
                                        <th>@lang("content.flight_number")</th>
                                        <th style="min-width: 60px;">@lang("content.sector")</th>
                                        <th>@lang("content.fare_basis")</th>
                                        <th>RBD</th>
                                        <th>@lang("content.status")</th>
                                        <th>@lang("content.currency")</th>
                                        <th>@lang("content.fare")</th>
                                        {{--<th>Fare(Local)</th>--}}
                                        <th>IATA/TCH</th>
                                        <th>@lang("content.country")</th>
                                        <th>@lang("content.city")</th>
                                        <th>@lang("content.agency")</th>
                                        <th>@lang("content.status")</th>
                                        <th>@lang("content.coupon")</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($tableData as $i => $each)
                                        @php $flightNumber =  $each->flightNumber @endphp

                                        @php $agencyCode = $each->passengerOrder->agencyCode @endphp

                                        @php $sector = "" @endphp
                                        @if ($flightNumber->departureAirport)
                                            @php $sector .= $flightNumber->departureAirport->iata."-" @endphp
                                        @else
                                            @php $sector .= "N/A-" @endphp
                                        @endif

                                        @if ($flightNumber->arrivalAirport)
                                            @php $sector .= $flightNumber->arrivalAirport->iata @endphp
                                        @else
                                            @php $sector .= "N/A" @endphp
                                        @endif

                                        <tr>
                                            <td>{{ ( ($page - 1) * $recordsPerPage) + $i + 1 }}</td>
                                            <td>{{ date("Y-m-d", strtotime($each->sales_date)) }}</td>

                                            @php $passengerLink = getPassengerLink($each['passenger_id']) @endphp
                                            <td data-left><a target="_blank" href="{{ $passengerLink }}">{{ $each->first_name }}</a></td>
                                            <td data-left><a target="_blank" href="{{ $passengerLink }}">{{ $each->last_name }}</a></td>

                                            <td><a target="_blank"
                                                   href='{{ route("homepage")."#". url("revenue-data/ticket-number/{$each->ticket_number}") }}'>{{ $each->ticket_number }}</a>
                                            </td>
                                            <td>{{ $each->departure_date ? date("Y-m-d", strtotime($each->departure_date)) : ($each->departure ? date("Y-m-d", strtotime($each->departure)) : "" ) }}</td>

                                            @if ($each->flight_id)
                                                <td>
                                                    <a target="_blank" href='{{ url("flight-info/handling/{$each->flight_id}") }}'>{{ $flightNumber->flight_number }}</a>
                                                </td>
                                            @else
                                                <td>{{ $flightNumber->flight_number }}</td>
                                            @endif

                                            @php $orderStatus = null @endphp
                                            <td data-left>{{ $sector }}</td>
                                            <td data-left>{{ $each->flightFareBasis ? $each->flightFareBasis->fare_basis : ''}}</td>
                                            <td>{{ $each->flightRbd ? $each->flightRbd->rbd : ''}}</td>
                                            <td data-left>{{ $each->flightOrderStatus ? $orderStatus = $each->flightOrderStatus->order_status : ''}}</td>
                                            <td data-right>{{ $each->currency }}</td>
                                            <td data-right>{{ ($orderStatus && $orderStatus == "R" ? -1 : 1 ) * number_format($each->fare) }}</td>
{{--                                            <td data-right>{{ number_format($each->original_fare) ." ". ( $each->original_currency ? $each->original_currency : '') }}</td>--}}
                                            <td data-left>{{ getAgencyCode($agencyCode) }}</td>

                                            @if ($agencyCode && $agencyCode->country)
                                                <td data-left style="padding: 0 4px; vertical-align: middle"><img src="{{ asset("/assets/img/icons/flags/24/{$agencyCode->country->country}.png") }}"/>
                                                    <a target="_blank"
                                                       href='{{ route("homepage")."#". url("country/{$agencyCode->country_id}") }}'>{{ $agencyCode->country->country }}</a>
                                                </td>
                                            @else
                                                <td data-left></td>
                                            @endif

                                            <td data-left>{{ $agencyCode && $agencyCode->city ? $agencyCode->city->city : '' }}</td>
                                            @if ($agencyCode && $agencyCode->agency)
                                                <td data-left><a target="_blank"
                                                                 href='{{ route("homepage")."#". url("agency/{$agencyCode->agency_id}") }}'>{{ $agencyCode->agency->agency }}</a>
                                                </td>
                                            @else
                                                <td data-left></td>
                                            @endif
                                            <td>{{ $each->flightOrderStatus ? $each->flightOrderStatus->order_status : "" }}</td>
                                            <td>{{ $each->coupon }}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>

                            </div>

                        </div>

                    </div>
                @endif
                {!! $pagination ? $tableData->appends($_GET)->render() : '' !!}
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#revenueTable");
    };

    pagefunction();


</script>
