<?php
/**
 * Created by PhpStorm.

 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>


        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include("revenue-data.index-form")

            <div class="clearfix"></div>

            <div>
                @php $totalRevenue = 0 @endphp
                @php $totalPax = 0 @endphp

                @if (count($tableData))
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                        <!-- widget options:
                        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        data-widget-colorbutton="false"
                        data-widget-editbutton="false"
                        data-widget-togglebutton="false"
                        data-widget-deletebutton="false"
                        data-widget-fullscreenbutton="false"
                        data-widget-custombutton="false"
                        data-widget-collapsed="true"
                        data-widget-sortable="false"

                        -->
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                            <h2>List </h2>

                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->

                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body no-padding" style="overflow:auto; width: 100%">

                                 <table id="revenueTable" class="table table-striped table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <th>No.</th>
                                        @if (isset($report_type) && $report_type)
                                            @php $str = strtolower(str_replace(" ", "_", $report_type->type)) @endphp
                                            <th>@lang("content.{$str}")</th>
                                        @else
                                            <th>@lang("content.period")</th>
                                        @endif
                                        <th>@lang("content.revenue")</th>
                                        <th>PAX</th>
                                        <th>@lang("content.yield")</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($tableData as $i => $each)
                                        @php $totalRevenue += $each->revenue @endphp
                                        @php $totalPax += $each->pax @endphp
                                        <tr>
                                            <td>{{ ( ($page - 1) * $recordsPerPage) + $i + 1 }}</td>

                                            <td>{{ $report_type->label." "}}
                                                @if ($report_type->id == 5)
                                                    {{ jddayofweek($each->period, 1) }}
                                                @elseif ($report_type->id == 6)
                                                    {{ baseDateFormat($each->period) }}
                                                @else
                                                    {{ $each->period }}
                                                @endif
                                            </td>
                                            <td>{{ number_format($each->revenue) }}</td>
                                            <td>{{ number_format($each->pax) }}</td>
                                            <td>{{ $each->pax ? number_format($each->revenue / $each->pax) : 0 }}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>

                            </div>

                        </div>

                    </div>
                @endif

                <div class="alert alert-success" style="display: block; height: 50px">
                    <span style="float: left">
                        Found: <h5 class="info">{{ number_format($totalPax) }} Records.</h5>
                    </span>
                    <span style="float: right">
                        Revenue: <h5 class="info">{{ number_format($totalRevenue) }}$</h5>
                        PAX: <h5 class="info">{{ number_format($totalPax) }}</h5>
                        Yield: <h5 class="info">{{ $totalPax > 0 ? number_format($totalRevenue / $totalPax) : 0 }}$</h5>
                    </span>
                </div>

                {!! $pagination ? $tableData->render() : '' !!}
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#revenueTable");

    };

    pagefunction();

</script>
