<?php
/**
 * Created by PhpStorm.

 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>


        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include("revenue-data.index-form")

            <div class="clearfix"></div>

            <div style="overflow: auto; max-height: 800px">

                @if (count($tableData))
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                        <!-- widget options:
                        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        data-widget-colorbutton="false"
                        data-widget-editbutton="false"
                        data-widget-togglebutton="false"
                        data-widget-deletebutton="false"
                        data-widget-fullscreenbutton="false"
                        data-widget-custombutton="false"
                        data-widget-collapsed="true"
                        data-widget-sortable="false"

                        -->
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                            <h2>List </h2>

                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->

                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body no-padding" style="overflow:auto; width: 100%">

                                 <table id="revenueTable" class="table table-striped table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <th rowspan="3">No.</th>
                                        <th rowspan="3" style="min-width: 250px">POS</th>
                                        <th colspan="{{ 3 * ( count($unique_periods) + 1) }}">{{ $report_type ? $report_type->type : "" }}</th>
                                    </tr>
                                    <tr>
                                        <th colspan="3" style="">@lang("content.total")</th>
                                        @foreach($unique_periods as $each)
                                            @if ($report_type && $report_type->type != "Weekly")
                                                <th colspan="3">{{ convertMonthNumberToName($each) }}</th>
                                                @continue
                                            @endif
                                            <th colspan="3">{{ $each }}</th>

                                        @endforeach
                                    </tr>
                                    <tr>
                                        <th style="">PAX</th>
                                        <th style="">@lang("content.revenue")</th>
                                        <th style="">@lang("content.yield")</th>

                                        @for($j = 0; $j < count($unique_periods); $j++)
                                            <th>PAX</th>
                                            <th>@lang("content.revenue")</th>
                                            <th>@lang("content.yield")</th>
                                        @endfor
                                    </tr>
                                    </thead>
                                    <tbody>

                                    <tr>
                                        @php $grand_total_pax = isset($tableData['pax']['total']) ? $tableData['pax']['total'] : 0 @endphp
                                        @php $grand_total_revenue = isset($tableData['revenue']['total']) ? $tableData['revenue']['total'] : 0 @endphp
                                        @php $grand_total_yield = $grand_total_pax ? $grand_total_revenue / $grand_total_pax : 0 @endphp

                                        <td></td>
                                        <td class="td_header">TOTAL:</td>
                                        {{--Grand Total Figures--}}
                                        <td class="td_header">{{ number_format($grand_total_pax) }}</td>
                                        <td class="td_header">{{ number_format($grand_total_revenue) }}</td>
                                        <td class="td_header">{{ number_format($grand_total_yield) }}</td>

                                        @foreach($unique_periods as $period)
                                            @php $pax = isset($tableData['pax'][$period]) ? $tableData['pax'][$period] : 0 @endphp
                                            @php $revenue = isset($tableData['revenue'][$period]) ? $tableData['revenue'][$period] : 0 @endphp
                                            @php $yield = $pax ? $revenue / $pax : 0 @endphp

                                            {{--Total Period Figures--}}
                                            <td class="td_header">{{ number_format($pax) }}</td>
                                            <td class="td_header">{{ number_format($revenue) }}</td>
                                            <td class="td_header">{{ number_format($yield) }}</td>
                                        @endforeach
                                    </tr>


                                    @php $period_total_pax = [] @endphp
                                    @php $period_total_revenue = [] @endphp

                                    @foreach($unique_pos as $i => $pos)
                                        @php $country = isset($tableData[$pos]['country']) ? $tableData[$pos]['country'] : "" @endphp
                                        @php $country_id = isset($tableData[$pos]['country_id']) ? $tableData[$pos]['country_id'] : "" @endphp
                                        @php $agency_id = isset($tableData[$pos]['agency_id']) ? $tableData[$pos]['agency_id'] : "" @endphp
                                        @php $city = isset($tableData[$pos]['city']) ? ", ".$tableData[$pos]['city'] : "" @endphp
                                        @php $total_pax = isset($tableData[$pos]['pax']['total']) ? $tableData[$pos]['pax']['total'] : 0 @endphp
                                        @php $total_revenue = isset($tableData[$pos]['revenue']['total']) ? $tableData[$pos]['revenue']['total'] : 0 @endphp
                                        @php $total_yield = $total_pax ? $total_revenue / $total_pax : 0 @endphp
                                        <tr>
                                            <td>{{ ( ($page - 1) * $recordsPerPage) + $i + 1 }}</td>
                                            <td data-left style="padding: 0 4px; vertical-align: middle">
                                                @if ($country_id)
                                                    <a target="_blank" href='{{ route("homepage")."#". url("country/{$country_id}") }}'>
                                                        <img style="" src="{{ asset("/assets/img/icons/flags/24/{$country}.png") }}" />
                                                    </a>
                                                @endif

                                                @if ($agency_id)
                                                    <a target="_blank" href='{{ route("homepage")."#". url("agency/{$agency_id}") }}'>{{ $pos }}</a>
                                                @else
                                                    <a target="_blank" href='{{ route("homepage")."#". url("country")."/".$country_id.$strInputs }}'>{{ $pos }}</a>
                                                @endif
                                                {{ $city }}
                                            </td>

                                            {{--Total By POS--}}
                                            <td>{{ number_format($total_pax) }}</td>
                                            <td>{{ number_format($total_revenue) }}</td>
                                            <td>{{ number_format($total_yield) }}</td>

                                            @foreach($unique_periods as $period)
                                                @if (isset($tableData[$pos]['pax'][$period]))
                                                    @php $pax = $tableData[$pos]['pax'][$period] @endphp
                                                    @php $revenue = $tableData[$pos]['revenue'][$period] @endphp
                                                    @php $yield = $pax ? $revenue / $pax : 0 @endphp

                                                    <td>{{ number_format($pax) }}</td>
                                                    <td>{{ number_format($revenue) }}</td>
                                                    <td>{{ is_numeric($yield) ? number_format($yield) : $yield }}</td>
                                                @else
                                                    <td>0</td>
                                                    <td>0</td>
                                                    <td>0</td>
                                                @endif
                                            @endforeach
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>

                            </div>

                        </div>

                    </div>
                @endif

                <div class="alert alert-success" style="display: block; height: 50px">
                    <span style="float: left">
                        Found: <h5 class="info">{{ isset($grand_total_pax) ? number_format($grand_total_pax) : 0 }} Records.</h5>
                    </span>
                    <span style="float: right">
                        Revenue: <h5 class="info">{{ isset($grand_total_revenue) ? number_format($grand_total_revenue) : 0 }}$</h5>
                        PAX: <h5 class="info">{{ isset($grand_total_pax) ? number_format($grand_total_pax) : 0 }}</h5>
                        Yield: <h5 class="info">{{ isset($grand_total_pax) ? (is_numeric($grand_total_yield) ? number_format($grand_total_yield) : 0) : 0 }}$</h5>
                    </span>
                </div>

                {!! $pagination ? $tableData->render() : '' !!}
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#revenueTable");

    };

    pagefunction();
</script>
