<?php
/**
 * Created by PhpStorm.

 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>


        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include("revenue-by-flight.layouts.index-form")

            <div class="clearfix"></div>

            <div>
                @php $totalRevenue = 0 @endphp
                @php $totalPax = 0 @endphp

                @if (count($tableData))
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                        <!-- widget options:
                        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        data-widget-colorbutton="false"
                        data-widget-editbutton="false"
                        data-widget-togglebutton="false"
                        data-widget-deletebutton="false"
                        data-widget-fullscreenbutton="false"
                        data-widget-custombutton="false"
                        data-widget-collapsed="true"
                        data-widget-sortable="false"
                        -->
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                            <h2>List </h2>

                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->

                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body no-padding" style="overflow:auto; width: 100%">

                                 <table id="revenueTable" class="table table-striped table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <th>No.</th>
                                        <th>@lang("content.flight_number")</th>
                                        <th>@lang("content.sector")</th>
                                        <th>STD (UTC)</th>
                                        <th>ATD (UTC)</th>
                                        <th>PAX</th>
                                        <th>@lang("content.revenue")</th>
                                        <th>@lang("content.yield")</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @php $airline = env(IATA_CODE) @endphp

                                    @foreach($tableData as $i => $each)
                                        {{ debug($each) }}
                                        @php $totalRevenue += $each->revenue @endphp
                                        @php $totalPax += $each->pax @endphp
                                        @php $departure = $each->std ? $each->std : $each->departure @endphp

                                        @php $flightInfoURL = $each->flight_id ? url("flight-info/handling/{$each->flight_id}") : "#" @endphp
                                        @php $flightTrackerURL = $each->flight_id ? url("flight-tracker/{$each->flight_id}") : "#" @endphp

                                        @php $url = route("homepage")."#passenger/list?departure_from=".date("Y-m-d", strtotime($departure)) @endphp

                                        {{--@if ($each->flight_id)--}}
                                            {{--@php $url .= "&flight_id=".$each->flight_id @endphp --}}
                                        {{--@else--}}
                                            {{--@php $url .= "&flight_id_is_null=1" @endphp --}}
                                        {{--@endif--}}

                                        @if ($each->flight_number_id)
                                            @php $url .= "&flight_number=".$each->flight_number_id @endphp
                                        @endif

                                        <tr>
                                            <td data-center>{{ ( ($page - 1) * $recordsPerPage) + $i + 1 }}</td>
                                            @if ($each->flight_id)
                                                <td data-center><a target="_blank" href="{{ $flightInfoURL }}">{{ $airline." ". $each->flight_number }}</a></td>
                                                <td data-center><a target="_blank" href="{{ $flightTrackerURL }}">{{ $each->sector }}</a></td>
                                            @else
                                                <td data-center>{{ $airline." ".$each->flight_number }}</td>
                                                <td data-center>{{ $each->sector }}</td>
                                            @endif

                                            <td data-center>{{ $departure ? baseDateFormat($departure, true) : "" }}</td>
                                            <td data-center>{{ $each->atd ? baseDateFormat($each->atd, true) : "" }}</td>

                                            <td data-right>
                                                <a target="_blank" href="{{ $url }}">{{ number_format($each->pax) }}</a>
                                            </td>
                                            <td data-right>
                                                <a target="_blank" href="{{ $url }}">{{ number_format($each->revenue) }}</a>
                                            </td>
                                            <td data-right>
                                                <a target="_blank" href="{{ $url }}">{{ $each->pax ? number_format($each->revenue / $each->pax) : 0 }}</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endif

                <div class="alert alert-success" style="display: block; height: 50px">
                    <span style="float: left">
                        Found: <h5 class="info">{{ number_format($totalPax) }} Records.</h5>
                    </span>
                    <span style="float: right">
                        PAX: <h5 class="info">{{ number_format($totalPax) }}</h5>
                        Revenue: <h5 class="info">{{ number_format($totalRevenue) }}$</h5>
                        Yield: <h5 class="info">{{ $totalPax > 0 ? number_format($totalRevenue / $totalPax) : 0 }}$</h5>
                    </span>
                </div>

                {!! $pagination ? $tableData->render() : '' !!}
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#revenueTable");

    };

    pagefunction();

</script>
