@extends($ajaxCall)

@section("content")

<ul class="breadcrumb">
    <li class="active"><span class="department_title">Reports | </span><span class="department_page">@lang("content.revenue")</span></li>
</ul>

<?php
    $period_labels = array('None' => 'None', 0=>'Yearly', 1=>'Quarterly',2=> 'Monthly',3=> 'Weekly',4=> 'Weekdays', 5=>'Daily', 6=> 'Flight Number', 7=>'Sector', 8=>'Sales Date', 9=>'Agency');
    $period_columns = array('None' => 'None', 0=>'Year', 1=>'Quarter',2=> 'Month',3=> 'Weekly',4=> 'Weekdays', 5=>'Daily', 6=> 'Flight Number', 7=>'Sector', 8=>'Sales Date', 9=>'Agency');

    $selected_year = date('Y', strtotime($date_from));
    $data1 = "";    $data2 = "";    $data3 = "";    $data4 = "";

    $select_fields = [];
    if (!is_null($final_data)){
        foreach($final_data as $index=>$each){
            list($selected_period, $from, $to) = periodText($period, $date_from,$date_to, $months, $weekday, $selected_year, $each->date);

            $ind = "selected_".$index;
            $select_labels = "";
            $agency_country  =(isset($each->country)) ? $each->country : null;
            $agency_city  =(isset($each->city)) ? $each->city : null;
            $agency_name  =(isset($each->agency)) ? $each->agency : null;
            $report_category  =(isset($each->report_category)) ? $each->report_category : null;
            $agency_info = checkAgencySelected($agency_country, $agency_city, $agency_name);

            foreach($agency_info as $agen){
                if (!is_null($agen))
                    $select_labels .= $agen;
            }

            if ($select_labels == ""){
                   if ($report_category == null){
                        $select_labels = $selected_period;
                   }
                   else {
                        if ($period == 0)
                            $select_labels = $report_category;
                        else
                            $select_labels = $selected_period." ".$report_category;
                   }
               }


            $select_fields[$ind] = $select_labels;
        }
    }
?>

<div class="tabbable"> <!-- Only required for left/right tabs -->
  <ul class="nav nav-tabs">
    <li class="active"><a href="#tab1" data-toggle="tab">Analysis</a></li>
    <li><a href="#tab2" data-toggle="tab" id="graphs">Graphs</a></li>
  </ul>
  <div class="tab-content">
    <div class="tab-pane active" id="tab1" style="padding-top: 10px;">

<div class="col-lg-12">



<form class="form-inline" method="get">
<div class="float">
        <label class="control-label">Report Type</label>
        {!! Form::select('report_type', $report_types, $period, ['class'=>'singleselect', 'id'=>'report_type']) !!}

         <label class="control-label">@lang("content.period")</label>
        {!! Form::select('period', $period_labels, $period, ['class'=>'singleselect', 'id'=>'period']) !!}
        <button class="btn btn-primary multiselect-toggle" id="period_btn">Select All</button>

        <div class="form-group" style="margin-bottom: 5px">
            <div class="form-group">
                <label class="control-label">@lang("content.country")</label>
                {!! Form::select('country[]', $countries, $country, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'country']) !!}
                <button class="btn btn-primary multiselect-toggle" id="country_btn">Select All</button>
            </div>
             <div class="form-group">
                <label class="control-label">@lang("content.city")</label>
                {!! Form::select('city[]', $cities, $city, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'city']) !!}
                <button class="btn btn-primary multiselect-toggle" id="city_btn">Select All</button>
            </div>
             <div class="form-group">
                <label class="control-label">@lang("content.agency")</label>
                {!! Form::select('agency[]', $agencies, $agency, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'agency']) !!}
                <button class="btn btn-primary multiselect-toggle">Select All</button>
            </div>
        </div>
</div>

@if(!is_null($final_data))
<div class="float">
    <label class="control-label">Select</label>
    <div class="btn-group">
        {!! Form::select('total_type', ['Total', 'Outbound', 'Inbound'], null, ['class'=>'singleselect', 'id'=>'total_type']) !!}

        {{--<label form="selected_period">{!!$period_columns[$period]!!}</label>--}}
        {!! Form::select('selected_period', $select_fields, null, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'flight_type']) !!}
        <button class="btn btn-primary multiselect-toggle" id="selected_period_btn">Select All</button>
    </div>
</div>
@endif

<div class="float">
        <div class="form-group margin_right">
            <label form="from_date">@lang("content.from")</label>
            {!! Form::text('from_date', $date_from, ['class'=>'form-control datetimepicker', 'placeholder'=>'From Date', 'id'=>'from_date']) !!}
        </div>
        <div class="form-group" style="margin-right: 20px">
            <label form="to_date">@lang("content.to")</label>
            {!! Form::text('to_date', $date_to, ['class'=>'form-control datetimepicker', 'placeholder' => 'To Date', 'id'=>'to_date']) !!}
        </div>

        <div class="form-group">
            <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
        </div>

</div>
    </form>


</div>


@if(!is_null($final_data))

<div class="col-lg-12 container" style='margin: 20px 0 0 0; padding: 0; overflow-x: auto'>

<table class="tablesorter table table-bordered table-striped table-hover">
<thead>
<tr>
    <th rowspan="2" colspan="2" class="text-center" style="vertical-align: middle">TOTAL NETWORK</th>
    <th colspan='27' class="text-center outbound">@lang("content.outbound")</th>
    <th colspan='27' class="text-center inbound">@lang("content.inbound")</th>
    <th colspan='27' class="text-center total">@lang("content.total")</th>
</tr>

<tr>
    <th colspan="9" class="text-center outbound capacity">Capacity</th>
    <th colspan="9" class="text-center outbound">@lang("content.business")</th>
    <th colspan="9" class="text-center outbound">@lang("content.economy")</th>
    <th colspan="9" class="text-center outbound">@lang("content.total")</th>

    <th colspan="9" class="text-center inbound capacity">Capacity</th>
    <th colspan="9" class="text-center inbound">@lang("content.business")</th>
    <th colspan="9" class="text-center inbound">@lang("content.economy")</th>
    <th colspan="9" class="text-center inbound">@lang("content.total")</th>

    <th colspan="9" class="text-center total capacity">Capacity</th>
    <th colspan="9" class="text-center total">@lang("content.business")</th>
    <th colspan="9" class="text-center total">@lang("content.economy")</th>
    <th colspan="9" class="text-center total">@lang("content.total")</th>
</tr>

    @php $classes = ['outbound', 'inbound', 'total']; @endphp


<tr>
    <th rowspan="2" class="text-center">№</th>
    <th rowspan="2" class="text-center">Conditions</th>
    @php $r = 0 @endphp
    @foreach($classes as $i=>$class)
        <th class="text-center {!!$class." match-".$r++!!} capacity" colspan="3">No of Flights</th>
        <th class="text-center {!!$class." match-".$r++!!} capacity" colspan="3">@lang("content.business")</th>
        <th class="text-center {!!$class." match-".$r++!!} capacity" colspan="3">@lang("content.economy")</th>

        <th class="text-center {!!$class." match-".$r++!!}" colspan="3">PAX</th>
        <th class="text-center {!!$class." match-".$r++!!}" colspan="3">@lang("content.revenue")</th>
        <th class="text-center {!!$class." match-".$r++!!}" colspan="3">@lang("content.yield")</th>

        <th class="text-center {!!$class." match-".$r++!!}" colspan="3">PAX</th>
        <th class="text-center {!!$class." match-".$r++!!}" colspan="3">@lang("content.revenue")</th>
        <th class="text-center {!!$class." match-".$r++!!}" colspan="3">@lang("content.yield")</th>

        <th class="text-center {!!$class." match-".$r++!!}" colspan="3">PAX</th>
        <th class="text-center {!!$class." match-".$r++!!}" colspan="3">@lang("content.revenue")</th>
        <th class="text-center {!!$class." match-".$r++!!}" colspan="3">@lang("content.yield")</th>
    @endforeach

</tr>

<tr>
    @foreach($classes as $class)
        @for($u = 0; $u < 9; $u++)
            @foreach($comparison_years as $i=>$each)
              <th class="text-center {!!$class." match-".$r++!!} @if ($i == 0) {!!'year1'!!} @else {!!'year2'!!} @endif">{!!$each!!}</th>
            @endforeach
            <th class="text-center {!!$class." match-".$r++!!} vly">VLY</th>
        @endfor
    @endforeach
</tr>
</thead>
<tbody>
@foreach($final_data as $index=>$each)

<?php
   list($selected_period, $from, $to) = periodText($period,$date_from, $date_to,$months, $weekday,$selected_year, $each->date,'comparison');
   $agency_country  =(isset($each->country)) ? $each->country : null;
   $agency_city  =(isset($each->city)) ? $each->city : null;
   $agency_name  =(isset($each->agency)) ? $each->agency : null;

   $report_category  =(isset($each->report_category)) ? $each->report_category : null;

   $agency_info = checkAgencySelected($agency_country, $agency_city, $agency_name);
   $ind = "selected_".$index;
   $select_labels = "";
   foreach($agency_info as $agen){
       if (!is_null($agen))
           $select_labels .= $agen;
   }

   if ($select_labels == ""){
       if ($report_category == null){
            $select_labels = $selected_period;
       }
       else {
            if ($period == 0)
                $select_labels = $report_category;
            else
                $select_labels = $selected_period." ".$report_category;
       }
   }



?>



    <tr class="{!!$ind!!}">
        <td>{!!$index+1!!}</td>
        <td>{!!$select_labels!!}</td>


        @foreach($flight_count_out_var as $j=>$item)
        @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"outbound capacity")!!}



        @foreach($config_out_c_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"outbound capacity")!!}


        @foreach($config_out_y_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"outbound capacity")!!}


        @foreach($flight_count_in_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"inbound capacity")!!}


        @foreach($config_in_c_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"inbound capacity")!!}


        @foreach($config_in_y_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"inbound capacity")!!}


        {!!printComparison($each->flight_count_total,"total capacity")!!}
        {!!printComparison($each->config_c_total,"total capacity")!!}
        {!!printComparison($each->config_y_total,"total capacity")!!}



        @foreach($pax_out_c_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"outbound")!!}


        @foreach($revenue_out_c_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"outbound")!!}

        @foreach($yield_out_c_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"outbound")!!}

        @foreach($pax_out_y_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"outbound")!!}


        @foreach($revenue_out_y_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"outbound")!!}

        @foreach($yield_out_y_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"outbound")!!}

        @foreach($pax_in_c_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"inbound")!!}


        @foreach($revenue_in_c_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"inbound")!!}

        @foreach($yield_in_c_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"inbound")!!}

        @foreach($pax_in_y_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"inbound")!!}

        @foreach($revenue_in_y_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"inbound")!!}

        @foreach($yield_in_y_var as $j=>$item)
            @php $vars[$j] = $each->$item; @endphp
        @endforeach
        {!!printComparison($vars,"inbound")!!}

        {!!printComparison($each->pax_c_total,"total")!!}
        {!!printComparison($each->revenue_c_total,"total")!!}
        {!!printComparison($each->yield_c_total,"total")!!}

        {!!printComparison($each->pax_y_total,"total")!!}
        {!!printComparison($each->revenue_y_total,"total")!!}
        {!!printComparison($each->yield_y_total,"total")!!}

        {!!printComparison($each->pax_out_total,"outbound")!!}
        {!!printComparison($each->pax_in_total,"inbound")!!}
        {!!printComparison($each->pax_total,"total")!!}

        {!!printComparison($each->revenue_out_total,"outbound")!!}
        {!!printComparison($each->revenue_in_total,"inbound")!!}
        {!!printComparison($each->revenue_total,"total")!!}

        {!!printComparison($each->yield_out_total,"outbound")!!}
        {!!printComparison($each->yield_in_total,"inbound")!!}
        {!!printComparison($each->yield_total,"total")!!}

{{--        {!!printComparison($each->sf_out,"outbound","%")!!}
        {!!printComparison($each->sf_in,"inbound","%")!!}
        {!!printComparison($each->sf,"total","%")!!}--}}

<?php

 //       $data1 .= "['".$selected_period."', ".implode(', ', $sf_out).", ".implode(', ', $sf_in).", ".implode(', ', $sf)."], ";
  //      $data2 .= "['".$selected_period."', ".implode(',', $revenue_c_total).", ".implode(',', $revenue_y_total).", ".implode(',', $revenue_total)."], ";
   //     $data3 .= "['".$selected_period."', ".implode(',', $revenue_out_total).", ".implode(',', $revenue_in_total).", ".implode(',', $revenue_total)."], ";
        //$data4 .= "['".$selected_period."', ".implode(',', $pax_out_total).", ".implode(',', $pax_in_total).", ".implode(',', $pax_total).", ".implode(',', $revenue_total/1000)."], ";
?>


    </tr>

@endforeach

</tbody>
</table>
</div>

<?php echo $booked_flights->appends($_GET)->render(); ?>


@endif

    </div>
    <div class="tab-pane" id="tab2" style="padding:0">
        <div class="col-lg-6" id="chart_pax_revenue" style="padding: 0; height: 400px; width: 50%"></div>
        <div class="col-lg-6" id="chart_revenue" style="padding: 0; height: 400px; width: 50%"></div>
        <div class="col-lg-6" id="chart_sf" style="padding: 0; height: 400px; width: 50%"></div>
        <div class="col-lg-6" id="chart_economy" style="padding: 0; height: 400px; width: 50%"></div>
    </div>
  </div>
</div>


<?php

    $graphs = array();
    $graphs[1] = new Graph("Seat Factors (ETKT)", "chart_sf", "['Date', 'Outbound $comparison_years[0]', 'Outbound $comparison_years[1]', 'Inbound $comparison_years[0]', 'Inbound $comparison_years[1]', 'Total $comparison_years[0]', 'Total $comparison_years[1]']", $data1);
    $graphs[2] = new Graph("Revenue (ETKT)", "chart_revenue", "['Date', 'Business $comparison_years[0]', 'Business $comparison_years[1]', 'Economy $comparison_years[0]', 'Economy $comparison_years[1]', 'Total $comparison_years[0]', 'Total $comparison_years[1]']", $data2);
    $graphs[3] = new Graph("Economy (ETKT)", "chart_economy", "['Date', 'Outbound $comparison_years[0]', 'Outbound $comparison_years[1]', 'Inbound $comparison_years[0]', 'Inbound $comparison_years[1]', 'Total $comparison_years[0]', 'Total $comparison_years[1]']", $data3);
    $graphs[4] = new Graph("PAX/Revenue (ETKT)", "chart_pax_revenue", "['Date', 'Outbound PAX $comparison_years[0]', 'Outbound PAX $comparison_years[1]', 'Inbound PAX $comparison_years[0]', 'Inbound PAX $comparison_years[1]', 'Total PAX $comparison_years[0]', 'Total $comparison_years[1]', 'Revenue(x1000)']", $data4);
?>


@stop


@section("js_scripts")
<script type="text/javascript" src="https://www.google.com/jsapi"></script>
<script src="{!!route("homepage")."#". url("/")!!}/assets/js/views/report/revenue.js"></script>

<script type="text/javascript">
    google.load("visualization", "1", {packages:["corechart"]});
</script>

@stop