@extends($ajaxCall)

@section("content")

<ul class="breadcrumb">
    <li class="active"><span class="department_title">Reports | </span><span class="department_page">@lang("content.revenue")</span></li>
</ul>


<div class="tabbable">
  <ul class="nav nav-tabs">
    <li class="active"><a href="#tab1" data-toggle="tab">Analysis</a></li>
    <li><a href="#tab2" data-toggle="tab" id="graphs">Graphs</a></li>
  </ul>
  <div class="tab-content">
    <div class="tab-pane active" id="tab1" style="padding-top: 10px;">

        <div class="col-lg-12">
            @include('report.form', ['enableRevenue' => true, 'enablePeriod' => true])
        </div>

        <div class="col-lg-12 container" style='margin: 20px 0 0 0; padding: 0; overflow-x: auto'>
           <table class="tablesorter table table-bordered table-striped table-hover">
            <thead>
                <tr>
                    <th colspan='10' class="text-center total">TOTAL NETWORK</th>
                </tr>
                <tr>
                    <th rowspan="2" class="text-center">Period/Flight No.</th>
                    <th colspan="3" class="text-center total">@lang("content.business")</th>
                    <th colspan="3" class="text-center total">@lang("content.economy")</th>
                    <th colspan="3" class="text-center total">@lang("content.total")</th>
                </tr>
                <tr>
                    <th class="text-center">PAX</th>
                    <th class="text-center">@lang("content.revenue")</th>
                    <th class="text-center">@lang("content.yield")</th>

                    <th class="text-center">PAX</th>
                    <th class="text-center">@lang("content.revenue")</th>
                    <th class="text-center">@lang("content.yield")</th>

                    <th class="text-center">PAX</th>
                    <th class="text-center">@lang("content.revenue")</th>
                    <th class="text-center">@lang("content.yield")</th>
               </tr>
            </thead>
        <tbody>
            @foreach($paxRevenueByCabin as $each)
            <tr>
                <td>{!! $each->date !!}</td>
                <td>{!! number_format($each->pax_c, 0) !!}</td>
                <td>{!! number_format($each->revenue_c, 0) !!}</td>
                <td>{!! $each->pax_c ? number_format($each->revenue_c / $each->pax_c, 0) : '-' !!}</td>
                <td>{!! number_format($each->pax_y, 0) !!}</td>
                <td>{!! number_format($each->revenue_y, 0) !!}</td>
                <td>{!! $each->pax_y ? number_format($each->revenue_y / $each->pax_y, 0) : '-' !!}</td>
                <td>{!! number_format($each->pax, 0) !!}</td>
                <td>{!! number_format($each->revenue, 0) !!}</td>
                <td>{!! $each->pax ? number_format($each->revenue / $each->pax, 0) : '-' !!}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
    </div>
    <div class="tab-pane" id="tab2" style="padding:0">
        <div class="col-lg-6" id="chart_pax_revenue" style="padding: 0; height: 400px; width: 50%"></div>
        <div class="col-lg-6" id="chart_revenue" style="padding: 0; height: 400px; width: 50%"></div>
        <div class="col-lg-6" id="chart_sf" style="padding: 0; height: 400px; width: 50%"></div>
        <div class="col-lg-6" id="chart_economy" style="padding: 0; height: 400px; width: 50%"></div>
    </div>
  </div>
</div>


<?php
    /*
    $graphs = array();
    $graphs[1] = new Graph("Seat Factors (ETKT)", "chart_sf", "['Date', 'Outbound $comparison_years[0]', 'Outbound $comparison_years[1]', 'Inbound $comparison_years[0]', 'Inbound $comparison_years[1]', 'Total $comparison_years[0]', 'Total $comparison_years[1]']", $data1);
    $graphs[2] = new Graph("Revenue (ETKT)", "chart_revenue", "['Date', 'Business $comparison_years[0]', 'Business $comparison_years[1]', 'Economy $comparison_years[0]', 'Economy $comparison_years[1]', 'Total $comparison_years[0]', 'Total $comparison_years[1]']", $data2);
    $graphs[3] = new Graph("Economy (ETKT)", "chart_economy", "['Date', 'Outbound $comparison_years[0]', 'Outbound $comparison_years[1]', 'Inbound $comparison_years[0]', 'Inbound $comparison_years[1]', 'Total $comparison_years[0]', 'Total $comparison_years[1]']", $data3);
    $graphs[4] = new Graph("PAX/Revenue (ETKT)", "chart_pax_revenue", "['Date', 'Outbound PAX $comparison_years[0]', 'Outbound PAX $comparison_years[1]', 'Inbound PAX $comparison_years[0]', 'Inbound PAX $comparison_years[1]', 'Total PAX $comparison_years[0]', 'Total $comparison_years[1]', 'Revenue(x1000)']", $data4);
    */
?>


@stop


@section("js_scripts")
<script type="text/javascript" src="https://www.google.com/jsapi"></script>
<script src="{!!route("homepage")."#". url("/")!!}/assets/js/views/report/revenue.js"></script>

<script type="text/javascript">
    google.load("visualization", "1", {packages:["corechart"]});
</script>

@stop