<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            @include('report.form', ['enableAirport' => true])

            @include('report.punctuality-analysis-tab')
        </article>

    </div>
</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        var barOptions = GetChartJsBarOptions();

        // CHART PUNCTUALITY
        var chartOnTimeData = {
            labels: {!! json_encode($flightsByCategoryChart["category"]) !!},
            datasets: [
                {
                    label: "Percentage",
                    backgroundColor: [
                        'rgba(0, 202, 14, 0.5)',
                        'rgba(149, 246, 153,0.5)',
                        'rgba(251, 147, 147,0.5)',
                        'rgba(250, 106, 106,0.5)',
                        'rgba(221, 0, 0,0.5)'
                    ],
                    hoverBackgroundColor: [
                        'rgba(0, 202, 14, 0.8)',
                        'rgba(149, 246, 153, 0.8)',
                        'rgba(251, 147, 147, 0.8)',
                        'rgba(250, 106, 106, 0.8)',
                        'rgba(221, 0, 0, 0.8)'
                    ],
                    borderColor: [
                        'rgba(0, 202, 14, 1)',
                        'rgba(149, 246, 153, 1)',
                        'rgba(251, 147, 147, 1)',
                        'rgba(250, 106, 106, 1)',
                        'rgba(221, 0, 0, 1)'
                    ],
                    borderWidth: 1,
                    data: {!! json_encode($flightsByCategoryChart["value"]) !!}
                }
            ]
        };

        var ctx1 = document.getElementById("chart_punctuality").getContext("2d");
        myNewChart_1 = new Chart(ctx1, {
            type: 'horizontalBar',
            data: chartOnTimeData,
            options: barOptions
        });
        // END CHART PUNCTUALITY

        // CHART DELAY
        var chartDelayData = {
            labels: {!! json_encode($flightsByDelayCodeChart["delay"]) !!},
            datasets: [
                {
                    label: "Percentage",
                    backgroundColor: [
                        'rgba(0, 202, 14, 0.5)',
                        'rgba(149, 246, 153,0.5)',
                        'rgba(251, 147, 147,0.5)',
                        'rgba(250, 106, 106,0.5)',
                        'rgba(221, 0, 0,0.5)',

                        'rgba(5, 205, 11, 0.5)',
                        'rgba(150, 241, 13,0.5)',
                        'rgba(215, 147, 17,0.5)',
                        'rgba(185, 104, 16,0.5)',
                        'rgba(85, 10, 15,0.5)',

                        'rgba(11, 175, 4, 0.5)',
                        'rgba(34, 245, 3,0.5)',
                        'rgba(115, 17, 7,0.5)',
                        'rgba(158, 16, 6,0.5)',
                        'rgba(298, 5, 10,0.5)'
                    ],
                    hoverBackgroundColor: [
                        'rgba(0, 202, 14, 0.8)',
                        'rgba(149, 246, 153,0.8)',
                        'rgba(251, 147, 147,0.8)',
                        'rgba(250, 106, 106,0.8)',
                        'rgba(221, 0, 0,0.8)',

                        'rgba(5, 205, 11, 0.8)',
                        'rgba(150, 241, 13,0.8)',
                        'rgba(215, 147, 17,0.8)',
                        'rgba(185, 104, 16,0.8)',
                        'rgba(85, 10, 15,0.8)',

                        'rgba(11, 175, 4, 0.8)',
                        'rgba(34, 245, 3,0.8)',
                        'rgba(115, 17, 7,0.8)',
                        'rgba(158, 16, 6,0.8)',
                        'rgba(298, 5, 10,0.8)'
                    ],
                    borderColor: [
                        'rgba(0, 202, 14, 1)',
                        'rgba(149, 246, 153, 1)',
                        'rgba(251, 147, 147, 1)',
                        'rgba(250, 106, 106, 1)',
                        'rgba(221, 0, 0, 1)',

                        'rgba(5, 205, 11, 1)',
                        'rgba(150, 241, 13, 1)',
                        'rgba(215, 147, 17, 1)',
                        'rgba(185, 104, 16, 1)',
                        'rgba(85, 10, 15, 1)',

                        'rgba(11, 175, 4, 1)',
                        'rgba(34, 245, 3, 1)',
                        'rgba(115, 17, 7, 1)',
                        'rgba(158, 16, 6, 1)',
                        'rgba(298, 5, 10, 1)'
                    ],
                    borderWidth: 1,
                    data: {!! json_encode($flightsByDelayCodeChart["value"]) !!}
                }
            ]
        };

        var ctx2 = document.getElementById("chart_delay").getContext("2d");
        myNewChart_2 = new Chart(ctx2, {
            type: 'doughnut',
            data: chartDelayData,
            options: {
                legend: {
                    display: false,
                    labels: {
                        fontColor: 'rgb(255, 99, 132)'
                    }
                }
            },
            animation:{
                animateScale:true
            }
        });
        // END CHART DELAY
    };



    loadScript("{{ asset("/assets/js/views/report/punctuality.js") }}", function () {
        loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", pagefunction)
    });

</script>
