
<!-- PUNCTUALITY TABLE -->
<article class="col-sm-12 col-md-12 col-lg-12">

    <!-- Widget ID (each widget will need unique ID)-->
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-fullscreenbutton="true">
        <!-- widget options:
        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        data-widget-colorbutton="false"
        data-widget-editbutton="false"
        data-widget-togglebutton="false"
        data-widget-deletebutton="false"
        data-widget-fullscreenbutton="false"
        data-widget-custombutton="false"
        data-widget-collapsed="true"
        data-widget-sortable="false"

        -->
        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.punctuality_by_station")</h2>

        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding">

                <div class="table-responsive">

                    <table class="table table-bordered table-hover" id="punctuality-report-table">
                        <thead>
                            <tr>
                                <th colspan="2" class="text-center">@lang("content.station")</th>
                                @foreach($airportsUnique as $airport)
                                    <th class="text-center" colspan="2">{{ $airport }}</th>
                                @endforeach
                            </tr>
                        </thead>

                        <tbody>

                            @for ($i = 0; $i <5; $i++)
                                @php $bgColor = getPunctualityBgColor($categories[$i]) @endphp
                                <tr>
                                    <td style="background-color: {{ $bgColor }}; width: 5%"></td>
                                    <td style="font-weight: 500">{{ trans("content.{$categories[$i]}") }}</td>

                                    @foreach($airportsUnique as $airport)
                                        @php $currentAirport = isset($airportsByCategory[$i][$airport]) ? $airportsByCategory[$i][$airport] : false @endphp
                                        @if ($currentAirport)
                                            <td data-center>{{ $currentAirport->count }}</td>
                                            <td data-center>{{ $currentAirport->percentage }}%</td>
                                        @else
                                            <td colspan="2"></td>
                                        @endif

                                    @endforeach
                                </tr>
                            @endfor

                            {{--Totals--}}
                            @php $style = "font-weight:bold; text-align: center" @endphp
                            <tr>
                                <td colspan="2" style="{{ $style }}">@lang("content.total_flights")</td>

                                @foreach($airportsUnique as $airport)
                                    <td style="{{ $style }}">{{  $airportsByCategory[$airport] }}</td>
                                    <td style="{{ $style }}">100%</td>
                                @endforeach
                            </tr>

                        </tbody>
                    </table>

                </div>
            </div>
            <!-- end widget content -->

        </div>
        <!-- end widget div -->

    </div>
    <!-- end widget -->

</article>
<!-- PUNCTUALITY TABLE END -->

{{--CHART ON TIME--}}
<article class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
        <!-- Widget ID (each widget will need unique ID)-->
        <div class="jarviswidget" id="wid-id-2" data-widget-colorbutton="false"
             data-widget-fullscreenbutton="true" data-widget-editbutton="false"
             data-widget-sortable="false">
            <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

            -->
            <header>
                <h2>@lang("content.on_time"), %</h2>
            </header>

            <!-- widget div-->
            <div>

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->
                    <input class="form-control" type="text">
                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body">
                    <!-- this is what the user will see -->
                    <canvas id="chart_on_time" height="250"></canvas>
                </div>
                <!-- end widget content -->

            </div>
            <!-- end widget div -->

        </div>
    </article>
{{--CHART ON TIME END--}}

{{--CHART WITHIN 15 MIN TIME--}}
<article class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
        <!-- Widget ID (each widget will need unique ID)-->
        <div class="jarviswidget" id="wid-id-2" data-widget-colorbutton="false"
             data-widget-fullscreenbutton="false" data-widget-editbutton="false"
             data-widget-sortable="false">
            <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

            -->
            <header>
                <h2>@lang("content.within_15_mins"), %</h2>
            </header>

            <!-- widget div-->
            <div>

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->
                    <input class="form-control" type="text">
                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body">
                    <!-- this is what the user will see -->
                    <canvas id="chart_within_15_min" height="250"></canvas>
                </div>
                <!-- end widget content -->

            </div>
            <!-- end widget div -->

        </div>
    </article>
{{--CHART WITHIN 15 MIN END--}}

{{--CHART WITHIN 30 MIN TIME--}}
<article class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
        <!-- Widget ID (each widget will need unique ID)-->
        <div class="jarviswidget" id="wid-id-2" data-widget-colorbutton="false"
             data-widget-fullscreenbutton="false" data-widget-editbutton="false"
             data-widget-sortable="false">
            <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

            -->
            <header>
                <h2>@lang("content.within_30_mins"), %</h2>
            </header>

            <!-- widget div-->
            <div>

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->
                    <input class="form-control" type="text">
                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body">
                    <!-- this is what the user will see -->
                    <canvas id="chart_within_30_min" height="250"></canvas>
                </div>
                <!-- end widget content -->

            </div>
            <!-- end widget div -->

        </div>
    </article>
{{--CHART WITHIN 30 MIN END--}}

{{--CHART WITHIN 60 MIN TIME--}}
<article class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
        <!-- Widget ID (each widget will need unique ID)-->
        <div class="jarviswidget" id="wid-id-2" data-widget-colorbutton="false"
             data-widget-fullscreenbutton="false" data-widget-editbutton="false"
             data-widget-sortable="false">
            <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

            -->
            <header>
                <h2>@lang("content.within_60_mins"), %</h2>
            </header>

            <!-- widget div-->
            <div>

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->
                    <input class="form-control" type="text">
                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body">
                    <!-- this is what the user will see -->
                    <canvas id="chart_within_60_min" height="250"></canvas>
                </div>
                <!-- end widget content -->

            </div>
            <!-- end widget div -->

        </div>
    </article>
{{--CHART WITHIN 60 MIN END--}}

{{--CHART ABOVE 60 MIN TIME--}}
<article class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
        <!-- Widget ID (each widget will need unique ID)-->
        <div class="jarviswidget" id="wid-id-2" data-widget-colorbutton="false"
             data-widget-fullscreenbutton="false" data-widget-editbutton="false"
             data-widget-sortable="false">
            <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

            -->
            <header>
                <h2>@lang("content.above_60_mins"), %</h2>
            </header>

            <!-- widget div-->
            <div>

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->
                    <input class="form-control" type="text">
                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body">
                    <!-- this is what the user will see -->
                    <canvas id="above_60_min" height="120"></canvas>
                </div>
                <!-- end widget content -->

            </div>
            <!-- end widget div -->

        </div>
    </article>
{{--CHART ABOVE 60 MIN END--}}

