{!! Form::open(['class' => 'form-inline', 'method' => 'POST', 'id' => 'formPunctualityReport']) !!}
<div class="col-lg-12">

    @if (env(MULTIPLE_AIRLINE) && ghaModule() && isset($enableAirline) && $enableAirline)
        <div class="form-group marginBottomRight">
            <label>@lang("content.airline")</label>
            <div class="btn-group">
                {!! Form::select('airline[]', $airlines, \request("airline"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
            </div>
        </div>
    @endif

    <div class="form-group marginBottomRight">
        {!! Form::hidden('flightSearch','airport') !!}
        <label>Airport</label>
        <div class="btn-group">
            {!! Form::select('airport[]', $airports, \request("airport"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']) !!}
        </div>
    </div>

    <div class="form-group marginBottomRight">
        {!! Form::hidden('activeTab', 'Report') !!}

        <label>{!! Form::radio('dateSearch','fromTo', !\request("dateSearch") || \request("dateSearch") == 'fromTo') !!} From</label>
        {!! Form::text('dateFrom', !\request("dateSearch") ? $dateYesterday : \request("dateFrom"), ['class'=>'form-control dateFrom myinput', 'placeholder'=>'From Date']) !!}
        <label form="dateTo">@lang("content.to")</label>
        {!! Form::text('dateTo', !\request("dateSearch") ? $dateYesterday : \request("dateTo"), ['class'=>'form-control dateTo myinput', 'placeholder' => 'To Date']) !!}
    </div>

    <div class="form-group marginBottomRight">
        <label>{!! Form::radio('dateSearch','monthYear', \request("dateSearch") == 'monthYear') !!} @lang("content.month")</label>
        <div class="btn-group">
            {!! Form::select('month[]', $monthNames, \request("month"), ['multiple'=>'multiple', 'class'=>'multiselect_search']) !!}
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label for="year" class="control-label">@lang("content.year")</label>
        <div class="btn-group">
            {!! Form::select('year', $years, getSelectedYear(), ['class'=>'singleselect']) !!}
        </div>
    </div>

    @if (isset($enablePeriod) && $enablePeriod)
        <div class="form-group marginBottomRight">
            <label for="period" class="control-label">@lang("content.period")</label>
            <div class="btn-group">
                {!! Form::select('period', $periods, \request("period"), ['class'=>'multiselect_search']) !!}
            </div>
        </div>
    @endif

    <div class="form-group marginBottomRight">
        <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
    </div>
</div>
{!! Form::close() !!}