<div>
{!! Form::open(['class' => 'form-inline', 'method' => 'GET', 'id' => 'formOPS']) !!}
    @if (isset($enableRevenue) && $enableRevenue)
        <div class="form-group marginBottomRight">
            <label class="control-label">@lang("content.report_type")</label>
            {!! Form::select('reportType', $reportTypes, \request("reportType"), ['class'=>'singleselect', 'id'=>'report_type']) !!}
        </div>
        <div class="form-group marginBottomRight">
            <label class="control-label">@lang("content.country")</label>
            {!! Form::select('country[]', $countries, \request("country"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'country']) !!}

        </div>
        <div class="form-group marginBottomRight">
            <label class="control-label">@lang("content.city")</label>
            {!! Form::select('city[]', $cities, \request("city"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'city']) !!}
        </div>
        <div class="form-group marginBottomRight">
            <label class="control-label">@lang("content.agency")</label>
            {!! Form::select('agency[]', $agencies, \request("agency"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'agency']) !!}
        </div>
    @endif

    @if (env(MULTIPLE_AIRLINE) && ghaModule() && isset($enableAirline) && $enableAirline)
        <div class="form-group marginBottomRight">
            <label>@lang("content.airline")</label>
            <div class="btn-group">
                {!! Form::select('airline[]', $airlines, \request("airline"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
            </div>
        </div>
    @endif

    @if (isset($enableAirport) && $enableAirport)
        <div class="form-group marginBottomRight">
            <label>@lang("content.airport")</label>
            <div class="btn-group">
                {!! Form::select('airport[]', $airports, \request("airport"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']) !!}
            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label>@lang("content.type")</label>
            <div class="btn-group">
                {!! Form::select('type', isset($types) ? $types : [ DEPARTURE => DEPARTURE, ARRIVAL => ARRIVAL, ALL => ALL ], \request("type"), [ 'class'=>'multiselect', 'id'=> 'type' ]) !!}
            </div>
        </div>
    @endif

    <div class="form-group marginBottomRight">
        {!! Form::hidden('activeTab', 'Analysis') !!}
        <label>{!! Form::radio('flightSearch','flightNumber', !\request("flightSearch") || \request("flightSearch") == 'flightNumber') !!} @lang("content.flight_number")</label>
        <div class="btn-group">
            @if (is_array($flightNumbers))
                {!! Form::select('flightNumber[]', $flightNumbers, \request("flightNumber"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'flight_number']) !!}
            @else
                <select name="flightNumber[]" class="multiselect_search" id="flight_number" multiple>
                    @foreach($flightNumbers as $each)
                        <option value="{{ $each->id }}" {!! \request("flightNumber") && in_array($each->id, \request("flightNumber")) ? "selected" : "" !!}>{{ $each->sector }}</option>
                    @endforeach
                </select>
            @endif
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label>{!! Form::radio('flightSearch','sector', \request("flightSearch") == 'sector') !!} @lang("content.sector")</label>
        <div class="btn-group">
            {!! Form::select('sector[]', $sectors, \request("sector"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'sector']) !!}
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label>{!! Form::radio('dateSearch','fromTo', !\request("dateSearch") || \request("dateSearch") == 'fromTo') !!} @lang("content.from")</label>
        {!! Form::text('dateFrom', !\request("dateSearch") ? $dateYesterday : \request("dateFrom"), ['class'=>'form-control dateFrom myinput', 'placeholder'=>'From Date', 'id'=>'from_date']) !!}
        <label form="dateTo">@lang("content.to")</label>
        {!! Form::text('dateTo', !\request("dateSearch") ? $dateYesterday : \request("dateTo"), ['class'=>'form-control dateTo myinput', 'placeholder' => 'To Date', 'id'=>'to_date']) !!}
    </div>

    <div class="form-group marginBottomRight">
        <label>{!! Form::radio('dateSearch','monthYear', \request("dateSearch") == 'monthYear') !!} @lang("content.month")</label>
        <div class="btn-group">
            {!! Form::select('month[]', $monthNames, \request("month"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'month']) !!}
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label for="year" class="control-label">@lang("content.year")</label>
        <div class="btn-group">
            {!! Form::select('year', $years, getSelectedYear(), ['class'=>'singleselect', 'id'=>'period']) !!}
        </div>
    </div>

    @if (isset($enablePeriod) && $enablePeriod)
        <div class="form-group marginBottomRight">
            <label for="period" class="control-label">@lang("content.period")</label>
            <div class="btn-group">
                {!! Form::select('period', $periods, \request("period"), ['class'=>'multiselect_search']) !!}
            </div>
        </div>
    @endif

    <div class="form-group marginBottomRight">
        <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
    </div>
{!! Form::close() !!}
</div>