<div>
    <!-- Widget ID (each widget will need unique ID)-->
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-flights" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
        <!-- widget options:
        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        data-widget-colorbutton="false"
        data-widget-editbutton="false"
        data-widget-togglebutton="false"
        data-widget-deletebutton="false"
        data-widget-fullscreenbutton="false"
        data-widget-custombutton="false"
        data-widget-collapsed="true"
        data-widget-sortable="false"

        -->
        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>

        </header>

        <!-- widget div-->
        <div>

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="overflow: auto">

                <table class="table table-striped table-bordered table-hover" id="punctuality-flights-table"> <!--data-order='[[1, "asc"], [7, "asc"]]'>-->

                    <thead>

                    <tr>
                        <th>No</th>
                        @if (env(CARRIER) == HANDLING)
                            <th data-center>@lang("content.AIRLINE")</th>
                        @endif
                        <th style="min-width: 60px !important;">@lang("content.date")</th>
                        <th>@lang("content.flight_number")</th>
                        <th data-center>@lang("content.NOTES")</th>
                        <th>{{ strtoupper(trans("content.from")) }}</th>
                        <th>{{ strtoupper(trans("content.to")) }}</th>
                        <th style="min-width: 50px !important;">@lang("content.a_c")</th>
                        <th>@lang("content.ac_type")</th>

                        <th style="min-width: 90px !important;">STD</th>
                        <th>PTD</th>
                        <th>ETD</th>
                        <th>ATD</th>
                        <th>ABN</th>

                        <th data-center>DL</th>
                        <th data-center>TIME</th>
                        <th data-center>DL</th>
                        <th data-center>TIME</th>
                        <th data-center>DL</th>
                        <th data-center>TIME</th>
                        {{--<th style="min-width: 40px;">DL<br/>TIME</th>--}}

                        <th style="min-width: 90px !important;">STA</th>
                        <th>PTA</th>
                        <th>ETA</th>
                        <th>ATA</th>
                        <th>TDN</th>
                    </tr>
                    </thead>

                    <tbody>

                    @php $j = 0 @endphp

                    @foreach($flights as $i => $flight)
                        @if (!$flight->is_delayed)
                            @continue
                        @endif

                        @php $flightUrl = isset($flightDetails) ? url("flight-details/{$flight->id}") : url("flight-tracker/{$flight->id}") @endphp
                        @php $aircraft = $flight->aircraft @endphp
                        @php $aircraftType = $flight->aircraft && $flight->aircraft->type ? $flight->aircraft->type : $flight->aircraftType @endphp
                        @php $flightNumber = $flight->flightNumber @endphp
                        @php $airline = $flightNumber->airline @endphp

                        @php $divertedFlight = $flight->divertedAirport @endphp
                        @php $departureAirport = $flight->departureAirport ? $flight->departureAirport : $flightNumber->departureAirport @endphp
                        @php $arrivalAirport = $flight->arrivalAirport ? $flight->arrivalAirport : $flightNumber->arrivalAirport @endphp

                        @php $depDateTime = getFlightDepartureInitialDate($flight) @endphp
                        @php $depDate = date("Y-m-d", strtotime($depDateTime)) @endphp

                        @php $arrDateTime = getFlightArrivalInitialDate($flight) @endphp
                        @php $arrDate = date("Y-m-d", strtotime($arrDateTime)) @endphp
                        @php $picture = $airline && $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png") @endphp

                        <tr>
                            <td>{{ ++$j }}</td>
                            @if (env(CARRIER) == HANDLING)
                                <td data-center style="font-weight: 500">
                                    <a target="_blank" href="{{ route("homepage")."#". url("/airline/{$airline->id}") }}" class="">
                                        <img class='ops-airline-logo' src='{{ $picture }}'/>
                                    </a>
                                </td>
                            @endif

                            <td>{{ baseDateFormat($depDate, false, "-") }}</td>

                            <td><a target="_blank" href="{{ $flightUrl }}">{{ getFlightNumber($flight) }}</a></td>

                            <td><span class="color-red">{{ $divertedFlight ? "DIVERTED" : "" }}</span></td>
                            <td>{{ $departureAirport ? $departureAirport->iata : "-" }}</td>
                            <td>{{ $arrivalAirport ? $arrivalAirport->iata : "" }}</td>
                            <td>{{ getAircraft($aircraft) }}</td>
                            <td>{{ ($aircraftType ? $aircraftType->icao : "") }}</td>

                            <td>{{ baseDateFormat($depDate)." ".getFlightTimeComparedToBase($flight, STD, $depDate) }}</td>
                            <td>{{ getFlightTimeComparedToBase($flight, PTD, $depDate) }}</td>
                            <td>{{ $etd = getFlightTimeComparedToBase($flight, ETD, $depDate) }}</td>
                            <td>{{ $atd = getFlightTimeComparedToBase($flight, ATD, $depDate) }}</td>
                            <td>{{ getFlightTimeComparedToBase($flight, ABN, $depDate) }}</td>

                            @foreach($flight->delay_code as $i => $each)
                                <td class="color-red" style="min-width: 40px;" >
                                    {{ $each }}
                                </td>
                                <td class="color-red" style="min-width: 60px;" >
                                    {{ isset($flight->delay_duration[$i]) ? hoursToDayHourTime($flight->delay_duration[$i] / 60, true) : "" }}
                                </td>
                            @endforeach

                            @for($k = ($i + 1) * 2; $k < 6; $k++)
                                <td></td>
                            @endfor

                            <td>{{ baseDateFormat($arrDate)." ".getFlightTimeComparedToBase($flight, STA, $arrDate) }}</td>
                            <td>{{ getFlightTimeComparedToBase($flight, PTA, $arrDate) }}</td>
                            <td>{{ $eta = getFlightTimeComparedToBase($flight, ETA, $arrDate) }}</td>
                            <td>{{ getFlightTimeComparedToBase($flight, TDN, $arrDate) }}</td>
                            <td>{{ $ata = getFlightTimeComparedToBase($flight, ATA, $arrDate) }}</td>

                        </tr>
                    @endforeach

                    </tbody>
                </table>

            </div>
            <!-- end widget content -->

        </div>
        <!-- end widget div -->

    </div>
    <!-- end widget -->
</div>
