<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            {{--FORM--}}
            @include('report.ops-form', ['enableAirline' => true, 'enableAirport' => true, 'enablePeriod' => true])
        </article>

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <ul id="tabPunctuality" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#dashboard" role="tab" data-toggle="tab">@lang("content.dashboard")</a>
                </li>
                <li class="">
                    <a href="#delayed_flights" role="tab" data-toggle="tab">@lang("content.delayed_flights")</a>
                </li>
                {{--<li class="">--}}
                    {{--<a href="#report" role="tab" data-toggle="tab">@lang("content.reports")</a>--}}
                {{--</li>--}}
            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="dashboard">
                    @include("report.layouts.h-punctuality-dashboard-tab")
                </div>

                <div class="tab-pane " id="delayed_flights">
                    @include("report.layouts.h-punctuality-flights-tab")
                </div>

                {{--<div class="tab-pane" id="report">--}}
                    {{--@include("report.layouts.h-punctuality-reports-tab")--}}
                {{--</div>--}}
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#punctuality-delay-table", true);
        ApplyTableFilter("#punctuality-flights-table");

        @if (ghaModule())
            ApplyOperationsFormFilter({!! json_encode($flightNumbers) !!}, {!! json_encode(\request("flightNumber")) !!}, {!! json_encode($sectors) !!}, {!! json_encode($sectorsByAirlines) !!}, {!! json_encode(\request("sector")) !!});
        @endif

        var barOptions = GetChartJsBarOptions();

        // CHART PUNCTUALITY
        @if ($flightsByCategoryChart && isset($flightsByCategoryChart["category"]))
        var chartOnTimeData = {
            labels: {!! json_encode($flightsByCategoryChart["category"]) !!},
            datasets: [
                {
                    label: "Percentage",
                    backgroundColor: [
                        'rgba(0, 202, 14, 0.5)',
                        'rgba(149, 246, 153,0.5)',
                        'rgba(251, 147, 147,0.5)',
                        'rgba(250, 106, 106,0.5)',
                        'rgba(221, 0, 0,0.5)'
                    ],
                    hoverBackgroundColor: [
                        'rgba(0, 202, 14, 0.8)',
                        'rgba(149, 246, 153, 0.8)',
                        'rgba(251, 147, 147, 0.8)',
                        'rgba(250, 106, 106, 0.8)',
                        'rgba(221, 0, 0, 0.8)'
                    ],
                    borderColor: [
                        'rgba(0, 202, 14, 1)',
                        'rgba(149, 246, 153, 1)',
                        'rgba(251, 147, 147, 1)',
                        'rgba(250, 106, 106, 1)',
                        'rgba(221, 0, 0, 1)'
                    ],
                    borderWidth: 1,
                    data: {!! json_encode($flightsByCategoryChart["value"]) !!}
                }
            ]
        };

        var ctx1 = document.getElementById("chart_punctuality").getContext("2d");
        myNewChart_1 = new Chart(ctx1, {
            type: 'horizontalBar',
            data: chartOnTimeData,
            options: barOptions
        });
        @endif
        // END CHART PUNCTUALITY


        // CHART DELAY
        @if (isset($flightsByDelayCodeChart["delay"]) && count($flightsByDelayCodeChart["delay"]))


         var chartDelayData = {
            labels: {!! json_encode($flightsByDelayCodeChart["delay"]) !!},
            datasets: [
                {
                    label: "Percentage",
                    backgroundColor: [
                        'rgba(0, 202, 14, 0.5)',
                        'rgba(149, 246, 153,0.5)',
                        'rgba(251, 147, 147,0.5)',
                        'rgba(250, 106, 106,0.5)',
                        'rgba(221, 0, 0,0.5)',

                        'rgba(5, 205, 11, 0.5)',
                        'rgba(150, 241, 13,0.5)',
                        'rgba(215, 147, 17,0.5)',
                        'rgba(185, 104, 16,0.5)',
                        'rgba(85, 10, 15,0.5)',

                        'rgba(11, 175, 4, 0.5)',
                        'rgba(34, 245, 3,0.5)',
                        'rgba(115, 17, 7,0.5)',
                        'rgba(158, 16, 6,0.5)',
                        'rgba(298, 5, 10,0.5)'
                    ],
                    hoverBackgroundColor: [
                        'rgba(0, 202, 14, 0.8)',
                        'rgba(149, 246, 153,0.8)',
                        'rgba(251, 147, 147,0.8)',
                        'rgba(250, 106, 106,0.8)',
                        'rgba(221, 0, 0,0.8)',

                        'rgba(5, 205, 11, 0.8)',
                        'rgba(150, 241, 13,0.8)',
                        'rgba(215, 147, 17,0.8)',
                        'rgba(185, 104, 16,0.8)',
                        'rgba(85, 10, 15,0.8)',

                        'rgba(11, 175, 4, 0.8)',
                        'rgba(34, 245, 3,0.8)',
                        'rgba(115, 17, 7,0.8)',
                        'rgba(158, 16, 6,0.8)',
                        'rgba(298, 5, 10,0.8)'
                    ],
                    borderColor: [
                        'rgba(0, 202, 14, 1)',
                        'rgba(149, 246, 153, 1)',
                        'rgba(251, 147, 147, 1)',
                        'rgba(250, 106, 106, 1)',
                        'rgba(221, 0, 0, 1)',

                        'rgba(5, 205, 11, 1)',
                        'rgba(150, 241, 13, 1)',
                        'rgba(215, 147, 17, 1)',
                        'rgba(185, 104, 16, 1)',
                        'rgba(85, 10, 15, 1)',

                        'rgba(11, 175, 4, 1)',
                        'rgba(34, 245, 3, 1)',
                        'rgba(115, 17, 7, 1)',
                        'rgba(158, 16, 6, 1)',
                        'rgba(298, 5, 10, 1)'
                    ],
                    borderWidth: 1,
                    data: {!! json_encode($flightsByDelayCodeChart["value"]) !!}
                }
            ]
        };

        var ctx2 = document.getElementById("chart_delay").getContext("2d");
        myNewChart_2 = new Chart(ctx2, {
            type: 'doughnut',
            data: chartDelayData,
            options: {
                legend: {
                    display: true,
                    labels: {
                        fontColor: 'rgb(255, 99, 132)'
                    }
                }
            },
            animation:{
                animateScale:false
            }
        });
        @endif
        // END CHART DELAY
    };


    loadScript("{{ asset("/assets/js/views/report/punctuality.js") }}", function () {
        loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", pagefunction)
    });

</script>
