<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 28.08.14

 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @if (isset($department))
                @php $hasSubdepartment = $department->has_subdepartment @endphp
                @php $link = "department_id=" . $department->id; @endphp
                @php $back = route("homepage")."#". url("department"); @endphp
                @include('general.tab-header', ['departmentName' => trans("content.admin"), 'moduleName' => $department->name." | ".trans("content.positions")])

                <div class="col-12 margin-bottom-10">
{{--                    <a class="btn btn-success add" href = "{{ route("homepage")."#". url("staff/create?s=".rand(100, 999)) }}">@lang("content.add_new_staff")</a>--}}
{{--                    <a href="{{ route("homepage")."#". url('department/organization/'.$department->id) }}" class=" btn btn-primary">@lang("content.draw_chart")</a>--}}
                    {{--            <a href="{{ route("homepage")."#". url('organization/new-chart/department/'.$department->id) }}" class="btn btn-primary">Draw Organization Chart</a>--}}
                    {{--            <a href="{{ route("homepage")."#". url('organization-level')."?structure_department_id={$department->id}" }}" class="btn btn-success">Organization Levels</a>--}}
{{--                    <a href="{{ route("homepage")."#". url('position')."?department_id={$department->id}" }}" class="btn btn-warning">@lang("content.positions")</a>--}}
                    <a class="btn btn-success" href="{{ route("homepage")."#department/organization/{$department->id}" }}" target="_blank">@lang("content.organisation")</a>
                    <a href="{!! route("homepage")."#". url('position/create') !!}?{!! $link !!}" class="btn btn-primary">@lang("content.add_position")</a>
{{--                    <a href="javascript:history.back()" class="btn btn-default">@lang("content.back")</a>--}}
                </div>

            @elseif (isset($subDepartment))
                @php $hasSubdepartment = 0 @endphp
                @php $back = route("homepage")."#". url("subdepartment/index") . "?department_id=$subDepartment->department_id"; @endphp
                @php $link = "subdepartment_id=" . $subDepartment->id; @endphp
                @include('general.tab-header', ['departmentName' => trans("content.admin"), 'moduleName' => $subDepartment->name." | ".trans("content.positions")])
            @endif



            <div class="editable_div">

                @if (count($positions) == 0)
                    <p class="alert alert-info">@lang("content.found") 0 @lang("content.position")</p>
                @else
                    <table class="table table-bordered table-striped table-hover editable_table">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th>@lang("content.name")</th>
                            <th>@lang("content.reports_to")</th>
                            @if ($hasSubdepartment)
                                <th>@lang("content.subdepartment")</th>
                            @endif
                            <th>@lang("content.head")</th>
                            <th>@lang("content.type")</th>
                            <th>@lang("content.show_all_leave_requests")</th>
                            <th>@lang("content.last_update")</th>
                            <th>@lang("content.actions")</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($positions as $i => $position)
                            <tr>
                                <td>{{ $i + 1 }}</td>
                                <td data-left>{!! $position->name !!}</td>
                                <td>
                                    @php $posName = $position->reportsTo ? $position->reportsTo->name : "-" @endphp
                                    <a href="#" data-field='reports_to_id' data-model="Position" data-type="select" data-id='{{ $position->id }}'
                                       data-placeholder="Required" data-value='{{ $position->reports_to_id }}'
                                       class="editable {{ $position->reports_to_id ? 'editable-click' : 'editable-empty'  }}">
                                        {{ $position->reports_to_id ? $posName : 'Empty' }}</a>
                                </td>
                                @if ($hasSubdepartment)
                                    <td>{{ $position->subDepartment ? $position->subDepartment->name : "" }}</td>
                                @endif
                                <td data-center>{!! $position->head_of_department ? '<i class="fa fa-check"></i>' : "" !!}</td>
                                <td>{!! getPositionType($position->type) !!}</td>
                                <td data-center>{!! $position->show_leave_requests ? '<i class="fa fa-check"></i>' : "" !!}</td>
                                <td>{!! $position->updated_at !!}</td>
                                <td>
                                    <div class="btn-group">
                                        <a target="_blank" href="{!! route("homepage")."#". url("position/{$position->id}/edit?s=".rand(100, 999)) !!}"
                                           class="btn btn-primary btn-sm">@lang("content.edit")</a>
                                        <a href="{!! route("homepage")."#". url('position/delete') !!}?id={!! $position->id !!}"
                                           data-confirm-text="Are you sure you want to remove this position?"
                                           class="btn btn-danger confirm btn-sm">@lang("content.remove")</a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                @endif
            </div>




        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

    };

    pagefunction();

</script>
