<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => trans("content.admin"), 'moduleName' => trans("content.edit_position")])

            <div>
                @if ($position->department->has_subdepartment)
                    @php $back = route("homepage")."#". url("position/index?subdepartment_id={$position->subdepartment_id}") @endphp
                @else
                    @php $back = route("homepage")."#".url("position/index?department_id={$position->department_id}") @endphp
                @endif

                <div class="col-sm-6">
                    @if ($errors->all())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{!! $error !!}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    {!! Form::open(['method' => 'POST', 'class' => 'form-horizontal', 'url' => url("position/{$position->id}") ]) !!}
                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-3">@lang("content.name")</label>
                            <div class="col-sm-7">
                                {!! Form::text('name', $position->name, ['class'=>'form-control', 'placeholder'=>'Name', 'id'=>'title']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.type")</label>
                            <div class="col-sm-6">
                                <label>{!! Form::select('type', getPositionTypesList(), $position->type, ['class'=>'form-control']) !!}</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.show_all_leave_requests")</label>
                            <div class="col-sm-6">
                                <label>{!! Form::checkbox('show_leave_requests', 1, $position->show_leave_requests, ['class'=>'form-control']) !!}</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.head_of_department")</label>
                            <div class="col-sm-6">
                                <label>{!! Form::checkbox('head_of_department', 1, $position->head_of_department, ['class'=>'form-control']) !!}</label>
                            </div>
                        </div>

                        <hr/>
                        <div class="form-group">
                            <div class="col-sm-offset-3 col-sm-9">
                                <button type="submit" class="btn btn-primary">@lang("content.save_changes")</button>
                                <a href="{!! $back !!}" class="btn btn-default">@lang("content.back")</a>
                            </div>
                        </div>
                    {!! Form::close() !!}
                </div>
            </div>


        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

    };

    pagefunction();

</script>
