<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 28.08.14

 */

?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @if (isset($department))
                @php $back = route("homepage")."#". url("position/index") . "?department_id=$department->id" @endphp
                @include('general.tab-header', ['departmentName' => $department->name, 'moduleName' => trans("content.add_position")])
            @elseif(isset($subDepartment))
                @php $back = route("homepage")."#". url("position/index") . "?subdepartment_id=$subDepartment->id" @endphp
                @include('general.tab-header', ['departmentName' => $subDepartment->name, 'moduleName' => trans("content.add_position")])
            @endif
            <div class="row">
                <div class="col-sm-6">
                    @if ($errors->all())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{!! $error !!}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    {!! Form::open(['method' => 'POST', 'class' => 'form-horizontal', 'url' => url("position")]) !!}
                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-3">@lang("content.name")</label>
                            <div class="col-sm-7">
                                {!! Form::text('name', null, ['class'=>'form-control', 'placeholder'=> trans("content.name"), 'id'=>'title']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.type")</label>
                            <div class="col-sm-6">
                                <label>{!! Form::select('type', getPositionTypesList(), null, ['class'=>'form-control']) !!}</label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.head_of_department")</label>
                            <div class="col-sm-6">
                                <label>{!! Form::checkbox('head_of_department', 1, null, ['class'=>'form-control']) !!}</label>
                            </div>
                        </div>

                        <hr/>
                        <div class="form-group">
                            <div class="col-sm-offset-3 col-sm-9">
                                <button type="submit" class="btn btn-primary">@lang("content.add")</button>
                                <a href="{!! $back !!}" class="btn btn-default">@lang("content.back")</a>
                                {!! Form::hidden("subdepartment_id", \request("subdepartment_id")) !!}
                                {!! Form::hidden("department_id", \request("department_id")) !!}
                            </div>
                        </div>

                    {!! Form::close() !!}
                </div>
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

    };

    pagefunction();

</script>
