<?php

//initilize the page
require_once(public_path("smart/inc/init.php"));

//require UI configuration (nav, ribbon, etc.)
require_once(public_path("smart/inc/config.ui.php"));

include_once(public_path("smart/inc/user_variables.php"));


/*---------------- PHP Custom Scripts ---------

YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
E.G. $page_title = "Custom Title" */

$page_title = "Payroll Hours Report";

/* ---------------- END PHP Custom Scripts ------------- */

//include header
//you can add your custom css in $page_css array.
//Note: all css files are inside css/ folder
$page_css[] = "your_style.css";

$no_main_header = true;

$page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

include(public_path("smart/inc/header.php"));

?>


<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->
<header id="header" class="no-padding" >
    <!--<span id="logo"></span>-->

    <div id="logo-group"  style="height: 60px; width: 100%; padding: 0 15px;" class="flightTrackerBackground">
        <h2 class="flightTracker color-white">Payroll Hours Report</h2>
    {{--<span> <img style="max-height: 70px" src="{{ $logo }}"  alt="Aviation-BIS"> </span>--}}
    {{--        <h2><strong>{{ $logo_text }}</strong></h2>--}}
    <!-- END AJAX-DROPDOWN -->
    </div>

</header>

<div id="main" role="main">

    <!-- MAIN CONTENT -->
    <div id="content" class="">
        <!-- widget grid -->
        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="col-sm-12 padding-0">

                        <div class="col-md-12" style="margin-bottom: 20px;">
                            @include("payroll-hours.layouts.index-form")
                        </div>

                        {{--Inner tabs--}}
{{--                        <ul class="nav nav-pills" id="tabs">--}}
{{--                            <li class="active">--}}
{{--                                <a href="#payroll_hours" data-toggle="tab">--}}
{{--                                    <span class="tabText">@lang("content.payroll_hours")</span>--}}
{{--                                </a>--}}
{{--                            </li>--}}
{{--                        </ul>--}}

{{--                        <div class="pill-content no-padding no-margin">--}}
{{--                            <div class="pill-pane bg-color-white active" id="payroll_hours" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">--}}
                        @if ($overlappingHours)
                            <div class="col-md-12">
                                @include("payroll-hours.layouts.index-table")
                            </div>
                        @endif
{{--                            </div>--}}
{{--                        </div>--}}
                    </div>

                </article>

            </div>

        </section>
    </div>
</div>



<script type="text/javascript">
    var baseUrl = "{{ url('/') }}";
    var baseDashboardUrl = "{{ url('home/dashboard') }}";
    var baseHomeUrl = "{{ route("homepage")."#". url('/') }}";
    var AIRLINE = "{{ env("AIRLINE") }}";
    var CARRIER = "{{ env("CARRIER") }}";
    var CURRENT_IATA_CODE = "{{ env("IATA_CODE") }}";
</script>

<?php
//include required scripts
include(public_path("smart/inc/scripts.php"));
?>


<script type="text/javascript">

    pageSetUp();

    // ApplyMultipleFormSubmit();

    var pagefunction = function () {

        ApplyValidationDateFormats();
        Apply_Multiselect();
        // ApplyTableFilter("#dailyTable", false, [[6, "asc"]]);
        ApplyTableFilter("#payrollTable");

{{--        @if (ghaModule())--}}
{{--            ApplyOperationsFormFilter({!! json_encode($flightNumbers) !!}, {!! json_encode(\request("flightNumber")) !!});--}}
{{--        @endif--}}
    };

    pagefunction();

</script>
