<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="margin-bottom-10">
                @if ($flight)
                    <h3 class="margin-bottom-5">Flight: {{ getFlightNumber($flight)." (".getFlightSector($flight).")" }}</h3>
                    <span>
                    STD: {{ baseDateFormat($flight->std, true) }} (UTC)
                    @if ($flight->atd)
                        <br> ATD: {{ baseDateFormat($flight->atd, true) }} (UTC)
                    @endif
                    </span>
                @elseif($flightNumber)
                    <h3 class="margin-bottom-5">Flight: {{ env(IATA_CODE)."-".$flightNumber->flight_number ." (".getFlightNumberSector($flightNumber).")" }}</h3>
                    <span>
                        STD: {{ baseDateFormat($departureDate) }}
                    </span>
                @endif
            </div>

            <div class="alert alert-success" style="display: block; height: 50px">
                <span style="float: left">
                    {{--Revenue PAX: <h5 class="info">{{ number_format($revenuePax) }}</h5>--}}
                    Total PAX: <h5 class="info">{{ number_format($totalPax) }}</h5>
                </span>
                <span style="float: right">
                    Revenue PAX: <h5 class="info">{{ number_format($revenuePax) }}</h5>
                    Total: <h5 class="info">{{ number_format($totalRevenue) }}$</h5>
                    Yield: <h5 class="info">{{ $revenuePax > 0 ? number_format($totalRevenue / $revenuePax) : 0 }}$</h5>
                </span>
            </div>

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#revenue" role="tab" data-toggle="tab">@lang("content.revenue") <div class="badge bg-color-green">{{ count($data["revenue"]) }}</div></a>
                </li>
                <li>
                    <a href="#child50" role="tab" data-toggle="tab">CHD50 <div class="badge bg-color-green">{{ count($data["child50"]) }}</div></a>
                </li>
                <li>
                    <a href="#child" role="tab" data-toggle="tab">CHD00 <div class="badge bg-color-blue">{{ count($data["child"]) }}</div></a>
                </li>
                <li>
                    <a href="#infant" role="tab" data-toggle="tab">INF00 <div class="badge bg-color-blue">{{ count($data["infant"]) }}</div></a>
                </li>
                <li>
                    <a href="#non_revenue" role="tab" data-toggle="tab">@lang("content.non_revenue") <div class="badge bg-color-blue">{{ count($data["non_revenue"]) }}</div></a>
                </li>
                <li>
                    <a href="#refunded" role="tab" data-toggle="tab">@lang("content.refunded") <div class="badge bg-color-red">{{ count($data["refunded"]) }}</div></a>
                </li>
            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10 background-white">

                {{--$data = [ "revenue", "child", "infant", "non-revenue", "refunded" ]--}}

                <div class="tab-pane active" id="revenue">
                    @include("passenger.layouts.pax-table", ["tableData" => $data['revenue']])
                </div>
                <div class="tab-pane" id="child50">
                    @include("passenger.layouts.pax-table", ["tableData" => $data['child50'], "dob" => true])
                </div>
                <div class="tab-pane" id="child">
                    @include("passenger.layouts.pax-table", ["tableData" => $data['child'], "dob" => true])
                </div>
                <div class="tab-pane" id="infant">
                    @include("passenger.layouts.pax-table", ["tableData" => $data['infant'], "dob" => true])
                </div>
                <div class="tab-pane" id="non_revenue">
                    @include("passenger.layouts.pax-table", ["tableData" => $data['non_revenue']])
                </div>
                <div class="tab-pane" id="refunded">
                    @include("passenger.layouts.pax-table", ["tableData" => $data['refunded']])
                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");

    };

    pagefunction();

</script>
