<div class="row">

    <div class="col-sm-6">
        {{--Upload Photo Form--}}
        <div class="col-sm-6">
            @include('forms/general/upload-picture', ['postUrl' => route("homepage")."#". url("passenger/upload-photo/{$passenger->id}")])
        </div>

        <div class="col-sm-6">
            <div class="list-my-group-2">
                <div class="body bg-dark-blue">
                    <div>
                        <div class="title">Country</div>
                        <div>{{ $passenger->passport ? $passenger->passport->country : "-" }}</div>
                    </div>
                    <div>
                        <div class="title">FF ID</div>
                        <div>{{ $passenger->id }}</div>
                    </div>
                    <div>
                        <div class="title">First Name</div>
                        <div>{{ $passenger->first_name }}</div>
                    </div>
                    <div>
                        <div class="title">Last Name</div>
                        <div>{{ $passenger->last_name }}</div>
                    </div>

                    @if ($passenger->phone)
                        <div>
                            <div class="title">@lang("content.phone")</div>
                            <div>{{ $passenger->phone }}</div>
                        </div>
                    @endif
                    @if ($passenger->mobile)
                        <div>
                            <div class="title">@lang("content.mobile")</div>
                            <div>{{ $passenger->mobile }}</div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="col-sm-6">
        {!! Form::open(['method' => 'POST', 'class' => 'form-inline']) !!}

        <table class="table table-bordered table-striped table-hover editable_table" data-passenger_id = "{!!$passenger->id!!}" style="width:100%; padding: 0; margin: 0">
            <thead>
            <tr>
                <th>Category</th>
                <th colspan="3">@lang("content.info")</th>
            </tr>
            </thead>

            <tbody>
            <tr>
                <td class="header_profile">@lang("content.first_name")</td>
                <td>
                    <a href="#" data-field = 'first_name' data-model="Passenger" data-type="text" data-id = '{!! $passenger->id !!}' data-placeholder="Required"
                       class="editable {!! $passenger->first_name ? 'editable-click' : 'editable-empty' !!}">{!! $passenger->first_name !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.last_name")</td>
                <td>
                    <a href="#" data-field = 'last_name' data-model="Passenger" data-type="text" data-id = '{!! $passenger->id !!}' data-placeholder="Required"
                       class="editable {!! $passenger->last_name ? 'editable-click' : 'editable-empty' !!}">{!! $passenger->last_name !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">VIP</td>
                <td>
                    <a href="#" data-field = 'is_vip' data-model="Passenger" data-type="select" data-id = '{{ $passenger->id }}' data-placeholder="Required"
                       data-value = '{{ $passenger->is_vip }}' class="editable {!! $passenger->is_vip ? 'editable-click' : 'editable-empty' !!}">
                        {!! $passenger->is_vip ? "Yes" : "No" !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Company Name</td>
                <td>
                    <a href="#" data-field = 'company' data-model="Passenger" data-type="text" data-id = '{!! $passenger->id !!}' data-placeholder="Required"
                       class="editable {!! $passenger->company ? 'editable-click' : 'editable-empty' !!}">{!! $passenger->company ? $passenger->company : 'Empty'  !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.position")</td>
                <td>
                    <a href="#" data-field = 'position' data-model="Passenger" data-type="text" data-id = '{!! $passenger->id !!}' data-placeholder="Required"
                       class="editable {!! $passenger->position ? 'editable-click' : 'editable-empty' !!}">{!! $passenger->position ? $passenger->position : 'Empty'  !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.email")</td>
                <td>
                    <a href="#" data-field = 'email' data-model="Passenger" data-type="text" data-id = '{!! $passenger->id !!}' data-placeholder="Required"
                       class="editable {!! $passenger->email ? 'editable-click' : 'editable-empty' !!}">{!! $passenger->email ? $passenger->email : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.date_of_birth")</td>
                <td>
                    <a href="#" data-field = 'dob' data-model="Passenger" data-type="date" data-id = '{!! $passenger->id !!}' data-placeholder="Required" data-format = 'd-M-Y' data-js_format = 'DD-MMM-YYYY'
                       data-value = '{!! $passenger->pob_country_id !!}'  class="editable {!! $passenger->dob ? 'editable-click' : 'editable-empty' !!}">
                        {!! $passenger->dob  ?  date('d-M-Y', strtotime($passenger->dob))  : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.place_of_birth")</td>
                <td>
                    <a href="#" data-field = 'pob_country_id' data-model="Passenger" data-type="select" data-id = '{!! $passenger->id !!}' data-placeholder="Required"
                       data-value = '{!! $passenger->pob_country_id !!}' class="editable {!! $passenger->pob ? 'editable-click' : 'editable-empty' !!}">
                        {!! $passenger->pob ? $passenger->pob->country : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.nationality")</td>
                <td>
                    <a href="#" data-field = 'nationality_id' data-model="Passenger" data-type="select" data-id = '{!! $passenger->id !!}' data-placeholder="Required"
                       data-value = '{!! $passenger->nationality_id !!}' class="editable {!! $passenger->nationality_id ? 'editable-click' : 'editable-empty' !!}">
                        {!! $passenger->nationality_id ? $passenger->nationality->nationality : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.language")</td>
                <td>
                    <a href="#" data-field = 'language_id' data-model="PassengerLanguage" data-type="multiselect" data-id = '{!! $passenger->id !!}' data-foreign_key = 'passenger_id'
                       data-placeholder="Required" data-value = '{!! json_encode($languageIds) !!}' class="editable {!! count($languages) ? 'editable-click' : 'editable-empty' !!}">
                        {!! count($languages) ? implode(', ', $languages) : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.phone")</td>
                <td>
                    <a href="#" data-field = 'phone' data-model="Passenger" data-type="text" data-id = '{!! $passenger->id !!}'
                       data-placeholder="Required" class="editable {!! $passenger->phone ? 'editable-click' : 'editable-empty' !!}">
                        {!! $passenger->phone ? $passenger->phone : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">@lang("content.passport")</td>
                <td>
                    <a href="#" data-field = 'passport_country_id' data-model="Passenger" data-type="select" data-id = '{!! $passenger->id !!}' data-placeholder="Required"
                       data-value = '{!! $passenger->passport_country_id !!}' class="editable {!! $passenger->passport_country_id ? 'editable-click' : 'editable-empty' !!}">
                        {!! $passenger->passport_country_id ? $passenger->passport->country : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Passport No.</td>
                <td>
                    <a href="#" data-field = 'passport_num' data-model="Passenger" data-type="text" data-id = '{!! $passenger->id !!}' data-placeholder="Required"
                       class="editable {!! $passenger->passport_num ? 'editable-click' : 'editable-empty' !!}">
                        {!! $passenger->passport_num ? $passenger->passport_num : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Passport DOI</td>
                <td>
                    <a href="#" data-field = 'passport_doi' data-model="Passenger" data-type="date" data-id = '{!! $passenger->id !!}' data-placeholder="Required" data-format = 'd-M-Y'
                       data-js_format = 'DD-MMM-YYYY'  data-value = '{!! $passenger->passport_doi !!}' class="editable {!! $passenger->passport_dex ? 'editable-click' : 'editable-empty' !!}">
                        {!! $passenger->passport_doi  ?  date('d-M-Y', strtotime($passenger->passport_doi))  : 'Empty' !!}</a>
                </td>
            </tr>
            <tr>
                <td class="header_profile">Passport DEX</td>
                <td>
                    <a href="#" data-field = 'passport_dex' data-model="Passenger" data-type="date" data-id = '{!! $passenger->id !!}' data-placeholder="Required" data-format = 'd-M-Y'
                       data-js_format = 'DD-MMM-YYYY'  data-value = '{!! $passenger->passport_dex !!}' class="editable {!! $passenger->passport_dex ? 'editable-click' : 'editable-empty' !!}">
                        {!! $passenger->passport_dex  ?  date('d-M-Y', strtotime($passenger->passport_dex))  : 'Empty' !!}</a>
                </td>
            </tr>
            </tbody>
        </table>

        {!! Form::close() !!}
    </div>

</div>
