<?php require_once(public_path("smart/inc/init.php")); ?>

<link rel="stylesheet" href="{{ asset("/assets/css/editable.css") }}" />

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Commercial', 'moduleName' => 'Passengers'])

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#profile" role="tab" data-toggle="tab">@lang("content.profile")</a>
                </li>
                <li>
                    <a href="#flights" role="tab" data-toggle="tab">@lang("content.flights")</a>
                </li>
            </ul>

            <div id="tabContent" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="profile" style="width: 100%;">
                    @include("passenger.layouts.index-profile-tab")
                </div>

                <div class="tab-pane" id="flights">
                    @include("passenger.layouts.index-flights-tab")
                </div>

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#tableFlights");

    };

    loadScript("{{ asset('/assets/js/views/passenger/index.js') }}", pagefunction);

</script>




