@extends("...layout")

@section("content")

<ul class="breadcrumb">
  <li>{!! HTML::link('passenger', 'Revenue Data', array('id' => 'linkid')) !!}</li>
  <li @if(!isset($flight_number)) class="active" @endif>@if(isset($flight_number)) {!! HTML::link("passenger/flight/$date", $date) !!} @else {!!$date!!} @endif</li>

  @if(!isset($sales_date))
    <li @if(isset($flight_number)) class="active" @endif>@if(isset($flight_number)) {!! HTML::link("passenger/flight/$date", $flight_number) !!} @else {!!$flight_number!!} @endif</li>
  @elseif(isset($sales_date))
    <li>{!! HTML::link("passenger/flight/$date/$flight_number", $flight_number) !!} </li>
    <li class="active">{!!$sales_date!!}</li>
  @endif
</ul>


<div style='margin-top: 20px;'>
<table class="tablesorter table table-bordered table-striped table-hover">
<thead>
<tr>
    <th>No</th>
    <th>@lang("content.first_name")</th>
    <th>@lang("content.last_name")</th>
    <th>@lang("content.flight_number")</th>
    <th>@lang("content.route")</th>
    <th>@lang("content.ticket_number")</th>
    <th>@lang("content.coupon")</th>
    <th>@lang("content.status")</th>
    <th>Fare(USD)</th>
    <th>@lang("content.fare_basis")</th>
    <th>@lang("content.sales_date")</th>
    <th>@lang("content.agency")</th>
    <th>IATA/TCH Code</th>
</tr>
</thead>
<tbody>

@foreach($passengers as $index=>$each)
    <tr>
        <td>{!!$index+1!!}</td>
        {{--<td>{!! HTML::link("forwardrevenue/{$date}/{$each->flight_number}/{$each->last_name}", $each->last_name, array('id' => 'linkid'))!!}</td>--}}
        @php $passengerLink = getPassengerLink($each['passenger_id']) @endphp
        <td>{!!$each->first_name!!}</td>
        <td><a href="{{ $passengerLink  }}">{!!$each->last_name!!}</a></td>

        <td>{!!$each->flight_number!!}</td>
        <td>{!!$each->departure_airport!!}-{!!$each->arrival_airport!!}</td>
        <td>{!!$each->ticket_number!!}</td>
        <td>{!!$each->coupon!!}</td>
        <td>{!!$each->status!!}</td>
        <td>{!!number_format($each->fare)!!}</td>
        <td>{!!$each->fare_basis!!}</td>
        <td>{!!$each->sales_date!!}</td>
        <td>{!!$each->agency!!}</td>
        <td>{!!$each->code!!}</td>

    </tr>
@endforeach
</tbody>


</table>
</div>

@stop

@section("js_scripts")

{{--<script type="text/javascript" src="https://www.google.com/jsapi"></script>--}}

<script src="{!!route("homepage")."#". url("/")!!}/assets/js/views/passenger/flight.js"></script>
@stop