<?php require_once(public_path("smart/inc/init.php")); ?>
        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            @include('passenger-report.layouts.transfer-form', ['enableAirline' => true, 'enableAirport' => true])
        </article>

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#list" role="tab" data-toggle="tab">@lang("content.list")</a>
                </li>

                <li class="">
                    <a href="#summary" role="tab" data-toggle="tab">@lang("content.summary")</a>
                </li>

            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10 background-white">
                <div class="tab-pane active" id="list">
                    @include('passenger-report.layouts.transfer-table')
                </div>
                <div class="tab-pane " id="summary">
                    @include('passenger-report.layouts.transfer-summary-table')
                </div>
            </div>
        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        @if (ghaModule())
            ApplyOperationsFormFilter({!! json_encode($flightNumbers) !!}, {!! json_encode(\request("flightNumber")) !!}, {!! json_encode($sectors) !!}, {!! json_encode($sectorsByAirlines) !!}, {!! json_encode(\request("sector")) !!});
        @endif

        ApplyTableFilter("#passenger-report-table");

        ApplyTableFilter("#summary-report-table");
    };

    pagefunction();

</script>
