<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-transfer" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
<!-- widget options:
usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

data-widget-colorbutton="false"
data-widget-editbutton="false"
data-widget-togglebutton="false"
data-widget-deletebutton="false"
data-widget-fullscreenbutton="false"
data-widget-custombutton="false"
data-widget-collapsed="true"
data-widget-sortable="false"

-->
<header>

    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

    <h2>@lang("content.list")</h2>

</header>

<!-- widget div-->
<div>

    <!-- widget edit box -->
    <div class="jarviswidget-editbox">
        <!-- This area used as dropdown edit box -->

    </div>
    <!-- end widget edit box -->

    <!-- widget content -->
    <div class="widget-body no-padding">

        <div class="table-responsive">

            @if (isset($transferPAX) && count($transferPAX))

                @php $onlyInbound = \request("transfer") && in_array("ib", \request("transfer")) @endphp
                @php $onlyOutbound = \request("transfer") && in_array("ob", \request("transfer")) @endphp

                <table class="table table-bordered table-hover" id="passenger-report-table" style="min-width: 100%">

                    <thead>
                    <tr>
                        <th rowspan="2">No</th>
                        {{--Base info--}}
                        <th colspan="3">@lang("content.flight_details")</th>
                        <th rowspan="2">@lang("content.first_name")</th>
                        <th rowspan="2">@lang("content.last_name")</th>
                        <th rowspan="2">@lang("content.seat_number")</th>
                        {{--END--}}
                        {{--<th rowspan="2">TKT NO</th>--}}
                        {{--<th rowspan="2">CPN</th>--}}
                        {{--<th rowspan="2">GRP</th>--}}
                        {{--<th rowspan="2">PNR</th>--}}

                        @if ($onlyInbound)
                            <th colspan="5" data-center>I/B</th>
                        @endif
                        @if ($onlyOutbound)
                            <th colspan="5" data-center>O/B</th>
                        @endif
                    </tr>

                    <tr>
                        <th style="min-width: 40px;">No</th>
                        <th style="min-width: 60px;">@lang("content.sector")</th>
                        <th style="min-width: 60px;">@lang("content.date")</th>

                        @if ($onlyInbound)
                            <th>@lang("content.airline")</th>
                            <th>@lang("content.flight_number")</th>
                            <th>RBD</th>
                            <th style="min-width: 60px;">@lang("content.arrival_date")</th>
                            <th>@lang("content.origin")</th>
                        @endif

                        @if ($onlyOutbound)
                            <th>@lang("content.airline")</th>
                            <th>@lang("content.flight_number")</th>
                            <th>RBD</th>
                            <th style="min-width: 60px;">@lang("content.departure_date")</th>
                            <th>@lang("content.destination")</th>
                        @endif
                    </tr>

                    </thead>

                    <tbody>
                    @foreach($transferPAX as $i => $each)
                        @php $combinedInfo = $each->combined_info @endphp
                        @php $passenger = $each->passenger @endphp
                        @php $flight = $each->flight @endphp
                        @php $flightNumber = $flight ? $flight->flightNumber : null @endphp
                        @php $depAirport = $flightNumber ? $flightNumber->departureAirport : null @endphp
                        @php $arrAirport = $flightNumber ? $flightNumber->arrivalAirport : null @endphp
                        @php $airline = $flightNumber ? $flightNumber->airline : null @endphp

                        @php $fltNo  = ($airline ? getAirlineCode($airline) : "").($flightNumber ? $flightNumber->flight_number : "-") @endphp
                        @php $sector = ($depAirport ? $depAirport->iata : "")."-".($arrAirport ? $arrAirport->iata : "") @endphp

                        <tr>
                            <td>{{ $i + 1 }}</td>
                            <td>{{ $fltNo }}</td>
                            <td>{{ $sector }}</td>
                            <td>{{ $flight ? baseDateFormat(getFlightDepartureDate($flight)) : "-" }}</td>

                            @php $passengerLink = getPassengerLink($each['passenger_id']) @endphp
                            <td data-left><a target="_blank" href="{{ $passengerLink }}">{{ $passenger ? $passenger->first_name : "" }}</a></td>
                            <td data-left><a target="_blank" href="{{ $passengerLink }}">{{ $passenger ? $passenger->last_name : "" }}</a></td>

                            <td>{{ $each->seat_number && strlen($each->seat_number) == 2 ? "0".$each->seat_number : $each->seat_number }}</td>

                            {{--<td>{{ $each->passengerOrder ? $each->passengerOrder->ticket_number : "" }}</td>--}}
                            {{--<td>{{ $each->coupon }}</td>--}}
                            {{--<td>{{ $each->group_tcp }}</td>--}}
                            {{--<td>{{ $each->passengerOrder ? $each->passengerOrder->pnr : "" }}</td>--}}



                            @if ($onlyInbound)
                                <td>{{ isset($combinedInfo['inbound']['airline'])            ? $combinedInfo['inbound']['airline']              : "" }}</td>
                                <td>{{ isset($combinedInfo['inbound']['flight_number'])      ? $combinedInfo['inbound']['flight_number']        : "" }}</td>
                                <td>{{ isset($combinedInfo['inbound']['rbd'])                ? $combinedInfo['inbound']['rbd']                  : "" }}</td>
                                <td>{{ isset($combinedInfo['inbound']['arrival_date'])       ? $combinedInfo['inbound']['arrival_date']         : "" }}</td>
                                <td>{{ isset($combinedInfo['inbound']['origin'])             ? $combinedInfo['inbound']['origin']               : "" }}</td>
                            @endif

                            @if ($onlyOutbound)
                                <td>
                                    {{  isset($combinedInfo['outbound']['airline'])          ? $combinedInfo['outbound']['airline']            : "" }}
                                    {!! isset($combinedInfo['outbound']['airline2'])         ? "<br/>".$combinedInfo['outbound']['airline2']   : "" !!}
                                </td>
                                <td>
                                    {{ isset($combinedInfo['outbound']['flight_number'])     ? $combinedInfo['outbound']['flight_number']      : "" }}
                                    {!! isset($combinedInfo['outbound']['flight_number2'])   ? "<br/>".$combinedInfo['outbound']['flight_number2']   : "" !!}
                                </td>
                                <td>
                                    {{ isset($combinedInfo['outbound']['rbd'])               ? $combinedInfo['outbound']['rbd']                : "" }}
                                    {!! isset($combinedInfo['outbound']['rbd2'])             ? "<br/>".$combinedInfo['outbound']['rbd2']   : "" !!}
                                </td>
                                <td>
                                    {{ isset($combinedInfo['outbound']['departure_date'])    ? $combinedInfo['outbound']['departure_date']     : "" }}
                                    {!! isset($combinedInfo['outbound']['departure_date2'])  ? "<br/>".$combinedInfo['outbound']['departure_date2']   : "" !!}
                                </td>
                                <td>
                                    {{ isset($combinedInfo['outbound']['destination'])       ? $combinedInfo['outbound']['destination']        : "" }}
                                    {!! isset($combinedInfo['outbound']['destination2'])     ? "<br/>".$combinedInfo['outbound']['destination2']   : "" !!}
                                </td>
                            @endif
                        </tr>
                    @endforeach
                    </tbody>

                </table>

            @endif

        </div>

    </div>

</div>

</div>
