<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
<!-- widget options:
usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

data-widget-colorbutton="false"
data-widget-editbutton="false"
data-widget-togglebutton="false"
data-widget-deletebutton="false"
data-widget-fullscreenbutton="false"
data-widget-custombutton="false"
data-widget-collapsed="true"
data-widget-sortable="false"

-->
<header>

    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

    <h2>@lang("content.list")</h2>

</header>

<!-- widget div-->
<div>

    <!-- widget edit box -->
    <div class="jarviswidget-editbox">
        <!-- This area used as dropdown edit box -->

    </div>
    <!-- end widget edit box -->

    <!-- widget content -->
    <div class="widget-body no-padding">

        <div class="table-responsive">

            @if (count($paxAct))
                <table class="table table-bordered table-hover" id="passenger-report-table">

                    <thead>
                    <tr>
                        <th rowspan="2">No</th>

                        @if (\request("show_source"))
                            <th colspan="5" data-center>@lang("content.source")</th>
                        @endif

                        {{--Base info--}}
                        <th colspan="3">@lang("content.flight_details")</th>
                        <th rowspan="2">@lang("content.first_name")</th>
                        <th rowspan="2">@lang("content.last_name")</th>
                        @if (\request("show_gender"))
                            <th rowspan="2">@lang("content.gender")</th>
                        @endif
                        <th rowspan="2">@lang("content.seat_number")</th>
                        {{--END--}}

                        @if (\request("show_tkt_no"))
                            <th rowspan="2">TKT NO</th>
                        @endif
                        @if (\request("show_cpn"))
                            <th rowspan="2">CPN</th>
                        @endif
                        @if (\request("show_grp"))
                            <th rowspan="2">GRP</th>
                        @endif
                        @if (\request("show_pnr"))
                            <th rowspan="2">PNR</th>
                        @endif
                        @if (\request("show_fqtv"))
                            <th rowspan="2">FQTV</th>
                        @endif
                        @if (\request("show_spml"))
                            <th rowspan="2">SPML</th>
                        @endif
                        @if (\request("show_ib"))
                            <th colspan="5">I/B</th>
                        @endif
                        @if (\request("show_ob"))
                            <th colspan="5">O/B</th>
                        @endif
                        @if (\request("show_cs"))
                            <th colspan="3">@lang("content.codeshare")</th>
                        @endif
                        @if (\request("show_ssr"))
                            <th colspan="2">SSR</th>
                        @endif
                        @if (\request("show_bag"))
                            <th colspan="3" data-center>@lang("content.baggage")</th>
                        @endif

                        @if (\request("show_ib") || \request("show_ob") || \request("show_cs") || \request("show_ssr") || \request("show_bag"))
                            <th rowspan="2">No</th>
                        @endif
                    </tr>

                    <tr>
                        @if (\request("show_source"))
                            <th>PNL</th>
                            <th>PRL</th>
                            <th>TPM</th>
                            <th>PTM</th>
                            <th>PSM</th>
                        @endif

                        <th style="min-width: 40px;">No</th>
                        <th style="min-width: 60px;">@lang("content.sector")</th>
                        <th style="min-width: 60px;">@lang("content.date")</th>



                        @if (\request("show_ib"))
                            <th>@lang("content.airline")</th>
                            <th>@lang("content.flight_number")</th>
                            <th>RBD</th>
                            <th style="min-width: 60px;">@lang("content.arrival_date")</th>
                            <th>@lang("content.origin")</th>
                        @endif

                        @if (\request("show_ob"))
                            <th>@lang("content.airline")</th>
                            <th>@lang("content.flight_number")</th>
                            <th>RBD</th>
                            <th style="min-width: 60px;">@lang("content.departure_date")</th>
                            <th>@lang("content.destination")</th>
                        @endif

                        @if (\request("show_cs"))
                            <th>@lang("content.airline")</th>
                            <th>@lang("content.flight_number")</th>
                            <th>RBD</th>
                        @endif

                        @if (\request("show_ssr"))
                            <th>@lang("content.service")</th>
                            <th>@lang("content.info")</th>
                        @endif

                        @if (\request("show_bag"))
                            <th>Pcs</th>
                            <th>Wt</th>
                            <th>@lang("content.tag_no")</th>
                        @endif
                    </tr>

                    </thead>

                    <tbody>
                    @foreach($paxAct as $i => $each)
                        @php $combinedInfo = $each->combined_info @endphp
                        @php $passenger = $each->passenger @endphp
                        @php $flight = $each->flight @endphp
                        @php $flightNumber = $flight ? $flight->flightNumber : null @endphp
                        @php $depAirport = $flightNumber ? $flightNumber->departureAirport : null @endphp
                        @php $arrAirport = $flightNumber ? $flightNumber->arrivalAirport : null @endphp
                        @php $airline = $flightNumber ? $flightNumber->airline : null @endphp

                        @php $fltNo  = ($airline ? getAirlineCode($airline) : "").($flightNumber ? $flightNumber->flight_number : "-") @endphp
                        @php $sector = ($depAirport ? $depAirport->iata : "")."-".($arrAirport ? $arrAirport->iata : "") @endphp

                        <tr>
                            <td>{{ $i + 1 }}</td>

                            @if (\request("show_source"))
                                <td>{!! $each->from_pnl ? '<i class="fa fa-check"></i>' : "" !!}</td>
                                <td>{!! $each->from_prl ? '<i class="fa fa-check"></i>' : "" !!}</td>
                                <td>{!! $each->from_tpm ? '<i class="fa fa-check"></i>' : "" !!}</td>
                                <td>{!! $each->from_ptm ? '<i class="fa fa-check"></i>' : "" !!}</td>
                                <td>{!! $each->from_psm ? '<i class="fa fa-check"></i>' : "" !!}</td>
                            @endif

                            <td>{{ $fltNo }}</td>
                            <td>{{ $sector }}</td>
                            <td>{{ $flight ? baseDateFormat(getFlightDepartureDate($flight)) : "-" }}</td>


                            @php $passengerLink = getPassengerLink($each['passenger_id']) @endphp
                            <td data-left><a target="_blank" href="{{ $passengerLink }}">{{ $passenger ? $passenger->first_name : "" }}</a></td>
                            <td data-left><a target="_blank" href="{{ $passengerLink }}">{{ $passenger ? $passenger->last_name : "" }}</a></td>

                            @if (\request("show_gender"))
                                <td>{{ $each->is_inf ? INF_USE : getGenderAbbr($passenger->gender) }}</td>
                            @endif

                            <td>{{ $each->seat_number && strlen($each->seat_number) == 2 ? "0".$each->seat_number : $each->seat_number }}</td>

                            @if (\request("show_tkt_no"))
                                <td>{{ $each->passengerOrder ? $each->passengerOrder->ticket_number : "" }}</td>
                            @endif

                            @if (\request("show_cpn"))
                                <td>{{ $each->coupon }}</td>
                            @endif

                            @if (\request("show_grp"))
                                <td>{{ $each->group_tcp }}</td>
                            @endif

                            @if (\request("show_pnr"))
                                <td>{{ $each->passengerOrder ? $each->passengerOrder->pnr : "" }}</td>
                            @endif

                            @if (\request("show_fqtv"))
                                <td>{{ $combinedInfo['fqtv'] }}</td>
                            @endif

                            @if (\request("show_spml"))
                                <td>{{ $combinedInfo['spml'] }}</td>
                            @endif

                            @if (\request("show_ib"))
                                <td>{{ isset($combinedInfo['inbound']['airline'])            ? $combinedInfo['inbound']['airline']              : "" }}</td>
                                <td>{{ isset($combinedInfo['inbound']['flight_number'])      ? $combinedInfo['inbound']['flight_number']        : "" }}</td>
                                <td>{{ isset($combinedInfo['inbound']['rbd'])                ? $combinedInfo['inbound']['rbd']                  : "" }}</td>
                                <td>{{ isset($combinedInfo['inbound']['arrival_date'])       ? $combinedInfo['inbound']['arrival_date']         : "" }}</td>
                                <td>{{ isset($combinedInfo['inbound']['origin'])             ? $combinedInfo['inbound']['origin']               : "" }}</td>
                            @endif

                            @if (\request("show_ob"))
                                <td>
                                    {{  isset($combinedInfo['outbound']['airline'])          ? $combinedInfo['outbound']['airline']            : "" }}
                                    {!! isset($combinedInfo['outbound']['airline2'])         ? "<br/>".$combinedInfo['outbound']['airline2']   : "" !!}
                                </td>

                                <td>
                                    {{ isset($combinedInfo['outbound']['flight_number'])     ? $combinedInfo['outbound']['flight_number']      : "" }}
                                    {!! isset($combinedInfo['outbound']['flight_number2'])   ? "<br/>".$combinedInfo['outbound']['flight_number2']   : "" !!}
                                </td>

                                <td>
                                    {{ isset($combinedInfo['outbound']['rbd'])               ? $combinedInfo['outbound']['rbd']                : "" }}
                                    {!! isset($combinedInfo['outbound']['rbd2'])             ? "<br/>".$combinedInfo['outbound']['rbd2']   : "" !!}
                                </td>

                                <td>
                                    {{ isset($combinedInfo['outbound']['departure_date'])    ? $combinedInfo['outbound']['departure_date']     : "" }}
                                    {!! isset($combinedInfo['outbound']['departure_date2'])  ? "<br/>".$combinedInfo['outbound']['departure_date2']   : "" !!}
                                </td>

                                <td>
                                    {{ isset($combinedInfo['outbound']['destination'])       ? $combinedInfo['outbound']['destination']        : "" }}
                                    {!! isset($combinedInfo['outbound']['destination2'])     ? "<br/>".$combinedInfo['outbound']['destination2']   : "" !!}
                                </td>
                            @endif

                            @if (\request("show_cs"))
                                <td>{{ isset($combinedInfo['codeshare']['airline'])            ? $combinedInfo['codeshare']['airline']              : "" }}</td>
                                <td>{{ isset($combinedInfo['codeshare']['flight_number'])      ? $combinedInfo['codeshare']['flight_number']        : "" }}</td>
                                <td>{{ isset($combinedInfo['codeshare']['rbd'])                ? $combinedInfo['codeshare']['rbd']                  : "" }}</td>
                            @endif

                            @if (\request("show_ssr"))
                                <td>
                                    @if (count($combinedInfo['ssr']))
                                        @foreach($combinedInfo['ssr'] as $ssr)
                                            {{ $ssr }}<br/>
                                        @endforeach
                                    @endif
                                </td>
                                <td>{{ $each->ssr_info }}</td>
                            @endif


                            @if (\request("show_bag"))
                                <td>{{ $each->baggage_pcs }}</td>
                                <td>{{ $each->baggage_weight }}</td>
                                <td>
                                    @if ($each->tag_number)
                                        @php $tn = explode(";", $each->tag_number) @endphp
                                        <select>
                                            @foreach($tn as $option)
                                                <option>{{ $option }}</option>
                                            @endforeach
                                        </select>
                                    @endif
                                </td>
                            @endif

                            @if (\request("show_ib") || \request("show_ob") || \request("show_cs") || \request("show_ssr") || \request("show_bag"))
                                <td>{{ $i + 1 }}</td>
                            @endif
                        </tr>
                    @endforeach
                    </tbody>

                </table>

            @endif

        </div>

    </div>

</div>

</div>
