<div>
    {!! Form::open(['class' => 'form-inline', 'method' => 'GET', 'id' => 'formOPS']) !!}
    @if (isset($enableRevenue) && $enableRevenue)
        <div class="form-group marginBottomRight">
            <label class="control-label">@lang("content.report_type")Report Type</label>
            {!! Form::select('reportType', $reportTypes, \request("reportType"), ['class'=>'singleselect', 'id'=>'report_type']) !!}
        </div>
        <div class="form-group marginBottomRight">
            <label class="control-label">@lang("content.country")</label>
            {!! Form::select('country[]', $countries, \request("country"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'country']) !!}

        </div>
        <div class="form-group marginBottomRight">
            <label class="control-label">@lang("content.city")</label>
            {!! Form::select('city[]', $cities, \request("city"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'city']) !!}
        </div>
        <div class="form-group marginBottomRight">
            <label class="control-label">@lang("content.agency")</label>
            {!! Form::select('agency[]', $agencies, \request("agency"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'agency']) !!}
        </div>
    @endif

    @if (env(MULTIPLE_AIRLINE) && ghaModule() && isset($enableAirline) && $enableAirline)
        <div class="form-group marginBottomRight">
            <label>@lang("content.airline")</label>

            <div class="btn-group">
                {!! Form::select('airline', $airlines, \request("airline"), [ 'required', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
            </div>
        </div>
    @endif

    @if (isset($enableAirport) && $enableAirport)
        <div class="form-group marginBottomRight">
            <label>@lang("content.airport")</label>

            <div class="btn-group">
                {!! Form::select('airport[]', $airports, \request("airport"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']) !!}
            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label>@lang("content.type")</label>

            <div class="btn-group">
                {!! Form::select('type', [ALL => ALL, DEPARTURE => DEPARTURE, ARRIVAL => ARRIVAL, ], \request("type"), [ 'class'=>'multiselect', 'id'=> 'type' ]) !!}
            </div>
        </div>
    @endif

    <div class="form-group marginBottomRight">
        {!! Form::hidden('activeTab', 'Analysis') !!}
        <label>{!! Form::radio('flightSearch','flightNumber', !\request("flightSearch") || \request("flightSearch") == 'flightNumber') !!}
            @lang("content.flight_number")</label>

        <div class="btn-group">
            @if (is_array($flightNumbers))
                {!! Form::select('flightNumber[]', $flightNumbers, \request("flightNumber"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'flight_number']) !!}
            @else
                <select name="flightNumber[]" class="multiselect_search" id="flight_number" multiple>
                    @foreach($flightNumbers as $each)
                        <option value="{{ $each->id }}" {!! \request("flightNumber") && in_array($each->id, \request("flightNumber")) ? "selected" : "" !!}>{{ $each->sector }}</option>
                    @endforeach
                </select>
            @endif
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label>{!! Form::radio('flightSearch','sector', \request("flightSearch") == 'sector') !!} @lang("content.sector")</label>

        <div class="btn-group">
            {!! Form::select('sector[]', $sectors, \request("sector"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'sector']) !!}
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label>{!! Form::radio('dateSearch','fromTo', !\request("dateSearch") || \request("dateSearch") == 'fromTo') !!}
            @lang("content.from")</label>
        {!! Form::text('dateFrom', !\request("dateSearch") ? $dateYesterday : \request("dateFrom"), ['class'=>'form-control dateFrom myinput', 'placeholder'=>'From Date', 'id'=>'from_date']) !!}
        <label form="dateTo">@lang("content.to")</label>
        {!! Form::text('dateTo', !\request("dateSearch") ? $dateYesterday : \request("dateTo"), ['class'=>'form-control dateTo myinput', 'placeholder' => 'To Date', 'id'=>'to_date']) !!}
    </div>

    <div class="form-group marginBottomRight">
        <label>{!! Form::radio('dateSearch','monthYear', \request("dateSearch") == 'monthYear') !!}@lang("content.month")</label>

        <div class="btn-group">
            {!! Form::select('month[]', $monthNames, \request("month"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'month']) !!}
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label for="year" class="control-label">@lang("content.year")</label>

        <div class="btn-group">
            {!! Form::select('year', $years, getSelectedYear(), ['class'=>'singleselect']) !!}
        </div>
    </div>

    @if (isset($enablePeriod) && $enablePeriod)
        <div class="form-group marginBottomRight">
            <label for="period" class="control-label">@lang("content.period")</label>

            <div class="btn-group">
                {!! Form::select('period', $periods, \request("period"), ['class'=>'multiselect_search', 'id'=>'period']) !!}
            </div>
        </div>
    @endif

    <div class="form-group marginBottomRight">
        <label for="transfer" class="control-label">@lang("content.transfer")</label>

        <div class="btn-group">
            {!! Form::select('transfer[]', $transferList, \request("transfer"), ['multiple'=>'multiple', 'class'=>'multiselect', ]) !!}
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label for="ssr" class="control-label">SSR</label>

        <div class="btn-group">
            {!! Form::select('ssr[]', $ssrList, \request("ssr"), ['multiple'=>'multiple', 'class'=>'multiselect_search',]) !!}
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label for="first_name" class="control-label">@lang("content.first_name")</label>

        <div class="btn-group">
            {!! Form::text('first_name', \request("first_name"), ['class'=>'form-control', 'placeholder'=>'First Name', 'id'=>'first_name']) !!}
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label for="last_name" class="control-label">@lang("content.last_name")</label>

        <div class="btn-group">
            {!! Form::text('last_name', \request("last_name"), ['class'=>'form-control', 'placeholder'=>'Last Name', 'id'=>'last_name']) !!}
        </div>
    </div>


    <div class="form-group marginBottomRight">
        <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
    </div>

    <div class="smart-form col-sm-12 no-padding" style="margin: 0 0 15px 0; display: inline-block">
        <section>
            <label class="label col-sm-12" style="border-bottom: 1px solid #b9b9b9;font-weight: bold;" >@lang("content.add_details")</label>

            <label class="col-md-12" id="add_details_layout">
                <div class="inline-group">
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="0" name="show_source" {!! \request("show_source") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">SOURCE</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="0" name="show_gender" {!! \request("show_gender") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">GENDER</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="0" name="show_tkt_no" {!! \request("show_tkt_no") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">TKT NO</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="0" name="show_cpn" {!! \request("show_cpn") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">CPN</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="0" name="show_grp" {!! \request("show_grp") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">GRP</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="0" name="show_pnr" {!! \request("show_pnr") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">PNR</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="1" name="show_fqtv" {!! \request("show_fqtv") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">FQTV</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="1" name="show_spml" {!! \request("show_spml") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">SPML</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="1" name="show_ib" {!! \request("show_ib") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">I/B</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="1" name="show_ob" {!! \request("show_ob") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">O/B</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="1" name="show_cs" {!! \request("show_cs") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">@lang("content.codeshare")</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="1" name="show_ssr" {!! \request("show_ssr") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">SSR</span></label>
                    <label class="checkbox margin-right-20">
                        <input type="checkbox" value="1" name="show_bag" {!! \request("show_bag") ? "checked" : "" !!} >
                        <i></i> <span style="margin-left: 10px;">@lang("content.baggage")</span></label>
                </div>
            </label>
        </section>

    </div>


    {!! Form::close() !!}
</div>