<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

        <style>
            #westpanel > p {
                font-weight: bold;
            }
            #westpanel > h4 {
                font-size: 16px;
                font-weight: bold;
                color: #000066;
            }
            #westpanel input {
                margin-right: 5px;
            }
            #westpanel select {
                font-weight: normal;
                max-width: 120px;
            }
        </style>



            @include('general.tab-header', ['departmentName' => 'Organization', 'moduleName' => 'Chart'])

            <div class="board">
                        <div class="board-inner">
                            <ul class="nav nav-tabs" id="myTab">
                                <div class="liner"></div>
                                <li class="active">
                                    <a href="#assigned" data-toggle="tab" title="Assigned">
                                        <span class="round-tabs one"><i class="glyphicon glyphicon-home"></i><span class="tabText">Assigned</span></span>
                                    </a>
                                </li>

                                <li>
                                    <a href="#undefined_hierarchy" data-toggle="tab" title="Undefined Hierarchy">
                                        <span class="round-tabs two"><i class="glyphicon glyphicon-exclamation-sign"></i><span class="tabText">Undefined Hierarchy</span></span>
                                    </a>
                                </li>
                                <li>
                                    <a href="#undefined_level" data-toggle="tab" title="Undefined Level">
                                        <span class="round-tabs two"><i class="glyphicon glyphicon-question-sign"></i><span class="tabText">Undefined Level</span></span>
                                    </a>
                                </li>

                            </ul>
                        </div>

                        <div class="tab-content">
                            <div class="tab-pane fade in active" id="assigned">
                                <div id="chart-container" style="height: 720px; background-color: transparent">
                                    <div id="contentpanel" style="padding: 0;">
                                        <!--bpcontent-->
                                        <div id="westpanel" style="padding: 5px; margin: 0px; max-width: 190px; border-style: solid; font-size: 12px; border-color: grey; border-width: 1px; overflow: scroll; -webkit-overflow-scrolling: touch;">
                                            <h4>Auto Layout Options</h4>
                                            <p id="pageFitMode">Page Fit Mode</p>
                                            <p id="orientationType">Orientation</p>
                                            <p id="verticalAlignment">Items Vertical Alignment</p>
                                            <p id="horizontalAlignment">Items Horizontal Alignment</p>
                                            <p id="leavesPlacementType">Leaves placement</p>
                                            <p id="minimalVisibility">Minimal nodes visibility</p>
                                            <p id="selectionPathMode">Selection Path Mode</p>
                                            <h4>Default Template Options</h4>
                                            <p id="hasButtons">User buttons</p>
                                            <p id="hasSelectorCheckbox">Selection check box</p>
                                            <h4>Minimized Item (Dot, Marker)</h4>
                                            <p id="minimizedItemCornerRadius">Corner Radius:&nbsp;</p>
                                            <p id="minimizedItemSize">Size:&nbsp;</p>
                                            <p id="highlightPadding">Highlight Padding:&nbsp;</p>
                                            <h4>Vertical Intervals Between Rows</h4>
                                            <p id="normalLevelShift">Normal:&nbsp;</p>
                                            <p id="dotLevelShift">Dotted:&nbsp;</p>
                                            <p id="lineLevelShift">Lined:&nbsp;</p>
                                            <h4>Horizontal Intervals Between Items in Row</h4>
                                            <p id="normalItemsInterval">Normal:&nbsp;</p>
                                            <p id="dotItemsInterval">Dotted:&nbsp;</p>
                                            <p id="lineItemsInterval">Lined:&nbsp;</p>
                                            <p id="cousinsIntervalMultiplier">Cousins Multiplier:&nbsp;</p>
                                            <h4>Connectors</h4>
                                            <p id="arrowsDirection">Arrows Direction</p>
                                            <p id="connectorType">Connectors</p>
                                            <p id="elbowType">Connectors Elbows Type</p>
                                            <p id="lineType">Line type</p>
                                            <p id="color">Color:&nbsp;</p>
                                            <p id="lineWidth">Line width:&nbsp;</p>
                                            <h4>Labels</h4>
                                            <p id="showLabels">Show Labels</p>
                                            <p id="labelOrientation">Label Orientation</p>
                                            <p id="labelPlacement">Label Placement</p>
                                            <h4>Rendering Mode</h4>
                                            <p id="graphicsType">Graphics</p>
                                            <p id="actualGraphicsType"></p>
                                        </div>
                                        <div id="centerpanel" style="overflow: hidden; padding: 10px; margin: 0px; border: 0px;">
                                        </div>
                                        {{--<div id="southpanel">--}}
                                        {{--</div>--}}
                                        <!--/bpcontent-->
                                    </div>
                                </div>
                            </div>

                            {{--Undefined Level--}}
                            <div class="tab-pane" id="undefined_hierarchy">
                                @if (isset($undefinedHierarchy))
                                    @include('organization/layouts/not-assigned-chart', ['data' => $undefinedHierarchy])
                                @endif
                            </div>

                            {{--Undefined Level--}}
                            <div class="tab-pane" id="undefined_level">
                                @if (isset($organizationNotAssigned))
                                    @include('organization/layouts/not-assigned-chart', ['data' => $organizationNotAssigned])
                                @endif
                            </div>


                            <div class="clearfix"></div>
                        </div>

                    </div>

        </article>

    </div>

</section>


<link href="{{ asset('/assets/chart/js/jquery/ui-lightness/jquery-ui-1.10.2.custom.css') }}" media="screen" rel="stylesheet" type="text/css" />
<link rel="stylesheet" type="text/css" href="{{ asset('/assets/chart/jquerylayout/layout-default-latest.css') }}" />

<link href="{{ asset('/assets/chart/css/primitives.latest.css?2021') }}" media="screen" rel="stylesheet" type="text/css" />

<script type="text/javascript">

    pageSetUp();

    var data = {!! $data !!};

    var pagefunction = function() {

        jQuery(document).ready(function () {
            jQuery('#chart-container').layout(
                {
                    center__paneSelector: "#contentpanel"
                });
        });

        function checkBoxChange(){
            var page = $(document);
            page.find('input[name="hasSelectorCheckbox"][value="2"]').prop('checked', true);
            page.find('#lineWidth > select').val(2);
            page.find('#color > select').val('#ff8c00');
            page.find('#minimizedItemSize > select').val(6);
            page.find('#minimalVisibility > select').val(1);
            page.find('input[name="pageFitMode"][value="1"]').prop('checked', true);
        }

        function PreSetup(options){
            options.hasSelectorCheckbox = 2;
            options.linesWidth = 2;
            options.linesColor = '#ff8c00';
            options.minimalVisibility = 1;
            options.pageFitMode = 1;

            checkBoxChange();
            return options;
        }

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

    };

    loadScript("{{ asset('/assets/chart/js/jquery/jquery-ui-1.10.2.custom.min.js') }}", function () {
        loadScript("{{ asset('/assets/chart/jquerylayout/jquery.layout-latest.min.js') }}", function () {
            loadScript("{{ asset('/assets/chart/js/primitives.min.js') }}", function () {
                loadScript("{{ asset('/assets/js/views/organization/new-chart.js') }}", pagefunction)
            });
        });
    });

</script>




