@php $class = isset($assigned) ? '' : 'bg-reddish' @endphp
<div class="list-my-group">
    <div class="head">
        <div>
            <div style="width: 5%">Level</div>
            <div style="width: 5%">Photo</div>
            <div style="width: 10%" data-left>@lang("content.first_name")</div>
            <div style="width: 10%" data-left>@lang("content.last_name")</div>
            <div style="width: 15%" data-left>@lang("content.position")</div>
            <div style="width: 10%" data-left>Accountable For</div>
            <div style="width: 10%" data-left>Reports To</div>
            <div style="width: 10%">Accountable Manager</div>
            <div style="width: 10%">Support Staff</div>
            <div style="width: 15%">@lang("content.actions")</div>
        </div>
    </div>
    <div class="body {{ $class }}">
        @foreach($organizationObject as $each)
            @php $picture = !is_null($each->thumb) ? $each->thumb : 'profile.png'; @endphp
            <div>
                <div style="width: 5%; min-width: 5%">{{ $each->level }}</div>
                <div style="width: 5%; min-width: 5%"><a href="{{ route("homepage")."#". url("user/{$each->user_id}") }}"><img src="{{ asset('/storage/users/'.$picture) }}" class="img-thumbnail thumb_report"  /></a></div>

                <div style="width: 10%; min-width: 10%" data-left>{{ $each->first_name }}</div>
                <div style="width: 10%; min-width: 10%" data-left>{{ $each->last_name }}</div>
                <div style="width: 15%; min-width: 15%" data-left><a href="{{ route("homepage")."#". url("organization/new-chart/{$each->id}") }}">{{ $each->position }}</a></div>

                <div style="width: 10%; min-width: 10%" data-left>
                    @foreach($each->tableInfo as $pos => $values)
                        {{ ucwords($pos)." : ".implode(', ', $values) }}
                    @endforeach
                </div>

                <div style="width: 10%; min-width: 10%" data-left>{{ $each->report_to }}</div>

                <div style="width: 10%; min-width: 10%" data-center><i class="{{ !$each->support_staff ? "glyphicon glyphicon-ok" : "glyphicon glyphicon-remove" }}"></i></div>
                <div style="width: 10%; min-width: 10%" data-center><i class="{{ $each->support_staff ? "glyphicon glyphicon-ok" : "glyphicon glyphicon-remove" }}"></i></div>
                <div style="width: 15%; min-width: 15%">
                    <a href="{{ route("homepage")."#". url('sales-organisation/profile/'.$each->id) }}" class="btn btn-warning">BSC</a>
                    <a href="{{ route("homepage")."#". url('organization/new-chart/'.$each->id) }}" class="btn btn-success">Display</a>
                    <a href="{{ route("homepage")."#". url('organization/'.$each->id."/edit?s=".rand(100, 999)) }}" class="btn btn-primary">@lang("content.edit")</a>

                    {!! Form::open(['method' => 'DELETE', 'data-same_url', 'class' => 'inline', 'url' =>  url('organization/'.$each->id) ]) !!}
                         {!! Form::submit('Delete', [ 'class' => "btn btn-danger"]) !!}
                    {!! Form::close() !!}
                </div>

            </div>
        @endforeach
    </div>
</div>
