<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */
?>





<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Organization', 'moduleName' => 'Edit'])

            <div class="ajax_info_container"></div>

            <div class="ajax_main_container">

                {!! Form::open(['method' => 'POST', 'class' => 'form-horizontal', 'url' =>  url('organization/'.$organization->id)]) !!}

                <div style="min-width: 800px; width: 70%">

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">@lang("content.department")</div>
                        <div class="col-md-3">
                            {!! Form::select('structure_department_id', $departments, $departmentId, ['id' => 'structure_department_id', 'class' => 'form-control singleselect', 'required' => 'required']) !!}
                        </div>
                    </div>


                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Employee</div>
                        <div class="col-md-3">
                            {!! Form::hidden('user_id', $organization->user_id) !!}
                            <h5 id="user_id">{{ $users[$organization->user_id] }}</h5>
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">@lang("content.position")</div>
                        <div class="col-md-3">
                            {!! Form::select('structure_position_id', $positions, $organization->structure_position_id, ['class' => 'form-control multiselect_search margin_right']) !!}
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Add New Position</div>
                        <div class="col-md-1 list" id="new_position" style="display: inline; padding-top: 0 !important;">
                            {!! Form::checkbox('new_position', null, false, ['class' => 'form-control input-sm', 'style' => 'margin:0; width: 20px; ']) !!}
                        </div>
                        <a target="_blank" style="display: inline-block; line-height: 35px" href="{{ route("homepage")."#". url('position')."?department_id={$departmentId}" }}">Go To Positions</a>
                    </div>

                    <div class="col-lg-12 list-header" style="display: none">
                        <div class="form-group has-feedback col-md-7">
                            <label class="control-label col-sm-2">@lang("content.position")</label>
                            <div class="col-sm-9">
                                {!! Form::text('new_position', null, ['class' => 'form-control', 'data-required']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Reports To CEO</div>
                        <div class="col-md-1 list" style="display: inline; padding-top: 0 !important;">
                            {!! Form::checkbox('reports_to_ceo', 1, false, ['class' => 'form-control input-sm', 'style' => 'margin:0; width: 20px; ']) !!}
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">@lang("content.designation")</div>
                        <div class="col-md-3">
                            <label class="margin_right_10">
                                {!! Form::radio('support_staff', 0, !$organization->support_staff, ['class' => 'form-control', 'required' => 'required']) !!}
                                Manager</label>
                            <label>
                                {!! Form::radio('support_staff', 1,  $organization->support_staff, ['class' => 'form-control', 'required' => 'required']) !!}
                                Support</label>
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Level</div>
                        <div class="col-md-3">
                            {!! Form::select('organization_level_id', $levels, $organization->organization_level_id, ['id' => 'organization_level_id', 'class' => 'form-control singleselect margin_right']) !!}
                        </div>
                    </div>

                    @foreach($related_tables as $each)
                        <div class="col-lg-12 list-header added related_tables">
                            <div class="col-md-3 list">{{ ucwords($each['data']['label']) }}</div>
                            <div class="col-md-3">
                                @if ($each['multiple'])
                                    {!! Form::select( $each['data']['table_name'].'[]', $each['data']['values'], $each['selected'], ['multiple' => 'multiple', 'class' => 'form-control multiselect margin_right']) !!}
                                @else
                                    {!! Form::select( $each['data']['table_name'], ['' => 'Select'] + $each['data']['values'], $each['selected'], ['class' => 'form-control singleselect margin_right']) !!}
                                @endif
                            </div>
                        </div>
                    @endforeach


                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Reports To (Level)</div>
                        <div class="col-md-3">
                            {!! Form::select('report_to_level', $levels, $report_to_level_id, ['id' => 'report_to_level', 'class' => 'form-control singleselect']) !!}
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Reports To</div>
                        <div class="col-md-3">
                            {!! Form::select('report_to_user_id', ['' => 'Select'] + $report_to_users, $organization->report_to_user_id, ['class' => 'form-control singleselect']) !!}
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        {!! Form::submit(trans("content.save"), [ 'name' => 'save', 'class' => 'btn btn-warning']) !!}
                        <a href="{{ route("homepage")."#". url('organization').'?structure_department_id='.$departmentId }}" class="btn btn-default">@lang("content.back")</a>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>

        </article>

    </div>

</section>






<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("{{ asset('/assets/js/views/organization/edit.js') }}", pagefunction);


</script>
