<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */
?>



<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Organization', 'moduleName' => 'Map Employee'])

            <div class="ajax_info_container"></div>

            <div class="ajax_main_container">

                {!! Form::open(['method' => 'POST', 'class' => 'form-horizontal', 'url' =>  url('organization')]) !!}

                <div style="min-width: 800px; width: 70%">

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">@lang("content.department")</div>
                        <div class="col-md-3">
                            {!! Form::select('structure_department_id', $departments, $departmentId, ['id' => 'structure_department_id', 'class' => 'form-control singleselect', 'required' => 'required']) !!}
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Employee</div>
                        <div class="col-md-3">
                            {!! Form::select('user_id', $users, null, ['class' => 'form-control multiselect_search', 'required' => 'required']) !!}
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Add New Employee</div>
                        <div class="col-md-1 list" id="new_user" style="display: inline; padding-top: 0 !important;">
                            {!! Form::checkbox('new_user', null, false, ['class' => 'form-control input-sm', 'style' => 'margin:0; width: 20px;']) !!}
                        </div>
                        <a style="display: inline;"><h5>Go To Page</h5></a>
                    </div>

                    <div class="col-lg-12 list-header" style="display: none">
                        <div class="form-group has-feedback col-md-7">
                            <label class="control-label col-sm-2">@lang("content.first_name")</label>
                            <div class="col-sm-9">
                                {!! Form::text('first_name',null, ['class'=>'form-control', 'placeholder'=>'First Name', 'id'=>'first_name' , 'data-required']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>
                        <div class="form-group has-feedback col-md-7">
                            <label class="control-label col-sm-2">@lang("content.last_name")</label>
                            <div class="col-sm-9">
                                {!! Form::text('last_name', null, ['class'=>'form-control', 'placeholder'=>'Last Name', 'id'=>'last_name' , 'data-required']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>
                        <div class="form-group has-feedback col-md-7">
                            <label class="control-label col-sm-2">@lang("content.email")</label>
                            <div class="col-sm-9">
                                {!! Form::text('email', null, ['class'=>'form-control', 'placeholder'=>'Email', 'id'=>'email']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Add New Position</div>
                        <div class="col-md-1 list" id="new_position" style="display: inline; padding-top: 0 !important;">
                            {!! Form::checkbox('new_position', null, false, ['class' => 'form-control input-sm', 'style' => 'margin:0; width: 20px; ']) !!}
                        </div>
                        <a style="display: inline;"><h5>Go To Page</h5></a>
                    </div>

                    <div class="col-lg-12 list-header" style="display: none">
                        <div class="form-group has-feedback col-md-7">
                            <label class="control-label col-sm-2">@lang("content.position")</label>
                            <div class="col-sm-9">
                                {!! Form::text('new_position', null, ['class' => 'form-control', 'data-required']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Reports To CEO</div>
                        <div class="col-md-1 list" style="display: inline; padding-top: 0 !important;">
                            {!! Form::checkbox('reports_to_ceo', 1, false, ['class' => 'form-control input-sm', 'style' => 'margin:0; width: 20px; ']) !!}
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">@lang("content.designation")</div>
                        <div class="col-md-3">
                            <label class="margin_right_10">
                            {!! Form::radio('support_staff', 0, null, ['class' => 'form-control', 'required' => 'required']) !!}
                                Accountable</label>
                            <label>
                            {!! Form::radio('support_staff', 1, null, ['class' => 'form-control', 'required' => 'required']) !!}
                                Support</label>
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        {!! Form::submit('Insert', [ 'name' => 'insert', 'class' => 'btn btn-warning']) !!}
                        <a href="{{ route("homepage")."#". url('organization')."?structure_department_id={$departmentId}"  }}" class="btn btn-default">@lang("content.back")</a>
                    </div>
                </div>

                {!! Form::close() !!}
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("{{ asset('/assets/js/views/organization/create.js') }}", pagefunction);


</script>


