

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Organization', 'moduleName' => 'Chart'])

            <?php
                foreach($organization as $i => $each) {
                    $bgColor = $each->organizationLevel ? $each->organizationLevel->bg_color : '#ffad99';
                    $user = $each->user;
                    $picture = $user->picture ? $user->picture : 'profile.png';

                    $data[] = [
                        'id'                => $each->user_id,
                        'parent'            => $each->report_to_user_id,
                        'description'       => ($each->position ? $each->position->name : ''),
                        'email'             => $each->email,
                        'groupTitleColor'   => $bgColor,
                        'image'             => $picture,
                        'itemTitleColor'    => $bgColor,
                        'phone'             => $each->phone,
                        'title'             => $user->first_name." ".$user->last_name,
                        'label'             => $user->first_name." ".$user->last_name
                    ];

                    $bgColor = $each->organizationLevel ? $each->organizationLevel->bg_color : '#ffad99';
                    $user = $each->user;
                    $picture = $user->picture ? $user->picture : 'profile.png';

                    $element = "<div class='organization_chart' onclick='location.href=".'"'.route("homepage")."#". url('organization/chart').'/'.$each->id.'"'."' style='background-color:{$bgColor}'>".
                                "<div style='width: 30%'>".
                                    "<img style='background-color:#FFFFFF; width:100%' src='". asset('/storage/users/'.$picture)."' />".
                                    "</div>".
                                "<div style='width: 70%; padding-left: 5px; '>".
                                    "<h6>".$user->first_name." ".$user->last_name."</h6>".
                                    "<h6>".($each->position ? $each->position->name : '')."</h6>".
                                "</div>".
                            "</div>";

                    $employee = [
                        [
                            'v' => "$each->user_id",
                            'f' => $element
                        ]
                    ];
                    $employee[] = ($i == 0 && isset($personal) && $personal) ? '' : "$each->report_to_user_id";
                    $employee[] = "";
                    $all_staff[] = $employee;
                }
            ?>

            {{--Total Chart--}}
            @if (isset($organizationNotAssigned))
                <div class="tabbable">
                    {{--Tabs--}}
                    <ul class="nav nav-pills" id="myTab">
                        <li class="active"><a href="#assigned" data-toggle="tab">Assigned</a></li>
                        <li><a href="#not_assigned" data-toggle="tab">Not Assigned</a></li>
                    </ul>

                    {{--Tab Content--}}
                    <div class="tab-content">
                        {{--Assigned Tab--}}
                        <div class="tab-pane active" id="assigned">
                            <div id="assigned_employees" style="overflow: auto; min-height: 600px"></div>
                        </div>
                        {{--Not Assigned Tab--}}
                        <div class="tab-pane" id="not_assigned">
                            @include('organization/layouts/not-assigned-chart', ['data' => $organizationNotAssigned])
                        </div>
                        {{--Settings Tab--}}
                        {{--<div class="tab-pane" id="settings">
                            Coming Soon...
                        </div>--}}
                    </div>
                </div>
            @else
                {{--Individual Chart--}}
                <div class="col-lg-12" id="assigned_employees" ></div>
            @endif


        </article>

    </div>

</section>



<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

        google.load("visualization", "1", {packages: ["orgchart"]});
        google.setOnLoadCallback(function () {
            drawChart({!! json_encode($all_staff) !!}, 'assigned_employees');
        });

    };

    loadScript("https://www.google.com/jsapi", function(){
        loadScript("{{ asset('/assets/js/views/organization/chart.js') }}", pagefunction);
    });

</script>

