<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */
?>





<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Organization', 'moduleName' => 'Edit Level'])

            <div class="ajax_info_container"></div>

            <div class="ajax_main_container">

                {!! Form::open(['method' => 'POST', 'class' => 'form-inline', 'url' => url('organization-level/'.$organizationLevel->id)]) !!}

                <div style="min-width: 800px; width: 70%">
                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Level</div>
                        <div class="col-md-3">
                            {!! Form::hidden('structure_department_id', $departmentId) !!}
                            {!! Form::input('number', 'level', $organizationLevel->level, ['class' => 'form-control inputSmall margin_right', 'min' => 1, 'required' => 'required']) !!}
                        </div>
                    </div>
                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">@lang("content.name")</div>
                        <div class="col-md-3">
                            {!! Form::text('name', $organizationLevel->name, ['class' => 'form-control margin_right',  'placeholder' => "Name of the Level", 'required' => 'required']) !!}
                        </div>
                    </div>
                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Max No.</div>
                        <div class="col-md-3">
                            {!! Form::input('number', 'qty', $organizationLevel->qty, ['class' => 'form-control inputSmall margin_right', 'min' => 1]) !!}
                        </div>
                    </div>
                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Related Table</div>
                        <div class="col-md-3">
                            {!! Form::select('related_tables[]', $related_tables, $selected_tables, ['multiple' => 'multiple', 'class' => 'multiselect form-control margin_right']) !!}
                        </div>
                    </div>
                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Multiple Selection</div>
                        <div class="col-md-3">
                            {!! Form::checkbox('multiple_selection', 1, $organizationLevel->multiple_selection, ['class' => 'form-control']) !!}
                        </div>
                    </div>
                    <div class="col-lg-12 list-header">
                        <div class="col-md-3 list">Support Staff</div>
                        <div class="col-md-3">
                            {!! Form::checkbox('support_staff', 1, $organizationLevel->support_staff, ['class' => 'form-control']) !!}
                        </div>
                    </div>

                    <div class="col-lg-12 list-header">
                        {!! Form::submit(trans("content.save"), [ 'name' => 'save', 'class' => 'btn btn-warning']) !!}
                    </div>
                </div>
                {!! Form::close() !!}
            </div>


        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    pagefunction();


</script>
