<?php require_once(public_path("smart/inc/init.php")); ?>
        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            @include("operation-reports.layouts.pts-report-form", ['enableAirline' => true, 'enableAirport' => true, 'enablePeriod' => true])
            <div class="clearfix"></div>
        </article>

        <article class="col-sm-12 col-md-12 col-lg-12">
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-license" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                    <h2>@lang("content.list")</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding" style="min-height: 50px !important;">

                        <div class="table-responsive">

                            <table class="table table-bordered table-hover" border="1">
                                <thead>
                                <tr>
                                    {{--<th>No</th>--}}
                                    <th style="min-width: 60px !important;">@lang("content.date")</th>
                                    <th>@lang("content.station")</th>

                                    <th style="min-width: 50px !important;">DEP<br>FLT No</th>
                                    <th>TO</th>
                                    <th>STD</th>
                                    <th style="min-width: 50px !important;">ARR<br>FLT No</th>
                                    <th>FROM</th>
                                    <th style="min-width: 100px !important;">STA</th>

                                    <th style="min-width: 50px !important;">A/C Reg</th>
                                    <th>A/C Type</th>
                                    <th>ATA</th>
                                    <th>ATD</th>

                                    <th>DL Code</th>
                                    <th>DL Time</th>

                                    <th>JETWAY/STEPS</th>
                                    <th>JETWAY ON</th>
                                    <th>FIRST PAX OFF</th>
                                    <th>LAST PAX OFF</th>
                                    <th>CLEANERS ON BOARD</th>
                                    <th>FUELLING STARTED</th>
                                    <th>PRE-BOARDING STARTED</th>
                                    <th>CLEANERS OFF</th>
                                    <th>PILOT HEADSET</th>
                                    <th>BOARD PAX</th>
                                    <th>ALL PAX ON BOARD</th>
                                    <th>GATEBAGS COLLECTED BY LOADING TEAM</th>
                                    <th>LOADSHEET ONBOARD</th>
                                    <th>ALL DOORS CLOSED</th>
                                    <th>TUG CONNECTED</th>
                                    <th>JETWAY OFF</th>
                                    <th>PUSHBACK</th>
                                    <th>FINAL WALK AROUND</th>
                                    <th>ALL DOORS & PANELS ARE CLOSED</th>
                                    <th>BACK STEPS USED</th>
                                    <th>CABIN BAGS AT CHECK-IN</th>
                                    <th>CABIN BAGS AT GATE</th>
                                    <th>CKIN OPEN</th>
                                    <th>CKIN CLOSE</th>
                                    <th>MHB AHL</th>
                                    <th>MHB OHD</th>
                                    <th>MHB DPR</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($flights as $k => $flight)

                                    @php $depFn = $depAp = $arrAp = $depAC = null @endphp

                                    <tr>
                                        @php $depAp = getFlightDepartureAirport($flight, false, true) @endphp
                                        @php $arrAp = getFlightArrivalAirport($flight, false, true) @endphp
                                        @php $depSTD = $flight->std && $flight->std != EMPTY_DATETIME ? baseDateFormat($flight->std, true) : null @endphp
                                        @php $depSTDDate = $depSTD ? date("Y-m-d", strtotime($depSTD)) : null @endphp

                                        @php $depFn = getFlightNumberFull($flight->flightNumber) @endphp
                                        @php $depAC = getFlightAircraft($flight) @endphp
                                        @php $depACType = getFlightAircraftType($flight) @endphp

                                        @php $arrFlight = $flight->flightParent @endphp
                                        @php $arrFN = $arrFlight ? getFlightNumberFull($arrFlight->flightNumber) : null @endphp
                                        @php $arrDepAp = $arrFlight ? getFlightDepartureAirport($arrFlight, false, true) : null @endphp
                                        @php $arrSTA = $arrFlight && $arrFlight->sta && $arrFlight->sta != EMPTY_DATETIME ? baseDateFormat($arrFlight->sta, true) : null @endphp
                                        @php $arrSTADate = $arrSTA ? date("Y-m-d", strtotime($arrSTA)) : null @endphp

                                        <td>{{ getFlightDepartureInitialDate($flight, true)}}</td>

                                        {{--Departure Flight--}}
                                        <td>{{ $depAp }}</td>
                                        <td>{{ $depFn }}</td>
                                        <td>{{ $arrAp }}</td>
                                        <td>{{ baseTimeFormat($depSTD) }}</td>

                                        {{--Arrival Flight--}}
                                        <td>{{ $arrFN }}</td>
                                        <td>{{ $arrDepAp }}</td>
                                        <td>{{ ($depSTDDate != $arrSTADate ? $arrSTADate." " : ""). baseTimeFormat($arrSTA) }}</td>

                                        <td>{{ $depAC }}</td>
                                        <td>{{ $depACType }}</td>

                                        {{--Arrival flight ATA--}}
                                        <td>{{ $arrFlight && $arrFlight->ata && $arrFlight->ata != EMPTY_DATETIME ? baseTimeFormat($arrFlight->ata) : "" }}</td>

                                        {{--Departure flight ATD--}}
                                        <td>{{ $flight->atd && $flight->atd != EMPTY_DATETIME ? baseTimeFormat($flight->atd) : "" }}</td>

                                        {{--DELAYS OUT--}}
                                        @php list($codes, $times) = getFlightDelays($flight) @endphp
                                        @if (count($codes))
                                            <td class="color-red">DL {{ implode("/", $codes) }}</td>
                                            <td class="color-red">{{ implode("/", $times) }}</td>
                                        @else
                                            <td></td>
                                            <td></td>
                                        @endif

                                        <td data-center>{{ $flight->jetway_steps }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->jetway_on) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->first_pax_off) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->last_pax_off) }}</td>

                                        <td data-center>{{ baseTimeFormat($flight->cleaners_onboard) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->fuelling_started) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->pre_boarding_started) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->cleaners_off) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->pilot_headset) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->board_pax) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->all_pax_onboard) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->gatebags_collected) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->loadsheet_onboard) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->all_doors_closed) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->tug_connected) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->jetway_off) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->pushback) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->final_walk_around) }}</td>
                                        <td data-center="">{{ $flight->all_doors_panels_closed }}</td>
                                        <td data-center>{!! $flight->back_steps_used ? '<i class="fa fa-check"></i>' : "" !!} </td>
                                        <td data-right>{{ $flight->cabin_bags_checkin }}</td>
                                        <td data-right>{{ $flight->cabin_bags_gate }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->ckin_open) }}</td>
                                        <td data-center>{{ baseTimeFormat($flight->ckin_close) }}</td>
                                        <td data-right>{{ $flight->mhb_ahl }}</td>
                                        <td data-right>{{ $flight->mhb_ohd }}</td>
                                        <td data-right>{{ $flight->mhb_dpr }}</td>
                                    </tr>
                                @endforeach
                                </tbody>

                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        @if (ghaModule())
            ApplyOperationsFormFilter({!! json_encode($flightNumbers) !!}, {!! json_encode(\request("flightNumber")) !!}, {!! json_encode($sectors) !!}, {!! json_encode($sectorsByAirlines) !!}, {!! json_encode(\request("sector")) !!});
        @endif

        ApplyTableFilter(".table", false, [[ 0, "asc" ], [ 4, "asc" ]]);

    };

    pagefunction();

</script>
