<?php require_once(public_path("smart/inc/init.php")); ?>
        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            <div>
                {!! Form::open(['class' => 'form-inline', 'method' => 'GET', 'id' => 'formOPS']) !!}
                    <div class="form-group marginBottomRight">
                        <label>@lang("content.airline")</label>
                        <div class="btn-group">
                            {!! Form::select('airline[]', $airlines, \request("airline"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
                        </div>
                    </div>

                    <div class="form-group marginBottomRight">
                        <label>@lang("content.airport")</label>
                        <div class="btn-group">
                            {!! Form::select('airport[]', $airports, \request("airport"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']) !!}
                        </div>
                    </div>

                    <div class="form-group marginBottomRight">
                        <label>@lang("content.from")</label>
                        {!! Form::text('dateFrom', $dateFrom, ['class'=>'form-control dateFrom myinput', 'placeholder'=>'From Date', 'id'=>'from_date']) !!}
                        <label for="dateTo">@lang("content.to")</label>
                        {!! Form::text('dateTo', $dateTo, ['class'=>'form-control dateTo myinput', 'placeholder' => 'To Date', 'id'=>'to_date']) !!}
                    </div>

                    <div class="form-group marginBottomRight">
                        <div class="smart-form col-sm-12 no-padding" style="display: inline-block">
                            <section>
                                <label class="col-md-12" id="add_details_layout">
                                    <div class="inline-group">
                                        <label class="checkbox margin-right-20">
                                            <input type="checkbox" value="1" name="ssr" {!! \request("ssr") ? "checked" : "" !!} >
                                            <i></i> <span style="margin-left: 10px;">Include SSR</span></label>
                                    </div>
                                </label>
                            </section>

                        </div>

                    </div>


                    <div class="form-group marginBottomRight">
                        <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
                    </div>
                {!! Form::close() !!}
            </div>
            <div class="clearfix"></div>
        </article>

        <article class="col-sm-12 col-md-12 col-lg-12">
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-license" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                    <h2>@lang("content.list")</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding" style="min-height: 50px !important;">

                        <div class="table-responsive">

                            <table class="table table-bordered table-hover" border="1">
                                <thead>
                                <tr>
                                    {{--<th>No</th>--}}
                                    <th rowspan="3" style="min-width: 60px !important;">@lang("content.date")</th>
                                    <th rowspan="3">@lang("content.station")</th>

                                    <th rowspan="3" style="min-width: 50px !important;">DEP<br>FLT No</th>
                                    <th rowspan="3">TO</th>
                                    <th rowspan="3" style="">STD</th>
                                    <th rowspan="3" style="min-width: 50px !important;">ARR<br>FLT No</th>
                                    <th rowspan="3">FROM</th>
                                    <th rowspan="3" style="min-width: 100px !important;">STA</th>

                                    <th rowspan="3" style="min-width: 50px !important;">A/C Reg</th>
                                    <th rowspan="3" style="">A/C Type</th>
                                    <th rowspan="3" style="">ATA</th>
                                    <th rowspan="3" style="">ATD</th>

                                    <th rowspan="2" colspan="2">DL Code</th>

                                    <th rowspan="2" colspan="4">PAX</th>

                                    <th colspan="4">Baggage</th>
                                    <th colspan="4">Cargo</th>

                                    <th rowspan="3">Counters</th>

                                    @foreach($ssrList as $ssr)
                                        <th rowspan="2" colspan="2">{{ $ssr }}</th>
                                    @endforeach
                                </tr>
                                <tr>
                                    <th colspan="2">IN</th>
                                    <th colspan="2">OUT</th>

                                    <th colspan="2">IN</th>
                                    <th colspan="2">OUT</th>
                                </tr>
                                <tr>
                                    <th>Code</th>
                                    <th>Time</th>

                                    <th>IN</th>
                                    <th>INF</th>
                                    <th>OUT</th>
                                    <th>INF</th>

{{--                                    Baggage--}}
                                    <th>PCs</th>
                                    <th>Wt</th>
                                    <th>PCs</th>
                                    <th>Wt</th>
{{--                                    Cargo--}}
                                    <th>PCs</th>
                                    <th>Wt</th>
                                    <th>PCs</th>
                                    <th>Wt</th>

                                    @foreach($ssrList as $ssr)
                                        <th>IN</th>
                                        <th>OUT</th>
                                    @endforeach
                                </tr>

                                </thead>
                                <tbody>

                                    @include("operation-reports.layouts.flights-tbody")

                                </tbody>

                            </table>

                        </div>

                    </div>

                </div>

            </div>
        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table", false, [[ 0, "asc" ], [ 2, "asc" ]]);
    };

    pagefunction();

</script>
