<div>
    {!! Form::open(['class' => 'form-inline', 'method' => 'GET', 'id' => 'formOPS']) !!}
    <div class="row">
        <div class="col-md-12">
            <div class="form-group marginBottomRight">
                <label>@lang("content.airline")</label>
                <div class="btn-group">
                    {!! Form::select('airline',  $airlines, \request()->get('airline'), ['class'=>'singleselect_search', 'id'=>'airline', 'required']) !!}
                </div>
            </div>

            <div class="form-group marginBottomRight">
                <label>@lang("content.airport")</label>
                <div class="btn-group">
                    {!! Form::select('airport[]', $airports, \request()->get('airport'), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']) !!}
                </div>
            </div>
        </div>
    </div>

    @php $fromToSelected = !\request()->has('dateSearch') || \request()->get('dateSearch') == 'fromTo' @endphp
    <div class="row">
        <div class="col-md-12">
            <div class="form-group marginBottomRight">
                <label>{!! Form::radio('dateSearch','fromTo', $fromToSelected) !!} @lang("content.from")</label>
                {!! Form::text('dateFrom', $fromToSelected ? $dateFrom : $dateYesterday, ['class'=>'form-control dateFrom myinput', 'placeholder'=>'From Date', 'id'=>'from_date']) !!}
                <label form="dateTo">@lang("content.to")</label>
                {!! Form::text('dateTo', $fromToSelected ? $dateTo : $dateYesterday, ['class'=>'form-control dateTo myinput', 'placeholder' => 'To Date', 'id'=>'to_date']) !!}
            </div>

            <div class="form-group marginBottomRight">
                <label>{!! Form::radio('dateSearch','monthYear', \request()->get('dateSearch') == 'monthYear') !!}
                    Period
                </label>
                <div class="btn-group">
                    {!! Form::select('bi_month', $biMonths, \request()->get('bi_month'), ['class'=>'singleselect', 'id'=>'bi_month']) !!}
                </div>
            </div>
            <div class="form-group marginBottomRight">
                <label for="month" class="control-label">@lang("content.month")</label>
                <div class="btn-group">
                    {!! Form::select('month', $monthNames, $currentMonth, ['class'=>'singleselect', 'id'=>'month']) !!}
                </div>
            </div>

            <div class="form-group marginBottomRight">
                <label for="year" class="control-label">@lang("content.year")</label>
                <div class="btn-group">
                    {!! Form::select('year', $years, getSelectedYear(), ['class'=>'singleselect', 'id'=>'period']) !!}
                </div>
            </div>

            <div class="form-group marginBottomRight">
                {{ Form::hidden("form", 1) }}
                <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
            </div>
        </div>
    </div>
    {!! Form::close() !!}
</div>
