<table class="table table-bordered table-hover" border="1">
    <thead>
    <tr>
        {{--<th>No</th>--}}
        <th rowspan="2" style="min-width: 60px !important;">@lang("content.date")</th>
        <th rowspan="2">@lang("content.station")</th>

        <th rowspan="2" style="min-width: 50px !important;">Flight</th>
        <th rowspan="2" style="min-width: 70px !important;">A/C Reg</th>
        <th rowspan="2" style="">A/C Type</th>
        <th rowspan="2" style="min-width: 50px !important;">I/B FLT No.</th>
        <th rowspan="2" style="">ATA</th>
        <th rowspan="2" style="">ATD</th>
        <th colspan="3">Delay / Reason</th>
        <th colspan="4">PAX</th>
        @foreach($ssrList as $ssr)
            <th colspan="2">{{ $ssr }}</th>
        @endforeach

        <th rowspan="2">No. Of CKIN<br>Counters</th>
        <th rowspan="2">No. of Staff</th>

        {{--<th rowspan="2">Add.<br>Counter</th>--}}
        {{--<th rowspan="2">TO</th>--}}
        {{--<th rowspan="2" style="">STD</th>--}}
        {{--<th rowspan="2" style="min-width: 50px !important;">ARR<br>FLT No</th>--}}
        {{--<th rowspan="2">FROM</th>--}}
        {{--<th rowspan="2" style="min-width: 100px !important;">STA</th>--}}
    </tr>
    <tr>
        <th>Delay</th>
        <th>Minutes</th>
        <th>Ind.Min</th>

        <th>IN</th>
        <th>INF</th>
        <th>OUT</th>
        <th>INF</th>

        @foreach($ssrList as $ssr)
            <th>IN</th>
            <th>OUT</th>
        @endforeach
    </tr>

    </thead>

    <tbody>

    @php $paxIn = $paxInInf = $paxOut = $paxOutInf = $delayTotal = 0 @endphp
    @php $totalFlights = 0 @endphp
    @php $ssrTotalsDep = $ssrTotalsArr = [] @endphp

    @foreach ($flights as $k => $items)
        {{--        @foreach ($flights->lines as $k => $line)--}}

        {{--            @php $items = $line->getFlights() @endphp --}}
        @php $depFlight = $depFn = $depAp = $arrAp = $depAC = null @endphp
        @php $in = $inInf = $out = $outInf = $dlTotal = 0 @endphp

        @if (count($items) == 2)
            @php $depFlight = $items[0] @endphp
            @php $depAp = getFlightDepartureAirport($depFlight, false, true) @endphp
            @php $arrAp = getFlightArrivalAirport($depFlight, false, true) @endphp
            @php $depSTD = $depFlight->std && $depFlight->std != EMPTY_DATETIME ? baseDateFormat($depFlight->std, true) : null @endphp
            @php $depSTDDate = $depSTD ? date("Y-m-d", strtotime($depSTD)) : null @endphp

            @php $depFn = getFlightNumberFull($depFlight->flightNumber) @endphp
            @php $depAC = getFlightAircraft($depFlight) @endphp
            @php $depACType = getFlightAircraftType($depFlight) @endphp

            @php $arrFlight = $items[1] @endphp
            @php $arrFN = getFlightNumberFull($arrFlight->flightNumber) @endphp
            @php $arrDepAp = getFlightDepartureAirport($arrFlight, false, true) @endphp
            @php $arrSTA = $arrFlight->sta && $arrFlight->sta != EMPTY_DATETIME ? baseDateFormat($arrFlight->sta, true) : null @endphp
            @php $arrSTADate = $arrSTA ? date("Y-m-d", strtotime($arrSTA)) : null @endphp
            <tr>
                <td>{{ getFlightDepartureInitialDate($depFlight, true)}}</td>
                {{--Departure Flight--}}
                <td>{{ $depAp }}</td>
                <td>{{ $depFn }}</td>

                @if ($depFlight->cancelled_at)
                    <td class="bg-danger text-right" style="border-right: 0 !important;">Cancelled at</td>
                    <td class="bg-danger" style="border-right: 0 !important;">{{ $depFlight->cancellation_received_at ? baseDateFormat($depFlight->cancellation_received_at, true) : "UNKNOWN" }}</td>
                    <td class="bg-danger" style="border-right: 0 !important;">
                    </td>
                    <td class="bg-danger" style="border-right: 0 !important;">
                        @if ($depFlight->remark)
                            ({{ $depFlight->remark }})
                        @endif
                    </td>
                    <td class="bg-danger"></td>
                @else
                    <td>{{ $depAC }}</td>
                    {{--                        <td>{{ $depFlight->parent_id }}</td>--}}
                    <td>{{ $depACType }}</td>

                    {{--Arrival flight ATA--}}
                    <td>{{ $arrFN }}</td>
                    <td>{{ $arrFlight->ata && $arrFlight->ata != EMPTY_DATETIME ? baseTimeFormat($arrFlight->ata) : "" }}</td>

                    {{--Departure flight ATD--}}
                    <td>{{ $depFlight->atd && $depFlight->atd != EMPTY_DATETIME ? baseTimeFormat($depFlight->atd) : "" }}</td>
                @endif

                {{--DELAYS OUT--}}
                @php list($codes, $times, $dlTotal) = getFlightDelays($depFlight) @endphp
                @if (count($codes))
                    <td class="color-red">DL {{ implode("/", $codes) }}</td>
                    <td class="color-red">{{ implode("/", $times) }}</td>
                    <td>{{ $dlTotal }}</td>
                @else
                    <td></td>
                    <td></td>
                    <td></td>
                @endif

                {{--- PAX IN---}}
                <td>{{ $in = getFlightPaxTotal($arrFlight, true) }}</td>
                <td>{{ $inInf = $arrFlight->pax_inf_actual }}</td>

                {{--- PAX OUT---}}
                <td>{{ $out = getFlightPaxTotal($depFlight, true) }}</td>
                <td>{{ $outInf = $depFlight->pax_inf_actual }}</td>


                {{--            <td>{{ $arrAp }}</td>--}}
                {{--            <td>{{ baseTimeFormat($depSTD) }}</td>--}}

                {{--Arrival Flight--}}
                {{--            <td>{{ $arrFN }}</td>--}}
                {{--            <td>{{ $arrDepAp }}</td>--}}
                {{--            <td>{{ ($depSTDDate != $arrSTADate ? $arrSTADate." " : ""). baseTimeFormat($arrSTA) }}</td>--}}

                {{--SSR--}}
                @foreach($ssrList as $ssr)
                    {{--IN--}}
                    @if ($arrFlight->ssr_ready && isset($arrFlight->ssr_ready[$ssr]))
                        @php $s = $arrFlight->ssr_ready[$ssr] @endphp
                        <td>{{ $s }}</td>

                        @if (!isset($ssrTotalsArr[$ssr]))
                            @php $ssrTotalsArr[$ssr] = 0 @endphp
                        @endif

                        @php $ssrTotalsArr[$ssr] += $s @endphp
                    @else
                        <td></td>
                    @endif

                    {{--OUT--}}
                    @if ($depFlight->ssr_ready && isset($depFlight->ssr_ready[$ssr]))
                        @php $s = $depFlight->ssr_ready[$ssr] @endphp

                        <td>{{ $s }}</td>

                        @if (!isset($ssrTotalsDep[$ssr]))
                            @php $ssrTotalsDep[$ssr] = 0 @endphp
                        @endif

                        @php $ssrTotalsDep[$ssr] += $s @endphp
                    @else
                        <td></td>
                    @endif
                @endforeach

                {{--Counters--}}
                <td>
                    @if ($depFlight->ckin_num)
                        {{ $depFlight->ckin_num }}
                    @endif

                    @if ($arrFlight->ckin_num)
                        / {{ $arrFlight->ckin_num }}
                    @endif
                </td>

                <td>{{ $depFlight->sla }}</td>
            </tr>

            @php $totalFlights++ @endphp
        @else

            @php $flight = $items[0] @endphp
            @php $fn = getFlightNumberFull($flight->flightNumber) @endphp
            @if ($flight->type == DEPARTURE)

                @php $ac = getFlightAircraft($flight) @endphp
                @php $acType = getFlightAircraftType($flight) @endphp
                @php $depAp = getFlightDepartureAirport($flight, false, true) @endphp
                @php $arrAp = getFlightArrivalAirport($flight, false, true) @endphp
                <tr>
                    {{--<td>{{ $k + 1 }}</td>--}}
                    <td>{{ getFlightDepartureInitialDate($flight, true) }}</td>

                    {{--Departure Flight--}}
                    <td>{{ $depAp }}</td>
                    <td>{{ $fn }}</td>
                    {{--                <td>{{ $arrAp }}</td>--}}
                    @if ($flight->cancelled_at)
                        <td class="bg-danger text-right" style="border-right: 0 !important;">Cancelled at</td>
                        <td class="bg-danger" style="border-right: 0 !important;">{{ $flight->cancellation_received_at ? baseDateFormat($flight->cancellation_received_at, true) : "UNKNOWN" }}</td>
                        <td class="bg-danger" style="border-right: 0 !important;"></td>
                        <td class="bg-danger" style="border-right: 0 !important;">
                            @if ($flight->remark)
                                ({{ $flight->remark }})
                            @endif
                        </td>
                        <td class="bg-danger"></td>
                    @else
                        <td>{{ $ac }}</td>
                        <td>{{ $acType }}</td>
                        {{--                        <td>| {{ $flight->parent_id }}</td>--}}
                        {{--Arrival flight ATA--}}
                        <td></td>
                        <td></td>
                        {{--Departure flight ATD--}}
                        <td>{{ $flight->atd && $flight->atd != EMPTY_DATETIME ? baseTimeFormat($flight->atd) : "" }}</td>
                    @endif
                    {{--Departure Flight--}}
                    {{--                <td>{{ $flight->std && $flight->std != EMPTY_DATETIME ? baseTimeFormat($flight->std) : "" }}</td>--}}

                    @php list($codes, $times, $dlTotal) = getFlightDelays($flight) @endphp
                    @if (count($codes))
                        <td class="color-red">DL {{ implode("/", $codes) }}</td>
                        <td class="color-red">{{ implode("/", $times) }}</td>
                        <td>{{ $dlTotal }}</td>
                    @else
                        <td></td>
                        <td></td>
                        <td></td>
                    @endif

                    {{--- PAX IN---}}
                    <td></td>
                    <td></td>

                    {{--- PAX OUT---}}
                    <td>{{ $out = getFlightPaxTotal($flight, true) }}</td>
                    <td>{{ $outInf = $flight->pax_inf_actual }}</td>


                    @foreach($ssrList as $ssr)
                        {{--IN--}}
                        <td></td>

                        {{--OUT--}}
                        @if ($flight->ssr_ready && isset($flight->ssr_ready[$ssr]))
                            @php $s = $flight->ssr_ready[$ssr] @endphp

                            <td>{{ $s }}</td>

                            @if (!isset($ssrTotalsDep[$ssr]))
                                @php $ssrTotalsDep[$ssr] = 0 @endphp
                            @endif

                            @php $ssrTotalsDep[$ssr] += $s @endphp
                        @else
                            <td></td>
                        @endif
                    @endforeach

                    {{--Counters--}}
                    <td>{{ $flight->ckin_num }}</td>
                    <td style="min-width: 200px;">{{ $flight->sla }}</td>

                </tr>

                @php $totalFlights++ @endphp
            @else
                {{--            {{ debug("unmatched flight: {$fn} ". getFlightArrivalInitialDate($flight)) }}--}}
            @endif
        @endif

        @php $paxIn += ($in ? $in : 0) @endphp
        @php $paxInInf += ($inInf ? $inInf : 0) @endphp
        @php $paxOut += ($out ? $out : 0) @endphp
        @php $paxOutInf += ($outInf ? $outInf : 0) @endphp
        @php $delayTotal += ($dlTotal ? $dlTotal : 0) @endphp

    @endforeach
    <tr>
        <td><strong>FLIGHTS</strong></td>
        <td><strong>{{ $totalFlights }}</strong></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td><strong>DELAY</strong></td>
        <td><strong>{{ $delayTotal }}</strong></td>

        <td class=""><strong>{{ $paxIn }}</strong></td>
        <td class=""><strong>{{ $paxInInf }}</strong></td>
        <td class=""><strong>{{ $paxOut }}</strong></td>
        <td class=""><strong>{{ $paxOutInf }}</strong></td>

        @foreach($ssrList as $ssr)
            <td><strong>{{ isset($ssrTotalsArr[$ssr]) ? $ssrTotalsArr[$ssr] : "" }}</strong></td>
            <td><strong>{{ isset($ssrTotalsDep[$ssr]) ? $ssrTotalsDep[$ssr] : "" }}</strong></td>
        @endforeach

        <td></td>
        <td></td>

    </tr>

    </tbody>

</table>
