<table class="table table-bordered table-hover" border="1" id="financeReport">
    <thead>
    <tr>
        {{--<th>No</th>--}}
        <th rowspan="2" style="min-width: 60px !important;">@lang("content.date")</th>
        <th rowspan="2">@lang("content.station")</th>

        <th rowspan="2" style="min-width: 50px !important;">Flight</th>
        <th rowspan="2" style="min-width: 70px !important;">A/C Reg</th>
        <th rowspan="2" style="">A/C Type</th>
        <th rowspan="2" style="min-width: 50px !important;">I/B FLT No.</th>
        <th rowspan="2" style="">Origin</th>
        <th rowspan="2" style="">STA</th>
        <th rowspan="2" style="">ATA</th>

        <th rowspan="2" style="min-width: 70px;">Late ARR - MINs</th>
        <th rowspan="2" style="">Destination</th>
        <th rowspan="2" style="">STD</th>

        <th rowspan="2" style="">ATD</th>
        <th colspan="4">Delay / Reason</th>
        <th colspan="6">PAX</th>
        @foreach($ssrList as $ssr)
            <th colspan="2">{{ $ssr }}</th>
        @endforeach

        <th rowspan="2">No. Of CKIN<br>Counters</th>

        <th colspan="3">Cancelled</th>

        <th rowspan="2" style="min-width: 130px;">No. of Staff</th>
        <th rowspan="2" style="min-width: 150px;">Notes</th>

        {{--<th rowspan="2">Add.<br>Counter</th>--}}
        {{--<th rowspan="2">TO</th>--}}
        {{--<th rowspan="2" style="">STD</th>--}}
        {{--<th rowspan="2" style="min-width: 50px !important;">ARR<br>FLT No</th>--}}
        {{--<th rowspan="2">FROM</th>--}}
        {{--<th rowspan="2" style="min-width: 100px !important;">STA</th>--}}
    </tr>
    <tr>
        <th style="width: 80px">DL Code</th>
        <th style="width: 150px">Minutes</th>
        <th style="width: 70px">Total Delay MINs</th>
        <th>Ind.Min</th>

        <th>IN</th>
        <th>INF</th>
        <th class="color-blue">TRA</th>
        <th class="color-blue">INF</th>
        <th>OUT</th>
        <th>INF</th>

        @foreach($ssrList as $ssr)
            <th>IN</th>
            <th>OUT</th>
        @endforeach

        <th style="min-width: 80px">Date</th>
        <th style="min-width: 80px">Time</th>
        <th style="min-width: 180px;">Reason</th>
    </tr>

    </thead>

    <tbody>

    @php $paxIn = $paxInInf = $paxTra = $paxTraInf = $paxOut = $paxOutInf = $delayTotal = $delayMinTotal = 0 @endphp
    @php $totalFlights = 0 @endphp
    @php $ssrTotalsDep = $ssrTotalsArr = [] @endphp

    @foreach ($flights as $k => $items)
        {{--        @foreach ($flights->lines as $k => $line)--}}

        {{--            @php $items = $line->getFlights()@endphp --}}
        @php $depFlight = $depFn = $depAp = $arrAp = $depAC = null @endphp
        @php $in = $inInf = $tra = $traInf = $out = $outInf = $dlTotal = $dlMins = 0 @endphp

        @if (count($items) == 2)
            @php $depFlight = $items[0] @endphp
            @php $depAp = getFlightDepartureAirport($depFlight, false, true) @endphp
            @php $arrAp = getFlightArrivalAirport($depFlight, false, true) @endphp
            @php $depSTD = $depFlight->std && $depFlight->std != EMPTY_DATETIME ? baseDateFormat($depFlight->std, true) : null @endphp
            @php $depSTDDate = $depSTD ? date("Y-m-d", strtotime($depSTD)) : null @endphp

            @php $depFn = getFlightNumberFull($depFlight->flightNumber) @endphp
            @php $depAC = getFlightAircraft($depFlight) @endphp
            @php $depACType = getFlightAircraftType($depFlight) @endphp

            @php $arrFlight = $items[1] @endphp
            @php $arrFN = getFlightNumberFull($arrFlight->flightNumber) @endphp
            @php $arrDepAp = getFlightDepartureAirport($arrFlight, false, true) @endphp
            @php $arrArrAp = getFlightArrivalAirport($arrFlight) @endphp
            @php $arrSTA = $arrFlight->sta && $arrFlight->sta != EMPTY_DATETIME ? baseDateFormat($arrFlight->sta, true) : null @endphp
            @php $arrSTADate = $arrSTA ? date("Y-m-d", strtotime($arrSTA)) : null @endphp
            @php $depFltCancelledClass = $depFlight->cancelled_at ? "color-red" : "" @endphp
            @php $arrFltCancelledClass = $arrFlight->cancelled_at ? "color-red" : "" @endphp
            <tr data-row="{{ $k }}">
                <td>{{ getFlightDepartureInitialDate($depFlight, true) }}</td>
                {{--Departure Flight--}}
                <td>{{ $depAp }}</td>
                <td class="{{ $depFltCancelledClass }} d-flex flex-column justify-content-center">
                    <span class="bind-flight" data-fn="{{ $depFn }}" data-flight_id="{{ $depFlight->id }}">{{ $depFn }}</span>
                    @if ($depFlight->cancelled_at)
                        <span class="cancelled-note">(Cancelled)</span>
                    @endif
                </td>

                <td>{{ $depAC }}</td>
                {{--                        <td>{{ $depFlight->parent_id }}</td>--}}
                <td>{{ $depACType }}</td>

                {{--Arrival flight ATA--}}
                <td class="{{ $arrFltCancelledClass }} d-flex flex-column justify-content-center">
                    <span class="bind-flight-arr" data-fn="{{ $arrFN }}" data-flight_id="{{ $arrFlight->id }}">{{ $arrFN }}</span>
                    @if ($arrFlight->cancelled_at)
                        <span class="cancelled-note">(Cancelled)</span>
                    @endif
                </td>
                <td>{{ $arrDepAp }}</td>
                <td>{{ $arrFlight->sta && $arrFlight->sta != EMPTY_DATETIME ? baseTimeFormat($arrFlight->sta) : "" }}</td>
                <td>{{ $arrFlight->ata && $arrFlight->ata != EMPTY_DATETIME ? baseTimeFormat($arrFlight->ata) : "" }}</td>

                {{--                        Added--}}
                {{--                    <td>{{ strtotime($arrFlight->ata) - strtotime($arrFlight->sta) }}</td>--}}
                <td class="text-right">{{ getFlightDelayFromStaToAta($arrFlight) }}</td>
                <td>{{ $arrAp }}</td>
                <td>{{ $depFlight->std && $depFlight->std != EMPTY_DATETIME ? baseTimeFormat($depFlight->std) : "" }}</td>

                {{--Departure flight ATD--}}
                <td>{{ $depFlight->atd && $depFlight->atd != EMPTY_DATETIME ? baseTimeFormat($depFlight->atd) : "" }}</td>

                {{--DELAYS OUT--}}
                @php list($codes, $times, $dlTotal, $dlMins) = getFlightDelays($depFlight) @endphp
                @if (count($codes))
                    <td class="color-red">{{ implode("/", $codes) }}</td>
                    <td class="color-red">{{ implode("/", $times) }}</td>
                    <td class="text-right">{{ $dlMins }}</td>
                    <td class="text-right">{{ $dlTotal }}</td>
                @else
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                @endif

                {{--- PAX IN---}}
                @if ($arrFlight->sectors)
                    <td>{{ $in = $arrFlight->sectors[$arrArrAp->id]["pax_total"]}}</td>
                    <td>{{ $inInf = $arrFlight->sectors[$arrArrAp->id]["pax_inf"] }}</td>

                    {{--PAX TRA--}}
                    <td>{{ $tra = $arrFlight->sectors["tra"]["pax_total"] }}</td>
                    <td>{{ $traInf = $arrFlight->sectors["tra"]["pax_inf"] }}</td>

                    {{--- PAX OUT---}}
                    <td>{{ $out = getFlightPaxTotal($depFlight, true) }}</td>
                    <td>{{ $outInf = $depFlight->pax_inf_actual }}</td>
                @else
                    <td>{{ $in = getFlightPaxTotal($arrFlight, true) }}</td>
                    <td>{{ $inInf = $arrFlight->pax_inf_actual }}</td>

                    {{--PAX TRA--}}
                    <td></td>
                    <td></td>

                    {{--- PAX OUT---}}
                    <td>{{ $out = getFlightPaxTotal($depFlight, true) }}</td>
                    <td>{{ $outInf = $depFlight->pax_inf_actual }}</td>
                @endif

                {{--            <td>{{ $arrAp }}</td>--}}
                {{--            <td>{{ baseTimeFormat($depSTD) }}</td>--}}

                {{--Arrival Flight--}}
                {{--            <td>{{ $arrFN }}</td>--}}
                {{--            <td>{{ $arrDepAp }}</td>--}}
                {{--            <td>{{ ($depSTDDate != $arrSTADate ? $arrSTADate." " : ""). baseTimeFormat($arrSTA) }}</td>--}}

                {{--SSR--}}
                @foreach($ssrList as $ssr)
                    {{--IN--}}
                    @if ($arrFlight->ssr_ready && isset($arrFlight->ssr_ready[$ssr]))
                        @php $s = $arrFlight->ssr_ready[$ssr] @endphp
                        <td>{{ $s }}</td>

                        @if (!isset($ssrTotalsArr[$ssr]))
                            @php $ssrTotalsArr[$ssr] = 0 @endphp
                        @endif

                        @php $ssrTotalsArr[$ssr] += $s @endphp
                    @else
                        <td></td>
                    @endif

                    {{--OUT--}}
                    @if ($depFlight->ssr_ready && isset($depFlight->ssr_ready[$ssr]))
                        @php $s = $depFlight->ssr_ready[$ssr] @endphp

                        <td>{{ $s }}</td>

                        @if (!isset($ssrTotalsDep[$ssr]))
                            @php $ssrTotalsDep[$ssr] = 0 @endphp
                        @endif

                        @php $ssrTotalsDep[$ssr] += $s @endphp
                    @else
                        <td></td>
                    @endif
                @endforeach

                {{--Counters--}}
                <td>
                    @if ($depFlight->ckin_num)
                        {{ $depFlight->ckin_num }}
                    @endif

                    @if ($arrFlight->ckin_num)
                        / {{ $arrFlight->ckin_num }}
                    @endif
                </td>

                @if ($depFlight->cancelled_at)
                    <td class="color-red" style="min-width: 60px;">{{ getCancellationDate($depFlight) }}</td>
                    <td class="color-red" style="min-width: 50px;">{{ getCancellationTime($depFlight) }}</td>
                    <td class="color-red">{{ $depFlight->remark }}</td>
                    <td>{{ $depFlight->sla }}</td>
                    <td></td>
                @else
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>{{ $depFlight->sla }}</td>
                    <td>{{ $depFlight->remark }}</td>
                @endif

            </tr>

            @php $totalFlights++ @endphp

        @else
            @php $flight = $items[0] @endphp
            @php $fn = getFlightNumberFull($flight->flightNumber) @endphp
            @if ($flight->type == DEPARTURE)

                @php $ac = getFlightAircraft($flight) @endphp
                @php $acType = getFlightAircraftType($flight) @endphp
                @php $depAp = getFlightDepartureAirport($flight, false, true) @endphp
                @php $arrAp = getFlightArrivalAirport($flight, false, true) @endphp
                @php $fltCancelledClass = $flight->cancelled_at ? "color-red" : "" @endphp
                <tr data-row="{{ $k }}">
                    <td>{{ getFlightDepartureInitialDate($flight, true) }}</td>
                    {{--Departure Flight--}}
                    <td>{{ $depAp }}</td>
                    <td class="{{ $fltCancelledClass }} d-flex flex-column justify-content-center">
                        <span class="bind-flight" data-fn="{{ $fn }}" data-flight_id="{{ $flight->id }}">{{ $fn }}</span>
                        @if ($flight->cancelled_at)
                            <span class="cancelled-note">(Cancelled)</span>
                        @endif
                    </td>

                    {{--                <td>{{ $arrAp }}</td>--}}
                    <td>{{ $ac }}</td>
                    <td>{{ $acType }}</td>
                    {{--Arrival flight ATA--}}
                    <td><span class="bind-flight-arr" data-fn="" data-flight_id=""></span></td>
                    <td></td>
                    <td></td>
                    <td></td>

                    <td></td>
                    <td>{{ $arrAp }}</td>
                    <td>{{ $flight->std && $flight->std != EMPTY_DATETIME ? baseTimeFormat($flight->std) : "" }}</td>

                    {{--Departure flight ATD--}}
                    <td>{{ $flight->atd && $flight->atd != EMPTY_DATETIME ? baseTimeFormat($flight->atd) : "" }}</td>
                    {{--Departure Flight--}}
                    {{--                <td>{{ $flight->std && $flight->std != EMPTY_DATETIME ? baseTimeFormat($flight->std) : "" }}</td>--}}

                    @php list($codes, $times, $dlTotal, $dlMins) = getFlightDelays($flight) @endphp
                    @if (count($codes))
                        <td class="color-red">{{ implode("/", $codes) }}</td>
                        <td class="color-red">{{ implode("/", $times) }}</td>
                        <td>{{ $dlMins }}</td>
                        <td>{{ $dlTotal }}</td>
                    @else
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    @endif

                    {{--- PAX IN---}}
                    <td></td>
                    <td></td>

                    {{--PAX TRA--}}
                    <td></td>
                    <td></td>

                    {{--- PAX OUT---}}
                    <td>{{ $out = getFlightPaxTotal($flight, true) }}</td>
                    <td>{{ $outInf = $flight->pax_inf_actual }}</td>


                    @foreach($ssrList as $ssr)
                        {{--IN--}}
                        <td></td>

                        {{--OUT--}}
                        @if ($flight->ssr_ready && isset($flight->ssr_ready[$ssr]))
                            @php $s = $flight->ssr_ready[$ssr] @endphp

                            <td>{{ $s }}</td>

                            @if (!isset($ssrTotalsDep[$ssr]))
                                @php $ssrTotalsDep[$ssr] = 0 @endphp
                            @endif

                            @php $ssrTotalsDep[$ssr] += $s @endphp
                        @else
                            <td></td>
                        @endif
                    @endforeach

                    {{--Counters--}}
                    <td>{{ $flight->ckin_num }}</td>

                    @if ($flight->cancelled_at)
                        <td class="color-red" style="border-right: 0 !important;">{{ getCancellationDate($flight) }}</td>
                        <td class="color-red" style="border-right: 0 !important;">{{ getCancellationTime($flight) }}</td>
                        <td class="color-red">{{ $flight->remark }}</td>
                        <td style="min-width: 200px;">{{ $flight->sla }}</td>
                        <td></td>
                    @else
                        <td></td>
                        <td></td>
                        <td></td>
                        <td style="min-width: 200px;">{{ $flight->sla }}</td>
                        <td>{{ $flight->remark }}</td>
                    @endif


                </tr>

                @php $totalFlights++ @endphp


            @else
                @php $ac = getFlightAircraft($flight) @endphp
                @php $acType = getFlightAircraftType($flight) @endphp
                @php $arrAp = getFlightArrivalAirport($flight, false, true) @endphp
                @php $arrArrAp = getFlightArrivalAirport($flight) @endphp
                @php $arrDepAp = getFlightDepartureAirport($flight, false, true) @endphp

                @php $arrSTA = $flight->sta && $flight->sta != EMPTY_DATETIME ? baseDateFormat($flight->sta, true) : null @endphp
                @php $arrSTADate = $arrSTA ? date("Y-m-d", strtotime($arrSTA)) : null @endphp
                @php $arrFltCancelledClass = $flight->cancelled_at ? "color-red" : "" @endphp

                <tr data-row="{{ $k }}">

                    <td>{{ getFlightArrivalInitialDate($flight, true) }}</td>
                    {{--Departure Flight--}}
                    <td></td>
                    <td><span class="bind-flight" data-fn="" data-flight_id=""></span></td>
                    <td></td>
                    <td></td>

                    {{--Arrival flight ATA--}}
                    <td class="{{ $arrFltCancelledClass }} d-flex flex-column justify-content-center">
                        <span class="bind-flight-arr" data-fn="{{ $fn }}" data-flight_id="{{ $flight->id }}">{{ $fn }}</span>
                        @if ($flight->cancelled_at)
                            <span class="cancelled-note">(Cancelled)</span>
                        @endif
                    </td>
                    <td>{{ $arrDepAp }}</td>
                    <td>{{ $flight->sta && $flight->sta != EMPTY_DATETIME ? baseTimeFormat($flight->sta) : "" }}</td>
                    <td>{{ $flight->ata && $flight->ata != EMPTY_DATETIME ? baseTimeFormat($flight->ata) : "" }}</td>

                    <td>{{ getFlightDelayFromStaToAta($flight) }}</td>
                    <td>{{ $arrAp }}</td>
                    <td></td>

                    {{--Departure flight ATD--}}
                    <td></td>

                    {{--DELAYS OUT--}}
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>

                    {{--- PAX IN---}}
                    @if ($flight->sectors)
                        <td>{{ $in = $flight->sectors[$arrArrAp->id]["pax_total"]}}</td>
                        <td>{{ $inInf = $flight->sectors[$arrArrAp->id]["pax_inf"] }}</td>

                        {{--PAX TRA--}}
                        <td>{{ $tra = $flight->sectors["tra"]["pax_total"] }}</td>
                        <td>{{ $traInf = $flight->sectors["tra"]["pax_inf"] }}</td>

                        {{--- PAX OUT---}}
                        <td></td>
                        <td></td>

                    @else
                        <td>{{ $in = getFlightPaxTotal($flight, true) }}</td>
                        <td>{{ $inInf = $flight->pax_inf_actual }}</td>

                        {{--PAX TRA--}}
                        <td></td>
                        <td></td>

                        {{--- PAX OUT---}}
                        <td></td>
                        <td></td>

                    @endif

                    {{--SSR--}}
                    @foreach($ssrList as $ssr)
                        {{--IN--}}
                        @if ($flight->ssr_ready && isset($flight->ssr_ready[$ssr]))
                            @php $s = $flight->ssr_ready[$ssr] @endphp
                            <td>{{ $s }}</td>

                            @if (!isset($ssrTotalsArr[$ssr]))
                                @php $ssrTotalsArr[$ssr] = 0 @endphp
                            @endif

                            @php $ssrTotalsArr[$ssr] += $s @endphp
                        @else
                            <td></td>
                        @endif

                        {{--OUT--}}
                        <td></td>
                    @endforeach

                    {{--Counters--}}
                    <td>
                        @if ($flight->ckin_num)
                            / {{ $flight->ckin_num }}
                        @endif
                    </td>

                    @if ($flight->cancelled_at)
                        <td class="color-red" style="min-width: 60px;">{{ getCancellationDate($flight) }}</td>
                        <td class="color-red" style="min-width: 50px;">{{ getCancellationTime($flight) }}</td>
                        <td class="color-red">{{ $flight->remark }}</td>
                        <td></td>
                    @else
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td>{{ $flight->remark }}</td>
                    @endif

                </tr>

                @php $totalFlights++ @endphp
            @endif
        @endif

        @php $paxIn += ($in ? $in : 0) @endphp
        @php $paxInInf += ($inInf ? $inInf : 0) @endphp
        @php $paxTra += ($tra ? $tra : 0) @endphp
        @php $paxTraInf += ($traInf ? $traInf : 0) @endphp
        @php $paxOut += ($out ? $out : 0) @endphp
        @php $paxOutInf += ($outInf ? $outInf : 0) @endphp
        @php $delayMinTotal += ($dlMins ? $dlMins : 0) @endphp
        @php $delayTotal += ($dlTotal ? $dlTotal : 0) @endphp

    @endforeach
    <tr>
        <td><strong>FLIGHTS</strong></td>
        <td><strong>{{ $totalFlights }}</strong></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td><strong>DELAY</strong></td>
        <td class="text-right"><strong>{{ $delayMinTotal }}</strong></td>
        <td class="text-right"><strong>{{ $delayTotal }}</strong></td>

        {{--IN--}}
        <td class=""><strong>{{ $paxIn }}</strong></td>
        <td class=""><strong>{{ $paxInInf }}</strong></td>
        {{--TRA--}}
        <td class=""><strong>{{ $paxTra }}</strong></td>
        <td class=""><strong>{{ $paxTraInf }}</strong></td>
        {{--OUT--}}
        <td class=""><strong>{{ $paxOut }}</strong></td>
        <td class=""><strong>{{ $paxOutInf }}</strong></td>

        @foreach($ssrList as $ssr)
            <td><strong>{{ isset($ssrTotalsArr[$ssr]) ? $ssrTotalsArr[$ssr] : "" }}</strong></td>
            <td><strong>{{ isset($ssrTotalsDep[$ssr]) ? $ssrTotalsDep[$ssr] : "" }}</strong></td>
        @endforeach

        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>

    </tr>

    </tbody>

</table>
