<?php require_once(public_path("smart/inc/init.php")); ?>
    <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            <div>
                {!! Form::open(['class' => 'form-inline', 'method' => 'GET', 'id' => 'formOPS']) !!}
                <div class="form-group marginBottomRight">
                    <label>@lang("content.airline")</label>
                    <div class="btn-group">
                        {!! Form::select('airline[]', $airlines, \request()->get('airline'), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']) !!}
                    </div>
                </div>

                <div class="form-group marginBottomRight">
                    <label>@lang("content.airport")</label>
                    <div class="btn-group">
                        {!! Form::select('airport[]', $airports, \request()->get('airport'), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']) !!}
                    </div>
                </div>

                <div class="form-group marginBottomRight">
                    <label>@lang("content.date")</label>
                    {!! Form::text('date', $date, ['class'=>'form-control dateFrom myinput', 'style' => 'width: 120px;', 'placeholder'=>'Date', 'id'=>'date']) !!}
                </div>

                <div class="form-group marginBottomRight">
                    <button type="submit" class="btn btn-primary">@lang("content.submit")</button>
                </div>
                {!! Form::close() !!}
            </div>
            <div class="clearfix"></div>
        </article>

        <article class="col-sm-12 col-md-12 col-lg-12">
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-license" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                    <h2>@lang("content.list")</h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding" style="min-height: 50px !important;">

                        <div class="table-responsive">

                            <table class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    {{--<th>No</th>--}}
                                    <th>@lang("content.notes")</th>
                                    <th style="width: 50px;">DEP<br>FLT No</th>
                                    <th style="width: 50px;">A/C</th>
                                    <th>@lang("content.notes")</th>
                                    <th style="width: 50px;">ARR<br>FLT No</th>
                                    <th style="width: 30px;">PTA</th>
                                    <th>@lang("content.notes")</th>
                                    <th style="width: 30px;">DEP<br>STN</th>
                                    <th style="width: 30px;">PTD</th>
                                    <th style="width: 30px;">ARR<br>STN</th>
                                    <th style="width: 30px;">PTA</th>
                                    <th>@lang("content.notes")</th>
                                    <th>@lang("content.notes")</th>
                                    <th>@lang("content.notes")</th>
                                    <th>@lang("content.notes")</th>
                                </tr>

                                </thead>
                                <tbody>
                                {{--                                @foreach ($flights->lines as $k => $line)--}}
                                @foreach ($flights as $k => $items)

                                    {{--                                    @php $items = $line->getFlights()@endphp --}}
                                    @php $depFlight = $depFn = $depAp = $arrAp = $depAC = null @endphp

                                    @if (count($items) == 2)
                                        @php $depFlight = $items[0] @endphp
                                        @php $depAp = getFlightDepartureAirport($depFlight, false, true) @endphp
                                        @php $arrAp = getFlightArrivalAirport($depFlight, false, true) @endphp

                                        @php $depFn = getFlightNumberFull($depFlight->flightNumber) @endphp
                                        @php $depAC = getFlightAircraft($depFlight) @endphp

                                        @php $arrFlight = $items[1] @endphp
                                        @php $arrFN = getFlightNumberFull($arrFlight->flightNumber) @endphp

                                        <tr>
                                            {{--<td>{{ $k + 1 }}</td>--}}
                                            <td class="color-red" data-center style="font-weight: bold">{{ $depFlight->remark }}</td>

                                            {{--Departure Flight--}}
                                            <td>{{ $depFn }}</td>
                                            <td>{{ $depAC }}</td>
                                            <td></td>


                                            @if ($depFlight->type == ARRIVAL)
                                                {{--                                                {{ debug($depFlight->type." / ".$arrFlight->type. "DEP : {$depFn}/{$depAC}/" ) }}--}}
                                            @endif

                                            {{--Arrival Flight--}}
                                            <td>{{ $arrFN }}</td>
                                            <td>{{ getFlightArrivalInitialDate($arrFlight, false, true) }}</td>
                                            {{--                                            <td>{{ getFlightArrivalInitialDate($arrFlight, false) }}</td>--}}
                                            <td></td>

                                            {{--Departure Flight--}}
                                            <td>{{ $depAp }}</td>
                                            <td>{{ getFlightDepartureInitialDate($depFlight, false, true) }}</td>
                                            {{--                                            <td>{{ getFlightDepartureInitialDate($depFlight, false) }}</td>--}}
                                            <td>{{ $arrAp }}</td>
                                            <td>{{ getFlightArrivalInitialDate($depFlight, false, true) }}</td>
                                            {{--                                            <td>{{ getFlightArrivalInitialDate($depFlight, false) }}</td>--}}

                                            {{--Notes--}}
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>

                                    @else
                                        @php $flight = $items[0] @endphp
                                        @php $fn = getFlightNumberFull($flight->flightNumber) @endphp
                                        @if ($flight->type == DEPARTURE)

                                            @php $ac = getFlightAircraft($flight) @endphp
                                            @php $depAp = getFlightDepartureAirport($flight, false, true) @endphp
                                            @php $arrAp = getFlightArrivalAirport($flight, false, true) @endphp
                                            <tr>
                                                {{--<td>{{ $k + 1 }}</td>--}}
                                                <td class="color-red" data-center style="font-weight: bold">{{ $flight->remark }}</td>

                                                {{--Departure Flight--}}
                                                <td>{{ $fn }}</td>
                                                <td>{{ $ac }}</td>
                                                <td></td>

                                                {{--Arrival Info--}}
                                                <td></td>
                                                <td></td>
                                                <td></td>

                                                <td>{{ $depAp }}</td>
                                                <td>{{ getFlightDepartureInitialDate($flight, false, true) }}</td>
                                                <td>{{ $arrAp }}</td>
                                                <td>{{ getFlightArrivalInitialDate($flight, false, true) }}</td>

                                                {{--Notes--}}
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                        @else
                                            @php $arrAp = getFlightArrivalAirport($flight, false, true) @endphp

                                            <tr>
                                                {{--<td>{{ $k + 1 }}</td>--}}
                                                <td class="color-red" data-center style="font-weight: bold"></td>

                                                {{--Departure Flight--}}
                                                <td></td>
                                                <td></td>
                                                <td></td>


                                                {{--Arrival Flight--}}
                                                <td>{{ $fn }}</td>
                                                <td>{{ getFlightArrivalInitialDate($flight, false, true) }}</td>
                                                <td></td>

                                                {{--Departure Flight--}}
                                                <td></td>
                                                <td></td>

                                                {{--Arrival Flight--}}
                                                <td>{{ $arrAp }}</td>
                                                <td>{{ getFlightArrivalInitialDate($flight, false, true) }}</td>

                                                {{--Notes--}}
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                        @endif
                                    @endif

                                @endforeach
                                </tbody>

                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table", false, [[ 8, "asc" ]]);
    };

    pagefunction();

</script>
