<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => trans("content.admin"), 'moduleName' => trans("content.module_mapping")])

            <div>

            @if (Session::get("message"))
            @php $message = Session::get("message"); @endphp
            <div class="alert alert-{!! $message["type"] !!}">
                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">@lang("content.add_new")Close</span></button>
                <h4>{!! $message["title"] !!}</h4>
                <p>{!! $message["text"] !!}</p>
            </div>
            @endif

            <div id="notification-block"></div>

            @if (isset($departments) && count($departments))
            <div class="row">
                <div class="col-sm-7">
                    <table class="table table-responsive">
                        <tr>
                            <th>@lang("content.department_name")</th>
                            <th>@lang("content.list_of_modules")</th>
                        </tr>
                        @foreach ($departments as $department_id => $department_name)
                        <?php $i = 0?>
                        <tr>
                            <td style="width: 250px">{!! $department_name !!}</td>
                            <td>
                                <table class="table table-bordered table-striped table-hover" {!! ($department_id == 0) ? 'id="home_table"' : '' !!}>
                                @foreach($modules as $module)
                                    @if ($module->department_id == $department_id)
                                        @if ($i == 0)
                                        <thead>
                                            <tr class="header-tr">
                                                <th>@lang("content.name")</th>
                                                <th>@lang("content.actions")</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @endif

                                        <tr>
                                            <td style="width: 200px">{!! $module->name !!}</td>
                                            <td>
                                                @if ($department_id != 0)
                                                <button data-department-id="{!! $department_id !!}" data-module-id="{!! $module->id !!}" type="button" class="btn btn-sm remove-button btn-danger">@lang("content.remove")</button>
                                                @endif
                                                <button data-department-id="{!! $department_id !!}" data-module-id="{!! $module->id !!}" type="button" class="btn btn-sm edit-button btn-primary">@lang("content.edit")</button>
                                            </td>
                                        </tr>
                                        <?php $i++?>
                                    @endif
                                @endforeach
                                </tbody>
                                </table>
                            </td>
                        </tr>
                        @endforeach
                    </table>
                </div>
            </div>
            @endif
            <a class="btn-sm btn btn-default" href="{!! route("homepage")."#". url("module") !!}">@lang("content.back")</a>

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var structure__departments = {!! json_encode($departments) !!};

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("{{ asset("/assets/js/views/module/map.js") }}", pagefunction);

</script>
