<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 no-padding margin-bottom-10">
                <a class="btn-sm btn btn-primary" href="{{ route("homepage")."#".url("module/create?s=".rand(100, 999)) }}">@lang("content.add_new_module")</a>
                @if (isset($modules) && count($modules))
                    <a class="btn-sm btn btn-info" href="{{ route("homepage")."#".url("module/map") }}">@lang("content.module_map")</a>
                @endif
            </div>

            <div class="clearfix"></div>

            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>

                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                    <h2>@lang("content.list")</h2>


                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding">

                        <div class="table-responsive">

                            @if (isset($modules) && count($modules))
                            <table class="table table-bordered table-hover" id="module-table">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>@lang("content.name")</th>
                                        <th>@lang("content.hidden")</th>
                                        <th>@lang("content.link")</th>
                                        @if (env(CARRIER) == HANDLING)
                                            <th>@lang("content.category")</th>
                                        @else
                                            <th>@lang("content.department")</th>
                                        @endif

                                        <th>@lang("content.permissions")</th>
                                        <th style="width: 300px">@lang("content.actions")</th>
                                    </tr>
                                </thead>

                                <tbody>
                                @foreach ($modules as $i => $module)
                                    @php $permissions = [] @endphp
                                    <tr>
                                        <td>{{ $i + 1 }}</td>
                                        <td>{{ $module->name }}</td>
                                        <td>{!! $module->hidden_module ? '<i class="fa fa-check"></i>' : "" !!}</td>

                                        <td><a href="{{ route("homepage")."#".url($module->link) }}" target="_blank">{{ $module->link }}</a></td>

                                        @if (env(CARRIER) == HANDLING)
                                            <th>{{ $module->category }}</th>
                                        @else
                                            <td>{{ ($module->department_id == 0) ? "Home" : (($module->department_id == -1) ? "Admin Menu" : ($module->department ? $module->department->name : "-") ) }}</td>
                                        @endif

                                        <td>
                                        @if (count($module->permission))
                                            @foreach($module->permission as $each)
                                                @if (!$each->deleted_at)
                                                    @php $permissions[] = $each->name @endphp
                                                @endif
                                            @endforeach
                                            {{ implode(' | ', array_slice($permissions, 0, 5)) }}
                                            {{ count($permissions) > 5 ? '...' : '' }}
                                        @endif
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a target="_blank" class="btn btn-sm btn-primary" href="{{ route("homepage")."#".url("module/{$module->id}/edit?s=".rand(100, 999)) }}">@lang("content.edit")</a>
                                                <a class="btn btn-sm btn-danger confirm" data-confirm-text="Are you sure you want to remove this module?"
                                                   href="{{ route("homepage")."#".url("module/delete/{$module->id}") }}">@lang("content.delete")</a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach

                                  </tbody>
                            </table>
                            @endif

                        </div>

                    </div>

                </div>

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#module-table");
    };

    pagefunction();

</script>
