<style type="text/css">
    .form-group label {font-weight: bold}
</style>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-sm-12">

            @include('general.tab-header', ['departmentName' => trans("content.module"), 'moduleName' => trans("content.edit") ])

            <div class="col-sm-8 col-sm-offset-2">

            {!! Form::open([ 'method' => 'POST',  "url" => url("module/{$selectedModule->id}"), "autocomplete"=>"off", "class"=>"form-horizontal", 'id' => "formEdit"]) !!}
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.name") </label>
                    <div class="col-sm-7">
                        {!! Form::text("name", $selectedModule->name, ["id" => "name", "class" => "form-control input-sm", "required" => "required"]) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.subname") </label>
                    <div class="col-sm-7">
                        {!! Form::text("subname", $selectedModule->subname, ["id" => "subname", "class" => "form-control input-sm"]) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.link") </label>
                    <div class="col-sm-7">
                        {!! Form::text("link", $selectedModule->link, ["id" => "link", "class" => "form-control input-sm", "required" => "required"]) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.icon") </label>
                    <div class="col-sm-7">
                        {!! Form::text("icon", $selectedModule->icon, ["id" => "link", "class" => "form-control input-sm"]) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.open_module") </label>
                    <div class="col-sm-7">
                        <label class="checkbox-inline">
                            {!! Form::checkbox('open_module', 1, $selectedModule->open_module, ['id' => 'open_module']) !!} @lang("content.yes_no")
                        </label>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.hidden") </label>
                    <div class="col-sm-7">
                        <label class="checkbox-inline">
                            {!! Form::checkbox('hidden_module', 1, $selectedModule->hidden_module, ['id' => 'hidden_module']) !!} @lang("content.yes_no")
                        </label>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.new_tab")</label>
                    <div class="col-sm-7">
                        <label class="checkbox-inline">
                            {!! Form::checkbox('open_new_tab', 1, $selectedModule->open_new_tab, ['id' => 'new_tab']) !!} @lang("content.yes_no")
                        </label>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.quick_links")</label>
                    <div class="col-sm-7">
                        <label class="checkbox-inline">
                            {!! Form::checkbox('quick_links', 1, $selectedModule->quick_links, ['id' => 'quick_links']) !!} @lang("content.yes_no")
                        </label>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.department")</label>
                    <div class="col-sm-7">
                        {!! Form::select("department_id", $departments, $selectedModule->department_id, ["id" => "department_id", "class" => "form-control input-sm", "required" => "required"]) !!}
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.categories")</label>
                    <div class="col-sm-7">
                        {!! Form::select("category", $categories, $selectedModule->category, ["id" => "category", "class" => "form-control input-sm"]) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.new_category")</label>
                    <div class="col-sm-7">
                        {!! Form::text("new_category", null, ["class" => "form-control input-sm"]) !!}
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.subcategories")</label>
                    <div class="col-sm-7">
                        {!! Form::select("subcategory", $subcategories, $selectedModule->subcategory, ["id" => "subcategory", "class" => "form-control input-sm"]) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.new_subcategory")</label>
                    <div class="col-sm-7">
                        {!! Form::text("new_subcategory", null, ["class" => "form-control input-sm"]) !!}
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-sm-10 text-right">
                        <div class="btn-group">
                            @if ($selectedModule->id)
                                <input type="hidden" name="id" value="{{ $selectedModule->id }}"/>
                            @endif

                            {!! Form::submit( (($selectedModule->id) ? trans("content.save_changes") : trans("content.save")), array('class' => 'btn btn-sm btn-primary', 'style' => 'margin-top:0')) !!}
                            <a href="{{ route("homepage")."#".url("module") }}" class="btn btn-sm btn-default">@lang("content.back")</a>
                        </div>
                    </div>
                </div>

            {!! Form::close() !!}

            </div>

            {{--Module's Permissions List--}}
            @if ($selectedModule->id)
                <div class="col-sm-12 permission_list" data-moduleId = {!! $selectedModule->id !!}>
                    <h4>Permissions
                        <a class="btn btn-sm btn-success add">@lang("content.add_new")</a>
                        <a style="display: none" class="btn btn-sm btn-warning save_all">@lang("content.save_all")</a>
                    </h4>
                    <hr/>

                    {!! Form::open(['method' => 'GET', "url" => url('module/add'), 'autocomplete' => 'off', 'class' => 'form-horizontal', 'id' => 'formAdd']) !!}
                    @if (count($selectedModule->permission))

                        <div class="form-group col-md-6">
                            <div class="col-md-5">
                                @csrf
                                {!! Form::label('name', trans("content.name")) !!}
                            </div>
                            <div class="col-sm-3">
                                {!! Form::label('name', 'All | Dept | None*') !!}
                            </div>
                            <div class="col-sm-4">
                                {!! Form::label('name', trans("content.actions")) !!}
                            </div>
                        </div>

                        <div class="form-group col-md-6">
                            <div class="col-md-5">
                                {!! Form::label('name', trans("content.name")) !!}
                            </div>
                            <div class="col-sm-3">
                                {!! Form::label('name', 'All | Dept | None*') !!}
                            </div>
                            <div class="col-sm-4">
                                {!! Form::label('name', trans("content.actions")) !!}
                            </div>
                        </div>

                        @foreach($selectedModule->permission as $i => $each)
                            <div class="form-group col-md-6 modules_permissions" data-num={{ $i }} data-permissionId={{ $each->id }}>
                                <div class="col-sm-5">
                                    {!! Form::text("name".$i, $each->name, ["class" => "form-control input-sm name", 'placeholder' => 'Permission Name', "required" => "required"]) !!}
                                </div>
                                <div class="col-sm-3">
                                    {!! Form::radio('default'.$i, 'all', $each->default_all, ['class' => 'default_all marginBottomRight']) !!}
                                    {!! Form::radio('default'.$i, 'department', $each->default_department, ['class' => 'default_department marginBottomRight']) !!}
                                    {!! Form::radio('default'.$i, 0, !($each->default_all || $each->default_department), ['class' => 'default_none']) !!}
                                </div>
                                <div class="col-sm-4 btn-group">
                                    <a class="btn btn-sm btn-warning save" {!! $each->deleted_at ? 'style="display: none"' : '' !!}>@lang("content.save")</a>
                                    <a class="btn btn-sm btn-danger delete" {!! $each->deleted_at ? 'style="display: none"' : '' !!}>@lang("content.delete")</a>
                                    <a class="btn btn-sm btn-success restore" {!! $each->deleted_at ? '' : 'style="display: none"' !!}>@lang("content.restore")</a>
                                </div>
                            </div>
                        @endforeach

                        {{--<div class="form-group col-md-12">--}}
                            {{--<hr/>--}}
                            {{--<h5>*Default Parameters.(i.e. if ALL is set Then Everyone By Default Will Have Access To Modules Permission, DEPT - Only Department)</h5>--}}
                        {{--</div>--}}
                    @endif

                    {!! Form::close() !!}
                </div>
            @endif

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("{{ asset("/assets/js/views/module/edit.js?2") }}", pagefunction);

</script>


