<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
    <!-- widget options:
    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    data-widget-colorbutton="false"
    data-widget-editbutton="false"
    data-widget-togglebutton="false"
    data-widget-deletebutton="false"
    data-widget-fullscreenbutton="false"
    data-widget-custombutton="false"
    data-widget-collapsed="true"
    data-widget-sortable="false"

    -->
    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>List </h2>

    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="overflow: auto;">

            <table id="mhb" class="table table-striped table-bordered table-hover" width="100%">

                <thead>
                <tr>
                    <th>@lang("content.report_date")</th>
                    <th>@lang("content.type")</th>
                    <th>@lang("content.station")</th>
                    <th>@lang("content.carrier")</th>
                    <th>File Ref</th>
                    <th>@lang("content.ticket_number")</th>

                    <th>@lang("content.title")</th>
                    <th>@lang("content.last_name")</th>
                    <th>@lang("content.initials")</th>
                    <th>@lang("content.passport_no")</th>
                    <th>@lang("content.address")</th>
                    <th>@lang("content.phone")</th>
                    <th>@lang("content.language")</th>

                    <th>Number of Bags</th>
                    <th>Checked Weight</th>
                    <th>Received Weight</th>

                    <th>@lang("content.status")</th>
                    <th style="min-width: 200px;">@lang("content.actions")</th>
                </tr>

                </thead>

                <tbody>
                @foreach($mhb as $each)
                    @php $countBags = count($each->details) @endphp
                    @php $mhb_id = $each->id @endphp
                    @php $status = $each->applicationStatus ? $each->applicationStatus->status : "" @endphp

                    <tr data-mhb_id="{{ $mhb_id }}">
                        <td>{{ $each->report_date != 0 ? baseDateFormat($each->report_date) : "" }}</td>
                        <td>{{ $each->type ? $each->type->type : "" }}</td>
                        <td>{{ $each->airport ? $each->airport->iata : "" }}</td>
                        <td>{{ $each->carrier }}</td>
                        <td>{{ $each->file_reference }}</td>
                        <td>{{ $each->ticket_number }}</td>

                        <td>{{ strtoupper($each->title) }}</td>
                        <td>{{ $each->last_name }}</td>
                        <td>{{ $each->initials }}</td>
                        <td>{{ $each->passport_number }}</td>
                        <td>{{ $each->permanent_address }}</td>
                        <td>{{ $each->permanent_phone }}</td>
                        <td>{{ $each->language }}</td>

                        <td>{{ $countBags }}</td>
                        <td>{{ $each->checked_baggage_weight }}</td>
                        <td>{{ $each->received_baggage_weight }}</td>
                        {{--Application Status--}}
                        <td>
                            @if ($status == APPLICATION_STATUS_CANCELLED)
                                <span class="label label-warning">CANCELLED</span>
                            @elseif ($status == APPLICATION_STATUS_CLOSED)
                                <span class="label label-success">CLOSED</span>
                            @else
                                <span class="label label-primary">OPEN</span>
                            @endif
                        </td>

                        <td style="width: 240px">
                            {{--Actions Are Available Only if Application Status is OPEN --}}
                            @if (!$status || $status == APPLICATION_STATUS_OPEN)
                                <div class="btn-group">

                                    <a style="float: left;" type="button" target="_blank" class="btn btn-sm btn-primary" href="{{ url("/mhb/export-pdf/{$each->id}?signature=1") }}">Sign</a>
                                    <a style="float: left;" type="button" target="_blank" class="btn btn-sm btn-warning" href="{{ url("/mhb/export-pdf/{$each->id}") }}">View</a>

                                    <div class="btn-group" style="float: left;">
                                        {!! Form::open(['method' => 'POST', 'id' => 'formMHBClose', 'class' => 'form-inline', 'url' => url("/mhb/{$mhb_id}") ]) !!}
                                            {!! Form::submit('Close', ['class' => "btn btn-sm btn-success"]) !!}
                                        {!! Form::close () !!}
                                    </div>

                                    <div class="btn-group" style="float: left;">
                                        {!! Form::open(['method' => 'DELETE', 'id' => 'formMHBDelete', 'class' => 'form-inline', 'url' => url("/mhb/{$mhb_id}") ]) !!}
                                            {!! Form::submit('Cancel', ['class' => "btn btn-sm btn-danger"]) !!}
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                            @endif
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

        </div>
        <!-- end widget content -->

    </div>
    <!-- end widget div -->

</div>
<!-- end widget -->