<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-baggagelist-1" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
    <!-- widget options:
    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    data-widget-colorbutton="false"
    data-widget-editbutton="false"
    data-widget-togglebutton="false"
    data-widget-deletebutton="false"
    data-widget-fullscreenbutton="false"
    data-widget-custombutton="false"
    data-widget-collapsed="true"
    data-widget-sortable="false"

    -->
    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>Baggage List </h2>

    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding">

            <table id="mhb_details" class="table table-striped table-bordered table-hover" width="100%">

                <thead>
                <tr>
                    <th>No</th>
                    <th>@lang("content.tag_no")</th>
                    <th>@lang("content.type")</th>
                    <th>Color</th>

                    <th>Brand Name</th>
                    <th>Contents</th>
                    <th>Whs</th>
                    <th>Damage Type</th>
                    <th>Damage Description</th>

                    <th width="7%">@lang("content.flight_number")</th>
                    <th width="7%">Routing</th>
                    <th width="7%">Date/STD</th>
                    <th width="7%">Date/STA</th>
                    <th width="7%">Date/ATA</th>
                </tr>

                </thead>

                <tbody>
                @php $yesIcon = '<i class="glyphicon glyphicon-ok"/>' @endphp
                @php $noIcon = '<i class="glyphicon glyphicon-remove"/>' @endphp

                @foreach($mhb_baggage as $i => $baggage)
                    @php $tag_no = $baggage->carrier ? $baggage->carrier->iata : "" @endphp
                    @php $tag_no .= $baggage->baggage_tag_no @endphp

                    <tr  style="display: none" data-mhb_id="{{ $baggage->mhb_id }}" data-show_bag = "{{ $baggage->show_bag }}"
                        data-side1="{{ $baggage->side1 }}" data-side2="{{ $baggage->side2 }}" data-end1="{{ $baggage->end1 }}"
                        data-end2="{{ $baggage->end2 }}" data-top="{{ $baggage->top }}" data-bottom="{{ $baggage->bottom }}">
                        <td>{{ $i + 1 }}</td>
                        <td>{{ $tag_no }}</td>
                        <td>{{ $baggage->type ? $baggage->type->code : "" }}</td>
                        <td>{{ $baggage->color ? $baggage->color->code : "" }}</td>
                        <td>{{ $baggage->brandName ? $baggage->brandName->name : "" }}</td>
                        <td>{{ $baggage->contents }}</td>
                        <td>{!! $baggage->whs ? $yesIcon : $noIcon !!}</td>
                        <td>{{ $baggage->damage_type }}</td>
                        <td>{{ $baggage->damage_description }}</td>

                        <td colspan="6" style="padding: 0">
                            <table style="padding:0; margin: 0; width: 100%; border: 0">
                                <tbody>
                                @php $baggageDetails = $baggage->details ? $baggage->details : [] @endphp
                                {{--Baggage Details--}}
                                @forelse($baggageDetails as $eachDetail)
                                    <tr>
                                        @php $route = $eachDetail->departureAirport ? $eachDetail->departureAirport->iata."-" : "-" @endphp
                                        @php $route .= $eachDetail->arrivalAirport ? $eachDetail->arrivalAirport->iata : "" @endphp
                                        <td width="20%">{{ $eachDetail->flight_number }}</td>
                                        <td width="20%">{{ $route }}</td>
                                        <td width="20%">{{ $eachDetail->date_time ? baseDateFormat($eachDetail->date_time, true) : "" }}</td>
                                        <td width="20%">{{ $eachDetail->sta ? baseDateFormat($eachDetail->sta, true) : "" }}</td>
                                        <td width="20%">{{ $eachDetail->ata ? baseDateFormat($eachDetail->ata, true) : "" }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5"></td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </td>

                    </tr>
                @endforeach
                </tbody>
            </table>

        </div>
        <!-- end widget content -->

    </div>
    <!-- end widget div -->

</div>
<!-- end widget -->
