@php $signature = isset($signature) && $signature ? true : false @endphp
<html>

<link href="{{ asset("/assets/css/export.css") }}" rel="stylesheet"/>

<page size="A4">
    <div style="width: 100%; display: block; overflow: hidden; text-align: center">
        <img height="100px" src="{{ getAirlineLogo(null) }}" />
    </div>

    <h4 align="center">PROPERTY IRREGULARITY REPORT<br/><br/>
        CARRIER<br/><br/>
        BAGGAGE SERVICES<br/><br/>
        TEL : 123-456-789<br/><br/>
        WEBSITE FOR BAGGAGE TRACING STATUS<br/><br/>
        WWW.AVBIS.AERO/BAGGAGESERVICES</h4>

    @php $countBags = count($mhb->baggage) @endphp
    @php $baggage = $mhb->baggage @endphp
    @php $flight_and_date = "" @endphp

    <table>
        <tbody>
        @php $file_reference = "" @endphp
        @php $file_reference .= $mhb->airport ? $mhb->airport->iata : "" @endphp
        @php $file_reference .= $mhb->carrier @endphp
        @php $file_reference .= $mhb->file_reference @endphp
        @php $file_reference .= "/". ($mhb->report_date ? strtoupper(date("dMy", strtotime($mhb->report_date))) : "") @endphp

        <tr>
            <th>FILE TYPE</th>
            <td>{{ $mhb->type ? $mhb->type->type : "" }}</td>
        </tr>
        <tr>
            <th>FILE REFERENCE</th>
            <td>{{ $file_reference }}</td>
        </tr>
        <tr>
            <th>NAME</th>
            <td>{{ strtoupper($mhb->last_name) }}</td>
        </tr>
        <tr>
            <th>TITLE/INITIALS</th>
            <td>{{ strtoupper($mhb->title."/". $mhb->initials) }}</td>
        </tr>
        <tr>
            <th>NUMBER OF BAGS</th>
            <td>{{ $countBags }}</td>
        </tr>
        <tr>
            <th>TICKET NUMBER</th>
            <td>{{ $mhb->ticket_number }}</td>
        </tr>
        <tr>
            <td colspan="2"><hr></td>
        </tr>



        @foreach($baggage as $i => $eachBag)
            @php $color_and_type = ($eachBag->color ? $eachBag->color->code : "")."".($eachBag->type ? $eachBag->type->code : "") @endphp
            @php $tag_no = $eachBag->carrier ? $eachBag->carrier->iata : "" @endphp
            @php $tag_no .= $eachBag->baggage_tag_no @endphp
            <tr>
                <th colspan="2">BAGGAGE No.{{ $i + 1 }}</th>
            </tr>
            <tr>
                <th>BAG NUMBER</th>
                <td>{{ $tag_no }}</td>
            </tr>
            <tr>
                <th>COLOUR/TYPE</th>
                <td>{{ $color_and_type }}</td>
            </tr>

            @php $details = $eachBag->details @endphp
            @foreach($details as $item)
                @php $flight_date_route = $item->flight_number ."/". baseDateFormat($item->date_time) ."/" @endphp
                @php $flight_date_route .= ($item->departureAirport ? $item->departureAirport->iata : "") . "-" @endphp
                @php $flight_date_route .= ($item->arrivalAirport ? $item->arrivalAirport->iata : "") @endphp

                @if (!(isset($previousFlight) && $previousFlight == $flight_date_route))
                    <tr>
                        <th>FLIGHT/DATE/ROUTE</th>
                        <td>{{ strtoupper($flight_date_route) }}</td>
                    </tr>
                @endif

                @php $previousFlight = $flight_date_route @endphp
            @endforeach

            <tr>
                <td colspan="2"><hr></td>
            </tr>

        @endforeach
        <tr>
            <td colspan="2">
                PLEASE RETAIN PASSENGER TICKET AND BAGGAGE CHECK.<br/><br/>
                THIS REPORT DOES NOT INVOLVE ANY ACKNOWLEDGEMENT OF LIABILITY
            </td>
        </tr>
        </tbody>
    </table>

    @if ($signature)
        <br/>
        <br/>
        <br/>
        <br/>
        <br/>
        <br/>
        <h3 align="left">Signature _____________________________ <span style="margin-left: 50px">Date _________________________________</span>
        </h3>
    @endif

</page>


</html>
