<div id="basic_info">
    <h4 style="margin-top: 20px">Basic Information</h4>

    <!-- Large modal -->
    <table class="table table-striped table-bordered table-hover">
        <thead>
        </thead>
        <tbody>
        <tr>
            <td class="td_header color-red">@lang("content.type")*</td>
            <td>{!! Form::select('type_id', $mhb_types, \request("type_id"), ['class' => 'input-sm form-control', 'id' => 'mhb_type']) !!}</td>
            <td colspan="7"></td>
        </tr>
        <tr>
            <td class="td_header">Airport</td>
            <td>{!! Form::select('apt_id', $airports, \request("apt_id"), ['class' => 'input-sm form-control']) !!}</td>
            <td class="td_header">Carrier</td>
            <td>{!! Form::text('current_carrier', $CURRENT_IATA_CODE, ['class'=>'form-control input-sm', 'placeholder'=>'', 'readonly']) !!}</td>
            <td class="td_header">File Reference</td>
            <td>{!! Form::text('file_ref', $file_reference, ['class'=>'form-control input-sm', 'placeholder'=>'', 'readonly']) !!}</td>
            <td class="td_header">LZ IND</td>
            <td colspan="2">{!! Form::text('lz_ind', "", ['class'=>'form-control input-sm', 'placeholder'=>'', 'readonly']) !!}</td>
        </tr>
        <tr>
            <td class="td_header">Passenger Last Name</td>
            <td>{!! Form::text('lname', \request("lname"), ['class'=>'form-control input-sm', 'placeholder'=>'']) !!}</td>
            <td class="td_header">Initials</td>
            <td>{!! Form::text('init', \request("init"), ['class'=>'form-control input-sm', 'placeholder'=>'']) !!}</td>
            <td class="td_header">Title</td>
            <td>{!! Form::text('title', "", ['class'=>'form-control input-sm', 'placeholder'=>'']) !!}</td>
            <td colspan="5"></td>
        </tr>
        </tbody>
    </table>

    <div class="baggage-info" data-number="1" style="clear: both; float: none; margin: 10px 0; display: inline-block;">

        <h4 style="background-color: rgba(56, 113, 207, 0.8); color: #ffffff; width: 80%; padding: 10px; margin: 0"><strong>Baggage No.<span class="baggage_num">1</span></strong></h4>

        <div class="col-md-12" style="padding: 0; margin: 0; border: 2px solid rgba(56, 113, 207, 0.8); border-bottom: 0">
            <table class="table table-striped table-bordered table-hover" style="">
                <thead>
                </thead>
                <tbody>
                <tr>
                    <td class="td_header">Baggage Tag No.</td>
                    <td>
                        {!! Form::text('carrier[]', \request("carrier"), ['class' => 'input-sm form-control input-50-floated airline', 'placeholder'=>'Carrier/Handling Agency']) !!}
                        {!! Form::text('bag_tag[]', \request("bag_tag"), ['class'=>'form-control input-150-floated input-sm', 'placeholder'=>'Tag No.']) !!}</td>
                    <td class="td_header">@lang("content.type")</td>
                    <td>
                        {{--Baggage Type--}}
                        <div class="form-group">
                            {!! Form::select('bag_type[]', $baggage_types, \request("bag_type"), ['class' => 'input-sm margin_right float-left', 'id' => 'baggage_type']) !!}
                            <button type="button" class="btn btn-primary btn-sm float-left details" data-toggle="modal"
                                    data-target=".bs-example-modal-lg">Bag Type
                            </button>
                            <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog"
                                 aria-labelledby="myLargeModalLabel">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content" style="overflow:hidden; padding: 10px 0;">
                                        <h3 style="padding: 0 10px;">Baggage Identification Chart</h3>
                                        <h4 style="padding: 0 10px;">Please Pick A Baggage Type</h4>
                                        @php $j = 0 @endphp
                                        @foreach($baggage_types as $each)
                                            @if ($j % 5 == 0)
                                                <div class="col-lg-12" style="display: block; background-color: white">
                                                    @endif

                                                    <img width="150px" height="135px"
                                                         class="img-hover img-baggage-color" data-color="{{ $each }}"
                                                         src="{{ asset("/assets/img/mhb/types/{$each}.jpg") }}"/>

                                                    @if ($j % 5 == 4)
                                                </div>
                                            @endif

                                            @php $j++ @endphp
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>

                    <td class="td_header">
                        <div class="form-group">
                            {!! Form::select('bag_clr[]', $baggage_colors, \request("bag_clr"), ['class' => 'input-sm margin_right float-left', 'id' => 'baggage_color']) !!}
                            <button type="button" class="btn btn-primary btn-sm float-left details" data-toggle="modal"
                                    data-target=".bs-modal-baggage-colors">Bag Colour
                            </button>
                            <div class="modal fade bs-modal-baggage-colors" tabindex="-1" role="dialog"
                                 aria-labelledby="myLargeModalLabel">
                                <div class="modal-dialog modal-sm">
                                    <div class="modal-content" style="overflow:hidden; padding: 10px 0;">
                                        <h3 style="padding: 0 10px;">Color Codes</h3>
                                        <h4 style="padding: 0 10px;">Please Pick A Color</h4>
                                        @php $j = 0 @endphp
                                        @foreach($baggage_colors as $each)
                                            @if ($j % 3 == 0)
                                                <div class="col-lg-12" style="display: block; background-color: white">
                                                    @endif

                                                    <img width="67px" height="42px" class="img-hover img-baggage-color"
                                                         data-color="{{ $each }}"
                                                         src="{{ asset("/assets/img/mhb/colors/{$each}.jpg") }}"/>

                                                    @if ($j % 3 == 2)
                                                </div>
                                            @endif

                                            @php $j++ @endphp
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <label><strong>Wheels</strong> {!! Form::checkbox('bag1_whs', "1", \request("whs") == "1" ? true : false, ['class' => 'big-checkbox', 'data-type' => 'whs']) !!}
                        </label>
                    </td>
                    <td class="td_header">Brand Name of Bag</td>
                    <td>{!! Form::text('brand[]', \request("brand"), ['class'=>'form-control input-sm brand', 'placeholder'=>'Type to Search']) !!}</td>

                </tr>
                <tr>
                    <td class="td_header">Contents</td>
                    <td colspan="7">{!! Form::text('contents[]', \request("contents"), ['class'=>'form-control input-sm', 'placeholder'=>'']) !!}</td>
                </tr>

                <tr class="damage-info-container">
                    <td colspan="9" style="padding: 0 !important; margin: 0 !important;">
                        <div class="panel panel-success" style="border: 0;">
                            <div class="panel-heading" role="tab">
                                <h4 class="panel-title">
                                    <a class="collapsed" role="button" data-toggle="collapse" data-role="damage-title"
                                       data-number="1" href="#damage_1" style="color: black; font-weight: bold; font-size: 14px;">
                                        Damage Info
                                    </a>
                                </h4>
                            </div>
                            <div id="damage_1" class="panel-collapse collapse" role="tabpanel"
                                 data-role="damage-content">
                                <div class="panel-body">
                                    @include('mhb.create-form-damage-info-tab')
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>

                {{--Damage Info--}}

                </tbody>
            </table>
        </div>

        <div class="col-md-12 flights" style="padding: 0; border-left: 2px solid #5471cc; border-right: 2px solid #5471cc; " data-flights_number="1">
            <table class="table table-striped table-bordered table-hover" style="margin-top: 0; ">
                <tbody>
                <tr>

                    <td class="td_header">Departure Airport</td>
                    <td class="td_header">Arrival Airport</td>
                    <td class="td_header">Flight No.</td>
                    <td class="td_header">Date/STD</td>
                    <td class="td_header">Date/STA</td>
                    <td class="td_header">Date/ATA</td>
                </tr>
                <tr>
                    <td>{!! Form::text('dep_apt1[]', \request("dep_apt1"), ['class'=>'form-control input-sm airport', 'data-name' => 'dep_apt', 'placeholder'=>'Type to Search']) !!}</td>
                    <td>{!! Form::text('arr_apt1[]', \request("arr_apt1"), ['class'=>'form-control input-sm airport', 'data-name' => 'arr_apt','placeholder'=>'Type to Search']) !!}</td>
                    <td>{!! Form::text('flt_no1[]', \request("flt_no1"), ['class'=>'form-control input-sm', 'data-name' => 'flt_no',]) !!}</td>
                    <td>{!! Form::text('date1[]', \request("date1"), ['class'=>'form-control datetimepicker input-sm', 'data-name' => 'date', 'placeholder'=>'Select', 'required' => 'required']) !!}</td>
                    <td>{!! Form::text('sta1[]', \request("sta1"), ['class'=>'form-control datetimepicker input-sm', 'data-name' => 'sta', 'placeholder'=>'Select']) !!}</td>
                    <td>{!! Form::text('ata1[]', \request("ata1"), ['class'=>'form-control datetimepicker input-sm', 'data-name' => 'ata', 'placeholder'=>'Select']) !!}</td>
                </tr>
                </tbody>
            </table>
        </div>

        <div class="col-sm-12" style="background-color: rgba(50, 147, 50, 0.8); color: #ffffff;  border: 2px solid #5471cc; border-top: 0">
            <div class="col-xs-2">
                <h5><strong>Add/Remove Flight</strong></h5>
            </div>
            <i class="fa fa-lg fa-fw fa-plus-circle add_flight" style="font-size: 30px; line-height: 45px; cursor: pointer;"></i>
            <i class="fa fa-lg fa-fw fa-minus-circle remove_flight" style="font-size: 30px; line-height: 45px;cursor: pointer;"></i>
        </div>

    </div>

    <div class="col-lg-12" style="background-color: rgba(56, 113, 207, 0.8); color: #FFFFFF; width: 60%; margin: 5px 0">
        <div class="col-xs-10">
            <h5><strong>Add/Remove Baggage</strong></h5>
        </div>
        <i class="fa fa-lg fa-fw fa-plus-circle" id="add_baggage" style="font-size: 30px; line-height: 45px;cursor: pointer;"></i>
        <i class="fa fa-lg fa-fw fa-minus-circle" id="remove_baggage" style="font-size: 30px; line-height: 45px;cursor: pointer;"></i>
    </div>

    <table class="table table-striped table-bordered table-hover">
        <thead>
        </thead>
        <tbody>
        <tr>
            <td class="td_header">Forwarding Instructions</td>
            <td colspan="9">{!! Form::textarea('forw_instr', \request("forw_instr"), ['class'=>'form-control input-sm', 'rows' => 2, 'placeholder'=>'']) !!}</td>
        </tr>
        </tbody>
    </table>


</div>
