<div class="col-md-12 no-padding margin-bottom-10">
    <a href="{{ route("homepage")."#". url("library/create#").rand(0, 1000) }}" class="btn btn-primary">@lang("content.add")</a>
</div>

<div class="clearfix"></div>

<ul class="nav nav-tabs bordered">
    <li class="active">
        <a href="#library_all" role="tab" data-toggle="tab">All</a>
    </li>

    @if ($readAndSignPermission)
        <li class="">
            <a href="#library_read_and_sign" class="color-green" role="tab" data-toggle="tab">Read & Sign</a>
        </li>
    @endif

    @foreach($categories as $i => $category)
        <li>
            <a href="#cat_{{ $i }}" role="tab" data-toggle="tab">{{ $category }}</a>
        </li>
    @endforeach

    <li class="">
        <a href="#library_deleted" role="tab" data-toggle="tab" class="color-red">Deleted</a>
    </li>
</ul>

@php $active = 0 @endphp
<div class="tab-content padding-10 background-white">

    <div class="tab-pane active" id="library_all">
        @include("library.layouts.library-table")
    </div>

    @if ($readAndSignPermission)
        <div class="tab-pane" id="library_read_and_sign">
            @include("library.layouts.library-read-and-sign-table", ["library" => $libraryReadAndSign])
        </div>
    @endif

    @foreach($categories as $i => $category)
        <div class="tab-pane" id="cat_{{ $i }}">
            @php $data = $library->where("category", $category)->all() @endphp
            @include("library.layouts.library-table", ["library" => $data] )
        </div>
    @endforeach

    <div class="tab-pane" id="library_deleted">
        @include("library.layouts.library-table", ["library" => $libraryDeleted])
    </div>
</div>