<div class="col-md-12 no-padding margin-bottom-10">
    <a href="{{ route("homepage")."#". url("library/create?s=".rand(100, 999)."&department_id={$department->id}") }}" class="btn btn-primary">@lang("content.add")</a>
</div>

<div class="clearfix"></div>

@if (isset($departmentsLibrary[$department->id]) && count($departmentsLibrary[$department->id]))
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-library-tab" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive editable_div">

                <table class="table table-bordered table-hover" id="licenses-table">
                    <thead>
                    <tr>
                        <th rowspan="2">No</th>
                        <th rowspan="2">@lang("content.name")</th>
                        <th rowspan="2">@lang("content.abbr")</th>
                        <th rowspan="2">@lang("content.type")</th>
                        <th rowspan="2" style="min-width: 90px">@lang("content.issue_date")</th>
                        <th rowspan="2" style="min-width: 90px">@lang("content.effective_date")</th>
                        <th rowspan="2">@lang("content.edition_no")</th>
                        <th colspan="2" data-center>@lang("content.uploaded")</th>
                        <th colspan="2" data-center>@lang("content.updated")</th>
                        <th rowspan="2" style="min-width: 220px;">@lang("content.attachment")</th>
                        <th rowspan="2" style="min-width: 140px;">@lang("content.actions")</th>
                    </tr>
                    <tr>
                        <th style="min-width: 120px" data-center>@lang("content.datetime")</th>
                        <th data-center>@lang("content.user")</th>

                        <th style="min-width: 120px" data-center>@lang("content.datetime")</th>
                        <th data-center>@lang("content.user")</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($departmentsLibrary[$department->id] as $i => $each)
                        @php $fileExists = $each->attachment_file ? true : false @endphp
                        <tr>
                            <td data-center>{{ $i + 1 }}</td>
                            <td>{{ $each->name }}</td>
                            <td>{{ $each->abbr }}</td>
                            <td>{{ $each->type }}</td>
                            <td>{{ $each->issue_date && $each->issue_date != EMPTY_DATE ? baseDateFormat($each->issue_date) : "" }}</td>
                            <td>{{ $each->effective_date && $each->effective_date != EMPTY_DATE ? baseDateFormat($each->effective_date) : "" }}</td>
                            <td>{{ $each->edition_no }}</td>

                            <td>{{ baseDateFormat($each->created_at, true) }}</td>
                            <td>{{ getUserName($each->createdBy) }}</td>

                            <td>
                                {{ $each->updated_at && $each->issue_date != EMPTY_DATETIME ? baseDateFormat($each->updated_at, true) : "" }}
                                {!! $each->deleted_at ? '<span class="label label-danger">'.trans("content.removed").'</span>' : "" !!}
                            </td>
                            <td>{{ getUserName($each->updatedBy) }}</td>
                            <td>
                                @if ($fileExists)
                                    <div class="btn-group">
                                        <a target="_blank" href="{{ url("library/file/{$each->id}") }}?view=1" class="btn btn-warning">@lang("content.view")</a>
                                        <a href="{{ url("library/file/{$each->id}") }}?download=1" class="btn btn-primary">@lang("content.download")</a>
                                        <a href="{{ route("homepage")."#". url("library/file/delete/{$each->id}") }}" class="btn btn-danger">@lang("content.remove")</a>
                                    </div>
                                @elseif (!$each->deleted_at)
                                    <div class="upload-container" style="padding: 0;" >
                                        {!! Form::open(['files' => true, 'method' => 'POST', "class" => "library-forms", 'url' => url("library/file/{$each->id}")]) !!}
                                            {!! Form::file('file') !!}
                                            <br/>
                                            {!! Form::submit( trans("content.upload"), ['class' => 'btn btn-success', 'name' => 'upload']) !!}
                                        {!! Form::close() !!}
                                    </div>
                                @endif
                            </td>
                            <td>
                                @if (!$each->deleted_at)
                                    <div class="btn-group">
                                        <a target="_blank" href="{{ route("homepage")."#". url("library/{$each->id}/edit") }}" class="btn btn-warning">@lang("content.edit")</a>
                                        <a href="{{ route("homepage")."#". url("library/delete/{$each->id}") }}" class="btn btn-danger">@lang("content.remove")</a>
                                    </div>
                                @endif
                            </td>
                        </tr>

                    @endforeach

                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>
@else
    <div class="alert alert-info" role="alert">
        <a href="#" class="alert-link">@lang("content.info")<br/></a>
        @lang("content.found") 0 @lang("content.records")
    </div>
@endif
